/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.validation;

import java.io.File;
import org.junit.Assert;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.plugins.pt_assistant.AbstractTest;
import org.openstreetmap.josm.plugins.pt_assistant.ImportUtils;
import org.openstreetmap.josm.plugins.pt_assistant.validation.NodeChecker;
import org.openstreetmap.josm.plugins.pt_assistant.validation.PTAssistantValidatorTest;
import org.openstreetmap.josm.plugins.pt_assistant.validation.StopChecker;

public class StopCheckerTest
extends AbstractTest {
    @org.junit.Test
    public void nodePartOfStopAreaTest() {
        File file = new File("test/data/stop-area-members.osm");
        DataSet ds = ImportUtils.importOsmFile(file, "testLayer");
        PTAssistantValidatorTest test = new PTAssistantValidatorTest();
        Node node = null;
        for (Node n : ds.getNodes()) {
            if (!(n.hasTag("public_transport", "stop_position") | n.hasTag("public_transport", "platform"))) continue;
            node = n;
        }
        NodeChecker nodeChecker = new NodeChecker(node, (Test)test);
        nodeChecker.performNodePartOfStopAreaTest();
        Assert.assertEquals((long)nodeChecker.getErrors().size(), (long)1L);
        Assert.assertEquals((long)nodeChecker.getErrors().get(0).getCode(), (long)3761L);
    }

    @org.junit.Test
    public void stopAreaRelationsTest() {
        File file = new File("test/data/stop-area-relations.osm");
        DataSet ds = ImportUtils.importOsmFile(file, "testLayer");
        PTAssistantValidatorTest test = new PTAssistantValidatorTest();
        Relation stopArea = null;
        for (Relation r : ds.getRelations()) {
            if (!r.hasTag("public_transport", "stop_area")) continue;
            stopArea = r;
        }
        StopChecker stopChecker = new StopChecker(stopArea, (Test)test);
        stopChecker.performStopAreaRelationsTest();
        Assert.assertEquals((long)stopChecker.getErrors().size(), (long)1L);
        Assert.assertEquals((long)stopChecker.getErrors().get(0).getCode(), (long)3764L);
    }

    @org.junit.Test
    public void stopAreaStopPositionTest() {
        File file = new File("test/data/stop-area-no-stops.osm");
        DataSet ds = ImportUtils.importOsmFile(file, "testLayer");
        PTAssistantValidatorTest test = new PTAssistantValidatorTest();
        Relation stopArea = null;
        for (Relation r : ds.getRelations()) {
            if (!r.hasTag("public_transport", "stop_area")) continue;
            stopArea = r;
        }
        StopChecker stopChecker = new StopChecker(stopArea, (Test)test);
        stopChecker.performStopAreaStopPositionTest();
        Assert.assertEquals((long)stopChecker.getErrors().size(), (long)1L);
        Assert.assertEquals((long)stopChecker.getErrors().get(0).getCode(), (long)3762L);
    }

    @org.junit.Test
    public void stopAreaPlatformTest() {
        File file = new File("test/data/stop-area-no-platform.osm");
        DataSet ds = ImportUtils.importOsmFile(file, "testLayer");
        PTAssistantValidatorTest test = new PTAssistantValidatorTest();
        Relation stopArea = null;
        for (Relation r : ds.getRelations()) {
            if (!r.hasTag("public_transport", "stop_area")) continue;
            stopArea = r;
        }
        StopChecker stopChecker = new StopChecker(stopArea, (Test)test);
        stopChecker.performStopAreaPlatformTest();
        Assert.assertEquals((long)stopChecker.getErrors().size(), (long)1L);
        Assert.assertEquals((long)stopChecker.getErrors().get(0).getCode(), (long)3763L);
    }
}

