/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.validation;

import java.io.File;
import java.util.ArrayList;
import org.junit.Assert;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.plugins.pt_assistant.AbstractTest;
import org.openstreetmap.josm.plugins.pt_assistant.ImportUtils;
import org.openstreetmap.josm.plugins.pt_assistant.validation.PTAssistantValidatorTest;
import org.openstreetmap.josm.plugins.pt_assistant.validation.RouteChecker;
import org.openstreetmap.josm.plugins.pt_assistant.validation.WayChecker;

public class PlatformAsWayTest
extends AbstractTest {
    @org.junit.Test
    public void sortingTest() {
        File file = new File("test/data/route-with-platform-as-way.osm");
        DataSet ds = ImportUtils.importOsmFile(file, "testLayer");
        PTAssistantValidatorTest test = new PTAssistantValidatorTest();
        ArrayList<TestError> errors = new ArrayList<TestError>();
        for (Relation r : ds.getRelations()) {
            WayChecker wayChecker = new WayChecker(r, (Test)test);
            wayChecker.performDirectionTest();
            wayChecker.performRoadTypeTest();
            errors.addAll(wayChecker.getErrors());
            RouteChecker routeChecker = new RouteChecker(r, (Test)test);
            routeChecker.performSortingTest();
            errors.addAll(routeChecker.getErrors());
        }
        Assert.assertEquals((long)errors.size(), (long)0L);
    }
}

