/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.actions;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.SplitWayAction;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.OsmReader;
import org.openstreetmap.josm.plugins.pt_assistant.AbstractTest;
import org.openstreetmap.josm.plugins.pt_assistant.actions.SplitRoundaboutAction;
import org.openstreetmap.josm.testutils.JOSMTestRules;

public class SplitRoundaboutTest
extends AbstractTest {
    @Rule
    public JOSMTestRules rules = new JOSMTestRules().preferences().platform();
    private DataSet ds;
    private OsmDataLayer layer;
    private SplitRoundaboutAction action;
    private Way r1;
    private Way r2;
    private Way r3;
    private Way r4;

    @Before
    public void init() throws FileNotFoundException, IllegalDataException {
        this.ds = OsmReader.parseDataSet((InputStream)new FileInputStream("test/data/roundabout.osm"), null);
        this.layer = new OsmDataLayer(this.ds, OsmDataLayer.createNewName(), null);
        Main.getLayerManager().addLayer((Layer)this.layer);
        Main.pref.put("pt_assistant.roundabout-splitter.alignalways", true);
        this.action = new SplitRoundaboutAction();
        this.r1 = (Way)this.ds.getPrimitiveById((PrimitiveId)new SimplePrimitiveId(293302077L, OsmPrimitiveType.WAY));
        this.r2 = (Way)this.ds.getPrimitiveById((PrimitiveId)new SimplePrimitiveId(205833435L, OsmPrimitiveType.WAY));
        this.r3 = (Way)this.ds.getPrimitiveById((PrimitiveId)new SimplePrimitiveId(25739002L, OsmPrimitiveType.WAY));
        this.r4 = (Way)this.ds.getPrimitives(p -> p.hasTag("name", "r4")).iterator().next();
    }

    private Collection<Way> splitWay(Way w) {
        Map<Relation, List<Integer>> savedPositions = this.action.getSavedPositions(w);
        this.action.getRemoveRoundaboutFromRelationsCommand(w).executeCommand();
        List<Node> splitNodes = this.action.getSplitNodes(w);
        SplitWayAction.SplitWayResult result = SplitWayAction.split((OsmDataLayer)this.layer, (Way)w, splitNodes, Collections.emptyList());
        result.getCommand().executeCommand();
        List splitWays = result.getNewWays();
        splitWays.add(result.getOriginalWay());
        this.action.getUpdateRelationsCommand(savedPositions, splitNodes, splitWays).executeCommand();
        return splitWays;
    }

    @Test
    public void test1() {
        Collection<Way> sw1 = this.splitWay(this.r1);
        Assert.assertEquals((long)4L, (long)sw1.size());
        sw1.forEach(w -> {
            if (w.firstNode().getUniqueId() == 267843779L && w.lastNode().getUniqueId() == 2968718407L) {
                Assert.assertEquals((long)5L, (long)w.getReferrers().size());
            } else if (w.firstNode().getUniqueId() == 2968718407L && w.lastNode().getUniqueId() == 2383688231L) {
                Assert.assertEquals((long)0L, (long)w.getReferrers().size());
            } else if (w.firstNode().getUniqueId() == 2383688231L && w.lastNode().getUniqueId() == 267843741L) {
                Assert.assertEquals((long)5L, (long)w.getReferrers().size());
            } else if (w.firstNode().getUniqueId() == 267843741L && w.lastNode().getUniqueId() == 267843779L) {
                Assert.assertEquals((long)0L, (long)w.getReferrers().size());
            } else {
                Assert.fail();
            }
        });
    }

    @Test
    public void test2() {
        Collection<Way> sw2 = this.splitWay(this.r2);
        Assert.assertEquals((long)4L, (long)sw2.size());
        sw2.forEach(w -> {
            if (w.firstNode().getUniqueId() == 2158181809L && w.lastNode().getUniqueId() == 2158181798L) {
                Assert.assertEquals((long)8L, (long)w.getReferrers().size());
            } else if (w.firstNode().getUniqueId() == 2158181798L && w.lastNode().getUniqueId() == 2158181789L) {
                Assert.assertEquals((long)0L, (long)w.getReferrers().size());
            } else if (w.firstNode().getUniqueId() == 2158181789L && w.lastNode().getUniqueId() == 2158181803L) {
                Assert.assertEquals((long)8L, (long)w.getReferrers().size());
            } else if (w.firstNode().getUniqueId() == 2158181803L && w.lastNode().getUniqueId() == 2158181809L) {
                Assert.assertEquals((long)0L, (long)w.getReferrers().size());
            } else {
                Assert.fail();
            }
        });
    }

    @Test
    public void test3() {
        Collection<Way> sw3 = this.splitWay(this.r3);
        Assert.assertEquals((long)4L, (long)sw3.size());
        sw3.forEach(w -> {
            if (w.firstNode().getUniqueId() == 280697532L && w.lastNode().getUniqueId() == 280697452L) {
                Assert.assertEquals((long)0L, (long)w.getReferrers().size());
            } else if (w.firstNode().getUniqueId() == 280697452L && w.lastNode().getUniqueId() == 280697591L) {
                Assert.assertEquals((long)2L, (long)w.getReferrers().size());
            } else if (w.firstNode().getUniqueId() == 280697591L && w.lastNode().getUniqueId() == 280697534L) {
                Assert.assertEquals((long)0L, (long)w.getReferrers().size());
            } else if (w.firstNode().getUniqueId() == 280697534L && w.lastNode().getUniqueId() == 280697532L) {
                Assert.assertEquals((long)1L, (long)w.getReferrers().size());
            } else {
                Assert.fail();
            }
        });
    }

    @Test
    public void test4() {
        Collection<Way> sw4 = this.splitWay(this.r4);
        Assert.assertEquals((long)10L, (long)sw4.size());
        Node entry11 = (Node)this.ds.getPrimitives(p -> p.hasTag("name", "nentry1-1")).iterator().next();
        Node exit11 = (Node)this.ds.getPrimitives(p -> p.hasTag("name", "nexit1-1")).iterator().next();
        Node entry12 = (Node)this.ds.getPrimitives(p -> p.hasTag("name", "nentry1-2")).iterator().next();
        Node exit12 = (Node)this.ds.getPrimitives(p -> p.hasTag("name", "nexit1-2")).iterator().next();
        Node entry21 = (Node)this.ds.getPrimitives(p -> p.hasTag("name", "nentry2-1")).iterator().next();
        Node exit21 = (Node)this.ds.getPrimitives(p -> p.hasTag("name", "nexit2-1")).iterator().next();
        Node entry22 = (Node)this.ds.getPrimitives(p -> p.hasTag("name", "nentry2-2")).iterator().next();
        Node exit22 = (Node)this.ds.getPrimitives(p -> p.hasTag("name", "nexit2-2")).iterator().next();
        Node entry3 = (Node)this.ds.getPrimitives(p -> p.hasTag("name", "nentry3")).iterator().next();
        Node exit3 = (Node)this.ds.getPrimitives(p -> p.hasTag("name", "nexit3")).iterator().next();
        sw4.forEach(w -> {
            if (w.firstNode().equals((Object)entry11) && w.lastNode().equals((Object)exit22)) {
                Assert.assertEquals((long)2L, (long)w.getReferrers().size());
            } else if (w.firstNode().equals((Object)exit22) && w.lastNode().equals((Object)entry21)) {
                Assert.assertEquals((long)1L, (long)w.getReferrers().size());
            } else if (w.firstNode().equals((Object)entry21) && w.lastNode().equals((Object)exit11)) {
                Assert.assertEquals((long)2L, (long)w.getReferrers().size());
            } else if (w.firstNode().equals((Object)exit11) && w.lastNode().equals((Object)entry12)) {
                Assert.assertEquals((long)1L, (long)w.getReferrers().size());
            } else if (w.firstNode().equals((Object)entry12) && w.lastNode().equals((Object)entry3)) {
                Assert.assertEquals((long)2L, (long)w.getReferrers().size());
            } else if (w.firstNode().equals((Object)entry3) && w.lastNode().equals((Object)exit21)) {
                Assert.assertEquals((long)3L, (long)w.getReferrers().size());
            } else if (w.firstNode().equals((Object)exit21) && w.lastNode().equals((Object)entry22)) {
                Assert.assertEquals((long)2L, (long)w.getReferrers().size());
            } else if (w.firstNode().equals((Object)entry22) && w.lastNode().equals((Object)exit3)) {
                Assert.assertEquals((long)3L, (long)w.getReferrers().size());
            } else if (w.firstNode().equals((Object)exit3) && w.lastNode().equals((Object)exit12)) {
                Assert.assertEquals((long)2L, (long)w.getReferrers().size());
            } else if (w.firstNode().equals((Object)exit12) && w.lastNode().equals((Object)entry11)) {
                Assert.assertEquals((long)1L, (long)w.getReferrers().size());
            } else {
                Assert.fail();
            }
        });
    }
}

