/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.actions;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.OsmReader;
import org.openstreetmap.josm.plugins.pt_assistant.AbstractTest;
import org.openstreetmap.josm.plugins.pt_assistant.actions.SortPTStopsAction;
import org.openstreetmap.josm.testutils.JOSMTestRules;

public class SortPTStopsActionTest
extends AbstractTest {
    @Rule
    public JOSMTestRules rules = new JOSMTestRules().preferences().platform();
    private DataSet ds;

    @Before
    public void init() throws FileNotFoundException, IllegalDataException {
        this.ds = OsmReader.parseDataSet((InputStream)new FileInputStream("test/data/sort_test.osm"), null);
    }

    @Test
    public void test1() {
        Relation rel = (Relation)this.ds.getPrimitiveById((PrimitiveId)new SimplePrimitiveId(7367762L, OsmPrimitiveType.RELATION));
        new SortPTStopsAction().sortPTStops(rel);
        Assert.assertEquals((Object)"Acitillo - Istituto Fortunato", (Object)rel.getMember(0).getNode().getName());
        Assert.assertEquals((Object)"Ribera - Gemito", (Object)rel.getMember(1).getNode().getName());
        Assert.assertEquals((Object)"Gemito - Stadio Collana", (Object)rel.getMember(2).getNode().getName());
        Assert.assertEquals((Object)"Cilea 21", (Object)rel.getMember(3).getNode().getName());
        Assert.assertEquals((Object)"Cimarosa", (Object)rel.getMember(4).getNode().getName());
        Assert.assertEquals((Object)"Cimarosa Floridiana - Farmacia Orlando", (Object)rel.getMember(5).getNode().getName());
        Assert.assertEquals((Object)"Bernini - Fuga", (Object)rel.getMember(6).getNode().getName());
        Assert.assertEquals((Object)"Bernini - Solimene", (Object)rel.getMember(7).getNode().getName());
        Assert.assertEquals((Object)"Bernini-Fanzago - Centro Diagnostico Basile", (Object)rel.getMember(8).getNode().getName());
        Assert.assertEquals((Object)"Fiore-Santobono - Centro Diagnostico Basile", (Object)rel.getMember(9).getNode().getName());
        Assert.assertEquals((Object)"Niutta Medaglie d'Oro - Analisi Cliniche Pasteur", (Object)rel.getMember(10).getNode().getName());
        Assert.assertEquals((Object)"Niutta Muzii - Analisi Cliche Pasteur", (Object)rel.getMember(11).getNode().getName());
        Assert.assertEquals((Object)"Arenella Muzii - La Padella Rosticceria", (Object)rel.getMember(12).getNode().getName());
        Assert.assertEquals((Object)"Gigante - Orsi", (Object)rel.getMember(13).getNode().getName());
        Assert.assertEquals((Object)"Della Costituzione - Sottopasso", (Object)rel.getMember(14).getNode().getName());
        Assert.assertEquals((Object)"Della Costituzione - Isola B", (Object)rel.getMember(15).getNode().getName());
        Assert.assertEquals((Object)"Della Costituzione - Moro", (Object)rel.getMember(16).getNode().getName());
        Assert.assertEquals((Object)"Aulisio", (Object)rel.getMember(17).getNode().getName());
        Assert.assertEquals((Object)"Aulisio - Palazzo di Giustizia", (Object)rel.getMember(18).getNode().getName());
        Assert.assertEquals((Object)"Grimaldi - Procura", (Object)rel.getMember(19).getNode().getName());
        Assert.assertEquals((Object)"Biscradi", (Object)rel.getMember(20).getNode().getName());
        Assert.assertEquals((Object)"Nuova Poggioreale 160", (Object)rel.getMember(21).getNode().getName());
        Assert.assertEquals((Object)"Nuova Poggioreale Caramanico - Medicina Futura", (Object)rel.getMember(22).getNode().getName());
        Assert.assertEquals((Object)"Emiciclo Poggoreale", (Object)rel.getMember(23).getNode().getName());
    }

    @Test
    public void test2() {
        Relation rel = (Relation)this.ds.getPrimitives(p -> p.getType() == OsmPrimitiveType.RELATION && "150 Piazza Garibaldi \u2192 Osp. Monaldi".equals(p.getName())).iterator().next();
        new SortPTStopsAction().sortPTStops(rel);
        Assert.assertNull((Object)rel.getMember(0).getNode().getName());
        Assert.assertEquals((Object)"Alibus Airport Shuttle", (Object)rel.getMember(1).getNode().getName());
        Assert.assertEquals((Object)"Piazza Garibaldi - Poerio", (Object)rel.getMember(2).getNode().getName());
        Assert.assertEquals((Object)"Piazza Principe Umberto", (Object)rel.getMember(3).getNode().getName());
        Assert.assertEquals((Object)"Ponte Casanova - Ist. Sogliano", (Object)rel.getMember(4).getNode().getName());
        Assert.assertEquals((Object)"Ponte Casanova - Novara", (Object)rel.getMember(5).getNode().getName());
        Assert.assertEquals((Object)"Piazza Nazionale", (Object)rel.getMember(6).getNode().getName());
        Assert.assertEquals((Object)"Nuova Poggioreale - Corso Malta", (Object)rel.getMember(7).getNode().getName());
        Assert.assertEquals((Object)"Grimaldi - Procura", (Object)rel.getMember(8).getNode().getName());
        Assert.assertEquals((Object)"D'Aulisio 14 FR", (Object)rel.getMember(9).getNode().getName());
        Assert.assertEquals((Object)"Della Costituzione - Moro", (Object)rel.getMember(10).getNode().getName());
        Assert.assertEquals((Object)"Della Costituzione - Isola G", (Object)rel.getMember(11).getNode().getName());
        Assert.assertEquals((Object)"Malta - Zara", (Object)rel.getMember(12).getNode().getName());
        Assert.assertEquals((Object)"Arenella Muzzi - La Padella Rosticceria", (Object)rel.getMember(13).getNode().getName());
        Assert.assertEquals((Object)"Palermo - Arenella", (Object)rel.getMember(14).getNode().getName());
        Assert.assertEquals((Object)"Fontana 60", (Object)rel.getMember(15).getNode().getName());
        Assert.assertEquals((Object)"Fontana - Massari", (Object)rel.getMember(16).getNode().getName());
        Assert.assertEquals((Object)"Fontana - Presutti", (Object)rel.getMember(17).getNode().getName());
        Assert.assertEquals((Object)"Cavallino - Parco Ice Snei", (Object)rel.getMember(18).getNode().getName());
        Assert.assertEquals((Object)"Cavallino - Scuola Materna", (Object)rel.getMember(19).getNode().getName());
        Assert.assertEquals((Object)"Cavallino 77", (Object)rel.getMember(20).getNode().getName());
        Assert.assertEquals((Object)"Bernardo Cavallino - Pronto Soccorso Cardarelli", (Object)rel.getMember(21).getNode().getName());
        Assert.assertNull((Object)rel.getMember(22).getNode().getName());
        Assert.assertEquals((Object)"Cardarelli - Ospedale", (Object)rel.getMember(23).getNode().getName());
        Assert.assertEquals((Object)"Pietravalle - Gatto", (Object)rel.getMember(24).getNode().getName());
        Assert.assertEquals((Object)"Pietravalle - De Amicis", (Object)rel.getMember(25).getNode().getName());
        Assert.assertEquals((Object)"Pansini - Policlinico", (Object)rel.getMember(26).getNode().getName());
        Assert.assertEquals((Object)"Montesano - Parcheggio M1", (Object)rel.getMember(27).getNode().getName());
        Assert.assertEquals((Object)"Montesano - Cangiani", (Object)rel.getMember(28).getNode().getName());
        Assert.assertEquals((Object)"L. Bianchi - Parco Angiola", (Object)rel.getMember(29).getNode().getName());
        Assert.assertEquals((Object)"Bianchi - Cangiani", (Object)rel.getMember(30).getNode().getName());
        Assert.assertEquals((Object)"Bianchi - Montelungo", (Object)rel.getMember(31).getNode().getName());
        Assert.assertNull((Object)rel.getMember(32).getNode().getName());
    }
}

