/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.validation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.dialogs.relation.sort.RelationSorter;
import org.openstreetmap.josm.gui.dialogs.relation.sort.WayConnectionType;
import org.openstreetmap.josm.gui.dialogs.relation.sort.WayConnectionTypeCalculator;
import org.openstreetmap.josm.plugins.pt_assistant.data.PTRouteDataManager;
import org.openstreetmap.josm.plugins.pt_assistant.data.PTStop;
import org.openstreetmap.josm.plugins.pt_assistant.utils.RouteUtils;
import org.openstreetmap.josm.plugins.pt_assistant.utils.StopToWayAssigner;
import org.openstreetmap.josm.plugins.pt_assistant.validation.Checker;
import org.openstreetmap.josm.tools.I18n;

public class RouteChecker
extends Checker {
    private boolean hasGap = false;
    List<RelationMember> sortedMembers;
    private PTRouteDataManager manager;
    private StopToWayAssigner assigner;

    public RouteChecker(Relation relation, Test test) {
        super(relation, test);
    }

    protected void performSortingTest() {
        ArrayList<RelationMember> waysToCheck = new ArrayList<RelationMember>();
        for (RelationMember rm : this.relation.getMembers()) {
            if (!RouteUtils.isPTWay(rm) || !rm.getType().equals((Object)OsmPrimitiveType.WAY)) continue;
            waysToCheck.add(rm);
        }
        if (waysToCheck.isEmpty()) {
            return;
        }
        int numOfGaps = this.countGaps(waysToCheck);
        if (numOfGaps > 0) {
            this.hasGap = true;
            RelationSorter sorter = new RelationSorter();
            this.sortedMembers = sorter.sortMembers(waysToCheck);
            int numOfGapsAfterSort = this.countGaps(this.sortedMembers);
            if (numOfGapsAfterSort == 0) {
                TestError.Builder builder = TestError.builder((Test)this.test, (Severity)Severity.WARNING, (int)3711);
                builder.message(I18n.tr((String)"PT: Route contains a gap that can be fixed by sorting", (Object[])new Object[0]));
                builder.primitives(new OsmPrimitive[]{this.relation});
                TestError e = builder.build();
                this.errors.add(e);
            } else if (numOfGapsAfterSort < numOfGaps) {
                TestError.Builder builder = TestError.builder((Test)this.test, (Severity)Severity.WARNING, (int)3712);
                builder.message(I18n.tr((String)"PT: Route gaps can decrease by sorting members. Further validations will be required", (Object[])new Object[0]));
                builder.primitives(new OsmPrimitive[]{this.relation});
                TestError e = builder.build();
                this.errors.add(e);
            }
        }
    }

    protected boolean performFromToTagsTest() {
        TestError e;
        TestError.Builder builder;
        String from = this.relation.get("from");
        String to = this.relation.get("to");
        if (from == null || to == null || this.manager.getPTStopCount() == 0) {
            return false;
        }
        boolean foundError = false;
        PTStop stop = this.manager.getFirstStop();
        OsmPrimitive primitive = this.checkPTStopName(stop, from);
        if (primitive != null) {
            builder = TestError.builder((Test)this.test, (Severity)Severity.WARNING, (int)3701);
            builder.message(I18n.tr((String)"PT: The name of the first stop does not match the \"from\" tag of the route relation", (Object[])new Object[0]));
            builder.primitives(new OsmPrimitive[]{primitive, this.relation});
            e = builder.build();
            this.errors.add(e);
            foundError = true;
        }
        if ((primitive = this.checkPTStopName(stop = this.manager.getLastStop(), to)) != null) {
            builder = TestError.builder((Test)this.test, (Severity)Severity.WARNING, (int)3701);
            builder.message(I18n.tr((String)"PT: The name of the last stop does not match the \"to\" tag of the route relation", (Object[])new Object[0]));
            builder.primitives(new OsmPrimitive[]{primitive, this.relation});
            e = builder.build();
            this.errors.add(e);
            foundError = true;
        }
        return foundError;
    }

    protected void performFirstLastWayStopTest() {
        TestError e;
        ArrayList<OsmPrimitive> prims;
        TestError.Builder builder;
        if (this.manager.getPTStopCount() == 0 || this.manager.getPTWayCount() == 0) {
            return;
        }
        PTStop stop = this.manager.getFirstStop();
        Way way = this.manager.getFirstWay();
        if (!way.equals((Object)this.assigner.get(stop))) {
            builder = TestError.builder((Test)this.test, (Severity)Severity.WARNING, (int)3702);
            builder.message(I18n.tr((String)"PT: The first stop of the route does not match the first way", (Object[])new Object[0]));
            prims = new ArrayList<OsmPrimitive>(Arrays.asList(way, this.relation));
            if (stop.getPlatform() != null) {
                prims.add(stop.getPlatform());
            }
            if (stop.getStopPosition() != null) {
                prims.add((OsmPrimitive)stop.getStopPosition());
            }
            builder.primitives(prims);
            e = builder.build();
            this.errors.add(e);
        }
        stop = this.manager.getLastStop();
        way = this.manager.getLastWay();
        if (!way.equals((Object)this.assigner.get(stop))) {
            builder = TestError.builder((Test)this.test, (Severity)Severity.WARNING, (int)3702);
            builder.message(I18n.tr((String)"PT: The last stop of the route does not match the last way", (Object[])new Object[0]));
            prims = new ArrayList<OsmPrimitive>(Arrays.asList(way, this.relation));
            if (stop.getPlatform() != null) {
                prims.add(stop.getPlatform());
            }
            if (stop.getStopPosition() != null) {
                prims.add((OsmPrimitive)stop.getStopPosition());
            }
            builder.primitives(prims);
            e = builder.build();
            this.errors.add(e);
        }
    }

    private OsmPrimitive checkPTStopName(PTStop stop, String name) {
        OsmPrimitive primitive = null;
        String toCheck = null;
        if (stop.getPlatform() != null) {
            toCheck = stop.getPlatform().getName();
            primitive = stop.getPlatform();
        }
        if (toCheck == null && stop.getStopPosition() != null) {
            toCheck = stop.getStopPosition().getName();
            primitive = stop.getStopPosition();
        }
        if (toCheck != null && !toCheck.equals(name)) {
            return primitive;
        }
        return null;
    }

    public boolean hasGaps(List<RelationMember> waysToCheck) {
        return this.countGaps(waysToCheck) > 0;
    }

    private int countGaps(List<RelationMember> waysToCheck) {
        int numberOfGaps = 0;
        WayConnectionTypeCalculator connectionTypeCalculator = new WayConnectionTypeCalculator();
        List links = connectionTypeCalculator.updateLinks(waysToCheck);
        int i = 0;
        while (i < links.size()) {
            WayConnectionType link = (WayConnectionType)links.get(i);
            if (i != 0 && !link.linkPrev || i != links.size() - 1 && !link.linkNext || link.direction == null || WayConnectionType.Direction.NONE.equals((Object)link.direction)) {
                ++numberOfGaps;
                ++i;
            }
            ++i;
        }
        return numberOfGaps;
    }

    public List<RelationMember> getSortedMembers() {
        return this.sortedMembers;
    }

    public boolean getHasGap() {
        return this.hasGap;
    }

    protected static Command fixSortingError(TestError testError) {
        if (testError.getCode() != 3711 && testError.getCode() != 3712) {
            return null;
        }
        Collection primitives = testError.getPrimitives();
        Relation originalRelation = (Relation)primitives.iterator().next();
        List members = originalRelation.getMembers();
        ArrayList<RelationMember> stops = new ArrayList<RelationMember>();
        ArrayList<RelationMember> ways = new ArrayList<RelationMember>();
        for (RelationMember member : members) {
            RelationMember modifiedMember;
            if (RouteUtils.isPTWay(member)) {
                if ("".equals(member.getRole())) {
                    ways.add(member);
                    continue;
                }
                modifiedMember = new RelationMember("", (OsmPrimitive)member.getWay());
                ways.add(modifiedMember);
                continue;
            }
            if ("stop_positon".equals(member.getRole())) {
                if (member.getType().equals((Object)OsmPrimitiveType.NODE)) {
                    modifiedMember = new RelationMember("stop", (OsmPrimitive)member.getNode());
                    stops.add(modifiedMember);
                    continue;
                }
                modifiedMember = new RelationMember("stop", (OsmPrimitive)member.getWay());
                stops.add(modifiedMember);
                continue;
            }
            stops.add(member);
        }
        RelationSorter sorter = new RelationSorter();
        List sortedWays = sorter.sortMembers(ways);
        Relation sortedRelation = new Relation(originalRelation);
        ArrayList<RelationMember> sortedRelationMembers = new ArrayList<RelationMember>(members.size());
        for (RelationMember rm : stops) {
            sortedRelationMembers.add(rm);
        }
        for (RelationMember rm : sortedWays) {
            sortedRelationMembers.add(rm);
        }
        sortedRelation.setMembers(sortedRelationMembers);
        return new ChangeCommand((OsmPrimitive)originalRelation, (OsmPrimitive)sortedRelation);
    }

    public PTRouteDataManager getManager() {
        return this.manager;
    }

    public void setManager(PTRouteDataManager manager) {
        this.manager = manager;
    }

    public StopToWayAssigner getAssigner() {
        return this.assigner;
    }

    public void setAssigner(StopToWayAssigner assigner) {
        this.assigner = assigner;
    }
}

