/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.relation.DownloadSelectedIncompleteMembersAction;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.dialogs.relation.DownloadRelationMemberTask;
import org.openstreetmap.josm.gui.dialogs.relation.sort.RelationSorter;
import org.openstreetmap.josm.plugins.pt_assistant.data.PTStop;
import org.openstreetmap.josm.plugins.pt_assistant.utils.RouteUtils;
import org.openstreetmap.josm.plugins.pt_assistant.utils.StopToWayAssigner;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class SortPTStopsAction
extends JosmAction {
    private static final String ACTION_NAME = "Sort PT Stops";

    public SortPTStopsAction() {
        super(ACTION_NAME, "icons/sortptstops", ACTION_NAME, null, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void actionPerformed(ActionEvent e) {
        Relation rel = (Relation)this.getLayerManager().getEditDataSet().getSelected().iterator().next();
        if (rel.hasIncompleteMembers()) {
            if (JOptionPane.showOptionDialog(Main.parent, I18n.tr((String)"The relation has incomplete members. Do you want to download them and continue with the sorting?", (Object[])new Object[0]), I18n.tr((String)"Incomplete Members", (Object[])new Object[0]), 0, 3, null, null, null) != 0) return;
            List<Relation> incomplete = Collections.singletonList(rel);
            Future<?> future = Main.worker.submit((Runnable)new DownloadRelationMemberTask(incomplete, (Collection)DownloadSelectedIncompleteMembersAction.buildSetOfIncompleteMembers(incomplete), Main.getLayerManager().getEditLayer()));
            Main.worker.submit(() -> {
                try {
                    future.get();
                    this.continueAfterDownload(rel);
                }
                catch (InterruptedException | ExecutionException e1) {
                    Main.error((Throwable)e1);
                    return;
                }
            });
            return;
        } else {
            this.continueAfterDownload(rel);
        }
    }

    private void continueAfterDownload(Relation rel) {
        Relation newRel = new Relation(rel);
        this.sortPTStops(newRel);
        Main.main.undoRedo.add((Command)new ChangeCommand((OsmPrimitive)rel, (OsmPrimitive)newRel));
    }

    public void sortPTStops(Relation rel) {
        List members = rel.getMembers();
        int i = 0;
        while (i < members.size()) {
            rel.removeMember(0);
            ++i;
        }
        members = new RelationSorter().sortMembers(members);
        ArrayList<RelationMember> stops = new ArrayList<RelationMember>();
        ArrayList<RelationMember> wayMembers = new ArrayList<RelationMember>();
        ArrayList<Way> ways = new ArrayList<Way>();
        int i2 = 0;
        while (i2 < members.size()) {
            RelationMember rm2 = (RelationMember)members.get(i2);
            if (PTStop.isPTPlatform(rm2) || PTStop.isPTStopPosition(rm2)) {
                stops.add(rm2);
            } else {
                wayMembers.add(rm2);
                if (rm2.getType() == OsmPrimitiveType.WAY) {
                    ways.add(rm2.getWay());
                }
            }
            ++i2;
        }
        HashMap stopsByName = new HashMap();
        ArrayList unnamed = new ArrayList();
        stops.forEach(rm -> {
            String name = SortPTStopsAction.getStopName(rm.getMember());
            if (name != null) {
                if (!stopsByName.containsKey(name)) {
                    stopsByName.put(name, new PTStop((RelationMember)rm));
                } else {
                    ((PTStop)((Object)((Object)stopsByName.get(name)))).addStopElement((RelationMember)rm);
                }
            } else {
                unnamed.add(new PTStop((RelationMember)rm));
            }
        });
        StopToWayAssigner assigner = new StopToWayAssigner((Collection<Way>)ways);
        ArrayList ptstops = new ArrayList(stopsByName.values());
        HashMap wayStop = new HashMap();
        ptstops.forEach(stop -> {
            Way way = assigner.get((PTStop)((Object)stop));
            if (!wayStop.containsKey(way)) {
                wayStop.put(way, new ArrayList());
            }
            ((List)wayStop.get(way)).add(stop);
        });
        unnamed.forEach(stop -> {
            Way way = assigner.get((PTStop)((Object)stop));
            if (!wayStop.containsKey(way)) {
                wayStop.put(way, new ArrayList());
            }
            ((List)wayStop.get(way)).add(stop);
        });
        Way prev = null;
        for (RelationMember wm : wayMembers) {
            if (wm.getType() != OsmPrimitiveType.WAY) continue;
            Way curr = wm.getWay();
            List<PTStop> stps = (List<PTStop>)wayStop.get(curr);
            if (stps != null) {
                if (stps.size() > 1) {
                    stps = this.sortSameWayStops(stps, curr, prev);
                }
                stps.forEach(stop -> {
                    if (stop != null) {
                        if (stop.getStopPositionRM() != null) {
                            rel.addMember(stop.getStopPositionRM());
                        }
                        if (stop.getPlatformRM() != null) {
                            rel.addMember(stop.getPlatformRM());
                        }
                    }
                });
            }
            prev = curr;
        }
        wayMembers.forEach(arg_0 -> ((Relation)rel).addMember(arg_0));
    }

    private List<PTStop> sortSameWayStops(List<PTStop> stps, Way way, Way prev) {
        boolean reverse;
        HashMap<Node, List<PTStop>> closeNodes = new HashMap<Node, List<PTStop>>();
        ArrayList<PTStop> noLocationStops = new ArrayList<PTStop>();
        List nodes = way.getNodes();
        for (PTStop stop : stps) {
            Node closest = this.findClosestNode(stop, nodes);
            if (closest == null) {
                noLocationStops.add(stop);
                continue;
            }
            if (!closeNodes.containsKey(closest)) {
                closeNodes.put(closest, new ArrayList());
            }
            ((List)closeNodes.get(closest)).add(stop);
        }
        boolean bl = reverse = prev != null && (prev.firstNode().equals((Object)way.lastNode()) || prev.lastNode().equals((Object)way.lastNode()));
        if (reverse) {
            Collections.reverse(nodes);
        }
        List<PTStop> ret = this.getSortedStops(nodes, closeNodes);
        ret.addAll(noLocationStops);
        return ret;
    }

    private List<PTStop> getSortedStops(List<Node> nodes, Map<Node, List<PTStop>> closeNodes) {
        ArrayList<PTStop> ret = new ArrayList<PTStop>();
        int i = 0;
        while (i < nodes.size()) {
            Node n = nodes.get(i);
            Node prevNode = i > 0 ? nodes.get(i - 1) : n;
            List<PTStop> stops = closeNodes.get(n);
            if (stops != null) {
                if (stops.size() > 1) {
                    stops.sort((s1, s2) -> {
                        Double d1 = this.stopEastNorth((PTStop)((Object)s1)).distance(prevNode.getEastNorth());
                        Double d2 = this.stopEastNorth((PTStop)((Object)s2)).distance(prevNode.getEastNorth());
                        return d1.compareTo(d2);
                    });
                }
                stops.forEach(ret::add);
            }
            ++i;
        }
        return ret;
    }

    private Node findClosestNode(PTStop stop, List<Node> nodes) {
        EastNorth stopEN = this.stopEastNorth(stop);
        if (stopEN == null) {
            return null;
        }
        double minDist = Double.MAX_VALUE;
        Node closest = null;
        for (Node node : nodes) {
            double dist = node.getEastNorth().distance(stopEN);
            if (!(dist < minDist)) continue;
            minDist = dist;
            closest = node;
        }
        return closest;
    }

    private EastNorth stopEastNorth(PTStop stop) {
        if (stop.getStopPosition() != null) {
            return stop.getStopPosition().getEastNorth();
        }
        OsmPrimitive prim = stop.getPlatform();
        if (prim.getType() == OsmPrimitiveType.WAY) {
            return ((Way)prim).firstNode().getEastNorth();
        }
        if (prim.getType() == OsmPrimitiveType.NODE) {
            return ((Node)prim).getEastNorth();
        }
        return null;
    }

    private static String getStopName(OsmPrimitive p) {
        for (Relation ref : Utils.filteredCollection((Collection)p.getReferrers(), Relation.class)) {
            if (!ref.hasTag("type", "public_transport") || !ref.hasTag("public_transport", "stop_area") || ref.getName() == null) continue;
            return ref.getName();
        }
        return p.getName();
    }

    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(false);
        if (selection == null || selection.size() != 1) {
            return;
        }
        OsmPrimitive selected = selection.iterator().next();
        if (selected.getType() == OsmPrimitiveType.RELATION && RouteUtils.isPTRoute((Relation)selected)) {
            this.setEnabled(true);
        }
    }
}

