/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.TagCollection;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.conflict.tags.CombinePrimitiveResolverDialog;
import org.openstreetmap.josm.tools.UserCancelException;

public class CreatePlatformNodeAction
extends JosmAction {
    private static final String ACTION_NAME = "Transfer details of stop to platform node";
    private Node dummy1;
    private Node dummy2;
    private Node dummy3;

    public CreatePlatformNodeAction() {
        super(ACTION_NAME, "icons/sortptstops", ACTION_NAME, null, true);
    }

    public void actionPerformed(ActionEvent e) {
        Collection selection = this.getLayerManager().getEditDataSet().getSelected();
        Node platformNode = null;
        Node stopPositionNode = null;
        Way platformWay = null;
        for (OsmPrimitive item : selection) {
            if (item.getType() == OsmPrimitiveType.NODE) {
                if (item.hasTag("public_transport", "stop_position")) {
                    stopPositionNode = (Node)item;
                    continue;
                }
                platformNode = (Node)item;
                continue;
            }
            if (item.getType() != OsmPrimitiveType.WAY || !item.hasTag("public_transport", "platform")) continue;
            platformWay = (Way)item;
        }
        if (platformNode == null || stopPositionNode == null) {
            return;
        }
        this.dummy1 = new Node(platformNode.getEastNorth());
        this.dummy2 = new Node(platformNode.getEastNorth());
        this.dummy3 = new Node(platformNode.getEastNorth());
        Main.main.undoRedo.add((Command)new AddCommand((OsmPrimitive)this.dummy1));
        Main.main.undoRedo.add((Command)new AddCommand((OsmPrimitive)this.dummy2));
        Main.main.undoRedo.add((Command)new AddCommand((OsmPrimitive)this.dummy3));
        this.populateMap((OsmPrimitive)stopPositionNode);
        this.populateMap((OsmPrimitive)platformNode);
        if (platformWay != null) {
            this.populateMap((OsmPrimitive)platformWay);
            platformWay.removeAll();
            platformWay.put("public_transport", "platform");
            platformWay.put(" highway", "platform");
        }
        stopPositionNode.removeAll();
        stopPositionNode.put("bus", "yes");
        stopPositionNode.put("public_transport", "stop_position");
        platformNode.removeAll();
        platformNode.put("public_transport", "platform");
        platformNode.put("highway", "bus_stop");
        ArrayList<Node> prims = new ArrayList<Node>();
        prims.add(platformNode);
        prims.add(this.dummy1);
        prims.add(this.dummy2);
        prims.add(this.dummy3);
        try {
            try {
                TagCollection tagColl = TagCollection.unionOfAllPrimitives(prims);
                List cmds = CombinePrimitiveResolverDialog.launchIfNecessary((TagCollection)tagColl, prims, Collections.singleton(platformNode));
                Main.main.undoRedo.add((Command)new SequenceCommand("merging", (Collection)cmds));
            }
            catch (UserCancelException ex) {
                Main.trace((Throwable)ex);
                Main.main.undoRedo.add((Command)new DeleteCommand((OsmPrimitive)this.dummy1));
                Main.main.undoRedo.add((Command)new DeleteCommand((OsmPrimitive)this.dummy2));
                Main.main.undoRedo.add((Command)new DeleteCommand((OsmPrimitive)this.dummy3));
            }
        }
        finally {
            Main.main.undoRedo.add((Command)new DeleteCommand((OsmPrimitive)this.dummy1));
            Main.main.undoRedo.add((Command)new DeleteCommand((OsmPrimitive)this.dummy2));
            Main.main.undoRedo.add((Command)new DeleteCommand((OsmPrimitive)this.dummy3));
        }
    }

    public void populateMap(OsmPrimitive prim) {
        ArrayList<String> unInterestingTags = new ArrayList<String>();
        unInterestingTags.add("public_transport");
        unInterestingTags.add("highway");
        unInterestingTags.add("source");
        for (Map.Entry tag : prim.getKeys().entrySet()) {
            if (unInterestingTags.contains(tag.getKey())) continue;
            if (this.dummy1.get((String)tag.getKey()) == null) {
                this.dummy1.put((String)tag.getKey(), (String)tag.getValue());
                continue;
            }
            if (this.dummy2.get((String)tag.getKey()) == null) {
                this.dummy2.put((String)tag.getKey(), (String)tag.getValue());
                continue;
            }
            if (this.dummy3.get((String)tag.getKey()) != null) continue;
            this.dummy3.put((String)tag.getKey(), (String)tag.getValue());
        }
    }

    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(false);
        if (selection.size() > 1) {
            this.setEnabled(true);
        }
    }
}

