/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.actions;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JoinNodeWayAction;
import org.openstreetmap.josm.actions.SplitWayAction;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.plugins.pt_assistant.data.PTStop;
import org.openstreetmap.josm.plugins.pt_assistant.utils.RouteUtils;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class AddStopPositionAction
extends MapMode {
    private static final String MAP_MODE_NAME = "Add stop position";
    private transient Set<OsmPrimitive> newHighlights = new HashSet<OsmPrimitive>();
    private transient Set<OsmPrimitive> oldHighlights = new HashSet<OsmPrimitive>();
    private final Cursor cursorJoinNode = ImageProvider.getCursor((String)"crosshair", (String)"joinnode");
    private final Cursor cursorJoinWay = ImageProvider.getCursor((String)"crosshair", (String)"joinway");

    public AddStopPositionAction() {
        super(I18n.tr((String)MAP_MODE_NAME, (Object[])new Object[0]), "bus", I18n.tr((String)MAP_MODE_NAME, (Object[])new Object[0]), Shortcut.registerShortcut((String)"mapmode:stop_position", (String)I18n.tr((String)"Mode: {0}", (Object[])new Object[]{I18n.tr((String)MAP_MODE_NAME, (Object[])new Object[0])}), (int)75, (int)5009), AddStopPositionAction.getCursor());
    }

    private static Cursor getCursor() {
        Cursor cursor = ImageProvider.getCursor((String)"crosshair", (String)"bus");
        if (cursor == null) {
            cursor = Cursor.getPredefinedCursor(1);
        }
        return cursor;
    }

    public void enterMode() {
        super.enterMode();
        Main.map.mapView.addMouseListener((MouseListener)((Object)this));
        Main.map.mapView.addMouseMotionListener((MouseMotionListener)((Object)this));
    }

    public void exitMode() {
        super.exitMode();
        Main.map.mapView.removeMouseListener((MouseListener)((Object)this));
        Main.map.mapView.removeMouseMotionListener((MouseMotionListener)((Object)this));
    }

    public void mouseMoved(MouseEvent e) {
        Cursor newCurs = AddStopPositionAction.getCursor();
        Node n = Main.map.mapView.getNearestNode(e.getPoint(), AbstractPrimitive::isUsable);
        if (n != null) {
            this.newHighlights.add((OsmPrimitive)n);
            newCurs = this.cursorJoinNode;
        } else {
            List wss = Main.map.mapView.getNearestWaySegments(e.getPoint(), OsmPrimitive::isSelectable);
            if (!wss.isEmpty()) {
                for (WaySegment ws : wss) {
                    this.newHighlights.add((OsmPrimitive)ws.way);
                }
                newCurs = this.cursorJoinWay;
            }
        }
        Main.map.mapView.setCursor(newCurs);
        this.updateHighlights();
    }

    public void mouseClicked(MouseEvent e) {
        Node newStopPos;
        Boolean newNode = false;
        Node n = Main.map.mapView.getNearestNode(e.getPoint(), AbstractPrimitive::isUsable);
        if (n == null) {
            newNode = true;
            newStopPos = new Node(Main.map.mapView.getLatLon(e.getX(), e.getY()));
        } else {
            newStopPos = new Node(n);
        }
        newStopPos.put("bus", "yes");
        newStopPos.put("public_transport", "stop_position");
        if (newNode.booleanValue()) {
            Main.main.undoRedo.add((Command)new AddCommand((OsmPrimitive)newStopPos));
        } else {
            Main.main.undoRedo.add((Command)new ChangeCommand((OsmPrimitive)n, (OsmPrimitive)newStopPos));
            newStopPos = n;
        }
        Main.getLayerManager().getEditLayer().data.setSelected(new PrimitiveId[]{newStopPos});
        if (newNode.booleanValue()) {
            JoinNodeWayAction joinNodeWayAction = JoinNodeWayAction.createMoveNodeOntoWayAction();
            joinNodeWayAction.actionPerformed(null);
        }
        if (newStopPos.getParentWays().isEmpty()) {
            return;
        }
        Way affected = (Way)newStopPos.getParentWays().get(0);
        Map<Relation, Boolean> needPostProcess = this.getAffectedRelation(affected);
        if (needPostProcess.isEmpty()) {
            return;
        }
        SplitWayAction.SplitWayResult result = SplitWayAction.split((OsmDataLayer)this.getLayerManager().getEditLayer(), (Way)affected, Collections.singletonList(newStopPos), Collections.emptyList());
        if (result == null) {
            return;
        }
        Main.main.undoRedo.add(result.getCommand());
        ArrayList<ChangeCommand> cmds = new ArrayList<ChangeCommand>();
        for (Map.Entry<Relation, Boolean> route : needPostProcess.entrySet()) {
            Relation r = new Relation(route.getKey());
            if (route.getValue().booleanValue()) {
                this.deleteFirstWay(r);
            } else {
                this.deleteLastWay(r);
            }
            cmds.add(new ChangeCommand((OsmPrimitive)route.getKey(), (OsmPrimitive)r));
        }
        Main.main.undoRedo.add((Command)new SequenceCommand("Update PT Relations", cmds));
    }

    private void deleteLastWay(Relation r) {
        int delete = 0;
        int i = r.getMembersCount() - 1;
        while (i >= 0) {
            RelationMember rm = r.getMember(i);
            if (rm.getType() == OsmPrimitiveType.WAY && !PTStop.isPTPlatform(rm)) {
                delete = i;
                break;
            }
            --i;
        }
        r.removeMember(delete);
    }

    private void deleteFirstWay(Relation r) {
        int delete = 0;
        int i = 0;
        while (i < r.getMembersCount()) {
            RelationMember rm = r.getMember(i);
            if (rm.getType() == OsmPrimitiveType.WAY && !PTStop.isPTPlatform(rm)) {
                delete = i;
                break;
            }
            ++i;
        }
        r.removeMember(delete);
    }

    private Map<Relation, Boolean> getAffectedRelation(Way affected) {
        HashMap<Relation, Boolean> ret = new HashMap<Relation, Boolean>();
        for (Relation route : this.getPTRouteParents(affected)) {
            if (this.isFirstMember(affected, route)) {
                ret.put(route, true);
                continue;
            }
            if (!this.isLastMember(affected, route)) continue;
            ret.put(route, false);
        }
        return ret;
    }

    private boolean isFirstMember(Way affected, Relation route) {
        int i = 0;
        while (i < route.getMembersCount()) {
            RelationMember rm = route.getMember(i);
            if (rm.getMember().equals((Object)affected)) {
                return true;
            }
            if (rm.getType() == OsmPrimitiveType.WAY && !PTStop.isPTPlatform(rm)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isLastMember(Way affected, Relation route) {
        int i = route.getMembersCount() - 1;
        while (i >= 0) {
            RelationMember rm = route.getMember(i);
            if (rm.getMember().equals((Object)affected)) {
                return true;
            }
            if (rm.getType() == OsmPrimitiveType.WAY && !PTStop.isPTPlatform(rm)) {
                return false;
            }
            --i;
        }
        return true;
    }

    private List<Relation> getPTRouteParents(Way way) {
        List referrers = OsmPrimitive.getFilteredList((Collection)way.getReferrers(), Relation.class);
        referrers.removeIf(r -> !RouteUtils.isPTRoute(r));
        return referrers;
    }

    private void updateHighlights() {
        if (this.oldHighlights.isEmpty() && this.newHighlights.isEmpty()) {
            return;
        }
        for (OsmPrimitive osm : this.oldHighlights) {
            osm.setHighlighted(false);
        }
        for (OsmPrimitive osm : this.newHighlights) {
            osm.setHighlighted(true);
        }
        Main.getLayerManager().getEditLayer().invalidate();
        this.oldHighlights.clear();
        this.oldHighlights.addAll(this.newHighlights);
        this.newHighlights.clear();
    }
}

