/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SelectCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.dialogs.relation.RelationEditor;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.plugins.pt_assistant.data.PTStop;
import org.openstreetmap.josm.plugins.pt_assistant.gui.PTAssistantLayerManager;

public abstract class Checker {
    protected final Test test;
    protected Node node;
    protected Relation relation;
    protected ArrayList<TestError> errors = new ArrayList();

    protected Checker(Node node, Test test) {
        this.node = node;
        this.test = test;
    }

    protected Checker(Relation relation, Test test) {
        this.relation = relation;
        this.test = test;
    }

    public List<TestError> getErrors() {
        return this.errors;
    }

    protected static List<RelationMember> listStopMembers(Relation r) {
        ArrayList<RelationMember> resultList = new ArrayList<RelationMember>();
        for (RelationMember rm : r.getMembers()) {
            RelationMember newMember;
            if (!PTStop.isPTStop(rm)) continue;
            if (rm.getMember().hasTag("public_transport", "stop_position")) {
                if (!(rm.hasRole(new String[]{"stop"}) || rm.hasRole(new String[]{"stop_entry_only"}) || rm.hasRole(new String[]{"stop_exit_only"}))) {
                    newMember = new RelationMember("stop", rm.getMember());
                    resultList.add(newMember);
                    continue;
                }
                resultList.add(rm);
                continue;
            }
            if (!(rm.hasRole(new String[]{"platform"}) || rm.hasRole(new String[]{"platform_entry_only"}) || rm.hasRole(new String[]{"platform_exit_only"}))) {
                newMember = new RelationMember("platform", rm.getMember());
                resultList.add(newMember);
                continue;
            }
            resultList.add(rm);
        }
        return resultList;
    }

    protected static List<RelationMember> listNotStopMembers(Relation r) {
        ArrayList<RelationMember> resultList = new ArrayList<RelationMember>();
        for (RelationMember rm : r.getMembers()) {
            if (PTStop.isPTStop(rm)) continue;
            if (rm.hasRole(new String[]{"forward"}) || rm.hasRole(new String[]{"backward"})) {
                RelationMember newMember = new RelationMember("", rm.getMember());
                resultList.add(newMember);
                continue;
            }
            resultList.add(rm);
        }
        return resultList;
    }

    protected static Command fixErrorByZooming(TestError testError) {
        if (testError.getCode() != 3754 && testError.getCode() != 3731 && testError.getCode() != 3722 && testError.getCode() != 3721 && testError.getCode() != 3741) {
            return null;
        }
        Collection primitives = testError.getPrimitives();
        Relation originalRelation = (Relation)primitives.iterator().next();
        ArrayList<OsmPrimitive> primitivesToZoom = new ArrayList<OsmPrimitive>();
        for (Object primitiveToZoom : testError.getHighlighted()) {
            primitivesToZoom.add((OsmPrimitive)primitiveToZoom);
        }
        SelectCommand command = new SelectCommand(primitivesToZoom);
        List listOfLayers = Main.getLayerManager().getLayersOfType(OsmDataLayer.class);
        for (OsmDataLayer osmDataLayer : listOfLayers) {
            if (osmDataLayer.data != originalRelation.getDataSet()) continue;
            final OsmDataLayer layerParameter = osmDataLayer;
            final Relation relationParameter = originalRelation;
            final ArrayList<OsmPrimitive> zoomParameter = primitivesToZoom;
            if (SwingUtilities.isEventDispatchThread()) {
                Checker.showRelationEditorAndZoom(layerParameter, relationParameter, zoomParameter);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Checker.showRelationEditorAndZoom(layerParameter, relationParameter, zoomParameter);
                    }
                });
            }
            return command;
        }
        return null;
    }

    private static void showRelationEditorAndZoom(OsmDataLayer layer, Relation r, Collection<OsmPrimitive> primitives) {
        AutoScaleAction.zoomTo(primitives);
        List<RelationMember> sortedRelationMembers = Checker.listStopMembers(r);
        sortedRelationMembers.addAll(Checker.listNotStopMembers(r));
        r.setMembers(sortedRelationMembers);
        RelationEditor editor = RelationEditor.getEditor((OsmDataLayer)layer, (Relation)r, (Collection)r.getMembersFor(primitives));
        editor.setVisible(true);
        PTAssistantLayerManager.PTLM.getLayer().repaint(r);
    }
}

