/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.plugins.pt_assistant.data.PTStop;
import org.openstreetmap.josm.plugins.pt_assistant.data.PTWay;
import org.openstreetmap.josm.tools.Pair;

public class StopToWayAssigner {
    public static Map<PTStop, List<Way>> stopToWay = new HashMap<PTStop, List<Way>>();
    private HashSet<Way> ways = new HashSet();

    public StopToWayAssigner(List<PTWay> ptways) {
        for (PTWay ptway : ptways) {
            this.ways.addAll(ptway.getWays());
        }
    }

    public StopToWayAssigner(Collection<Way> ways) {
        this.ways.addAll(ways);
    }

    public Way get(PTStop stop) {
        Way wayOfStopPosition;
        if (stopToWay.containsKey((Object)stop)) {
            List<Way> assignedWays = stopToWay.get((Object)stop);
            for (Way assignedWay : assignedWays) {
                if (!this.ways.contains(assignedWay)) continue;
                return assignedWay;
            }
        }
        if ((wayOfStopPosition = this.findWayForNode(stop.getStopPosition())) != null) {
            this.addAssignedWayToMap(stop, wayOfStopPosition);
            return wayOfStopPosition;
        }
        ArrayList<Object> stopElements = new ArrayList<Object>(2);
        if (stop.getStopPosition() != null) {
            stopElements.add(stop.getStopPosition());
        }
        if (stop.getPlatform() != null) {
            stopElements.add(stop.getPlatform());
        }
        Set parents = Node.getParentRelations(stopElements);
        for (Relation parentRelation : parents) {
            if (!parentRelation.hasTag("public_transport", "stop_area")) continue;
            for (RelationMember rm : parentRelation.getMembers()) {
                Way rmWay;
                if (!rm.getMember().hasTag("public_transport", "stop_position") || (rmWay = this.findWayForNode(rm.getNode())) == null) continue;
                this.addAssignedWayToMap(stop, rmWay);
                return rmWay;
            }
        }
        if (stop.getPlatform() != null) {
            List<Node> potentialStopPositionList = stop.findPotentialStopPositions();
            Node closestStopPosition = null;
            double minDistanceSq = Double.MAX_VALUE;
            for (Node potentialStopPosition : potentialStopPositionList) {
                double distanceSq = potentialStopPosition.getCoor().distanceSq(stop.getPlatform().getBBox().getCenter());
                if (!(distanceSq < minDistanceSq)) continue;
                closestStopPosition = potentialStopPosition;
                minDistanceSq = distanceSq;
            }
            if (closestStopPosition != null) {
                Way closestWay = null;
                double minDistanceSqToWay = Double.MAX_VALUE;
                for (Way way : this.ways) {
                    double distanceSq;
                    if (!way.containsNode(closestStopPosition) || !((distanceSq = this.calculateMinDistanceToSegment(new Node(stop.getPlatform().getBBox().getCenter()), way)) < minDistanceSqToWay)) continue;
                    closestWay = way;
                    minDistanceSqToWay = distanceSq;
                }
                if (closestWay != null) {
                    this.addAssignedWayToMap(stop, closestWay);
                    return closestWay;
                }
            }
        }
        double searchRadius = 0.001;
        while (searchRadius < 0.005) {
            Way foundWay = this.findNearestWayInRadius(stop.getPlatform(), searchRadius);
            if (foundWay != null) {
                this.addAssignedWayToMap(stop, foundWay);
                return foundWay;
            }
            foundWay = this.findNearestWayInRadius((OsmPrimitive)stop.getStopPosition(), searchRadius);
            if (foundWay != null) {
                this.addAssignedWayToMap(stop, foundWay);
                return foundWay;
            }
            searchRadius += 0.001;
        }
        return null;
    }

    private Way findWayForNode(Node stopPosition) {
        if (stopPosition == null) {
            return null;
        }
        List referrers = stopPosition.getReferrers();
        for (OsmPrimitive referredPrimitive : referrers) {
            Way referredWay;
            if (!referredPrimitive.getType().equals((Object)OsmPrimitiveType.WAY) || !this.ways.contains(referredWay = (Way)referredPrimitive)) continue;
            return referredWay;
        }
        return null;
    }

    private Way findNearestWayInRadius(OsmPrimitive platform, double searchRadius) {
        if (platform == null) {
            return null;
        }
        LatLon platformCenter = platform.getBBox().getCenter();
        Double ax = platformCenter.getX() - searchRadius;
        Double bx = platformCenter.getX() + searchRadius;
        Double ay = platformCenter.getY() - searchRadius;
        Double by = platformCenter.getY() + searchRadius;
        BBox platformBBox = new BBox(ax.doubleValue(), ay.doubleValue(), bx.doubleValue(), by.doubleValue());
        HashSet<Way> potentialWays = new HashSet<Way>();
        Collection allNodes = platform.getDataSet().getNodes();
        for (Node currentNode : allNodes) {
            if (!platformBBox.bounds(currentNode.getBBox())) continue;
            List referrers = currentNode.getReferrers();
            for (OsmPrimitive referrer : referrers) {
                Way referrerWay;
                if (!referrer.getType().equals((Object)OsmPrimitiveType.WAY) || !this.ways.contains(referrerWay = (Way)referrer)) continue;
                potentialWays.add(referrerWay);
            }
        }
        Node platformNode = null;
        platformNode = platform.getType().equals((Object)OsmPrimitiveType.NODE) ? (Node)platform : new Node(platform.getBBox().getCenter());
        Way nearestWay = null;
        Double minDistance = Double.MAX_VALUE;
        for (Way potentialWay : potentialWays) {
            double distance = this.calculateMinDistanceToSegment(platformNode, potentialWay);
            if (!(distance < minDistance)) continue;
            minDistance = distance;
            nearestWay = potentialWay;
        }
        return nearestWay;
    }

    private double calculateMinDistanceToSegment(Node node, Way way) {
        double minDistance = Double.MAX_VALUE;
        List waySegments = way.getNodePairs(false);
        for (Pair waySegment : waySegments) {
            double distanceToLine;
            if (waySegment.a == node || waySegment.b == node || !((distanceToLine = this.calculateDistanceToSegment(node, (Pair<Node, Node>)waySegment)) < minDistance)) continue;
            minDistance = distanceToLine;
        }
        return minDistance;
    }

    private double calculateDistanceToSegment(Node node, Pair<Node, Node> segment) {
        if (node == segment.a || node == segment.b) {
            return 0.0;
        }
        double lengthA = node.getCoor().distance(((Node)segment.a).getCoor());
        double lengthB = node.getCoor().distance(((Node)segment.b).getCoor());
        double lengthC = ((Node)segment.a).getCoor().distance(((Node)segment.b).getCoor());
        if (this.isObtuse(lengthC, lengthB, lengthA)) {
            return lengthB;
        }
        if (this.isObtuse(lengthA, lengthC, lengthB)) {
            return lengthA;
        }
        return this.calculateDistanceToLine(node, segment);
    }

    private double calculateDistanceToLine(Node node, Pair<Node, Node> segment) {
        double lengthA = node.getCoor().distance(((Node)segment.a).getCoor());
        double lengthB = node.getCoor().distance(((Node)segment.b).getCoor());
        double lengthC = ((Node)segment.a).getCoor().distance(((Node)segment.b).getCoor());
        double p = (lengthA + lengthB + lengthC) / 2.0;
        double triangleArea = Math.sqrt(p * (p - lengthA) * (p - lengthB) * (p - lengthC));
        return triangleArea * 2.0 / lengthC;
    }

    private boolean isObtuse(double lengthA, double lengthB, double lengthC) {
        return lengthC * lengthC > lengthA * lengthA + lengthB * lengthB;
    }

    private void addAssignedWayToMap(PTStop stop, Way way) {
        if (stopToWay.containsKey((Object)stop)) {
            List<Way> assignedWays = stopToWay.get((Object)stop);
            assignedWays.add(way);
        } else {
            ArrayList<Way> assignedWays = new ArrayList<Way>();
            assignedWays.add(way);
            stopToWay.put(stop, assignedWays);
        }
    }

    public static void reinitiate() {
        stopToWay = new HashMap<PTStop, List<Way>>();
    }
}

