/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.validation;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.junit.Assert;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.plugins.pt_assistant.AbstractTest;
import org.openstreetmap.josm.plugins.pt_assistant.ImportUtils;
import org.openstreetmap.josm.plugins.pt_assistant.utils.RouteUtils;
import org.openstreetmap.josm.plugins.pt_assistant.validation.PTAssistantValidatorTest;
import org.openstreetmap.josm.plugins.pt_assistant.validation.WayChecker;

public class AdjacentWaysTest
extends AbstractTest {
    @org.junit.Test
    public void test1() {
        File file = new File("test/data/oneway-wrong-direction.osm");
        DataSet ds = ImportUtils.importOsmFile(file, "testLayer");
        PTAssistantValidatorTest test = new PTAssistantValidatorTest();
        long id = 24215210L;
        Way way = (Way)ds.getPrimitiveById(id, OsmPrimitiveType.WAY);
        Assert.assertEquals((long)RouteUtils.isOnewayForPublicTransport(way), (long)-1L);
        Relation route = null;
        for (Relation r : ds.getRelations()) {
            if (!r.hasKey("route")) continue;
            route = r;
        }
        WayChecker wayChecker = new WayChecker(route, (Test)test);
        Set<Way> set = wayChecker.checkAdjacentWays(way, new HashSet<Way>());
        Assert.assertEquals((long)set.size(), (long)1L);
    }

    @org.junit.Test
    public void test2() {
        File file = new File("test/data/oneway-wrong-direction2.osm");
        DataSet ds = ImportUtils.importOsmFile(file, "testLayer");
        PTAssistantValidatorTest test = new PTAssistantValidatorTest();
        long id = 24215210L;
        Way way = (Way)ds.getPrimitiveById(id, OsmPrimitiveType.WAY);
        Assert.assertEquals((long)RouteUtils.isOnewayForPublicTransport(way), (long)-1L);
        Relation route = null;
        for (Relation r : ds.getRelations()) {
            if (!r.hasKey("route")) continue;
            route = r;
        }
        WayChecker wayChecker = new WayChecker(route, (Test)test);
        Set<Way> set = wayChecker.checkAdjacentWays(way, new HashSet<Way>());
        Assert.assertEquals((long)set.size(), (long)2L);
    }
}

