/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.validation;

import java.io.File;
import java.util.ArrayList;
import org.junit.Assert;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.plugins.pt_assistant.AbstractTest;
import org.openstreetmap.josm.plugins.pt_assistant.ImportUtils;
import org.openstreetmap.josm.plugins.pt_assistant.validation.PTAssistantValidatorTest;
import org.openstreetmap.josm.plugins.pt_assistant.validation.WayChecker;

public class RoadTypeTestTest
extends AbstractTest {
    @org.junit.Test
    public void test() {
        File file = new File("test/data/road-type.osm");
        DataSet ds = ImportUtils.importOsmFile(file, "testLayer");
        PTAssistantValidatorTest test = new PTAssistantValidatorTest();
        ArrayList<TestError> errors = new ArrayList<TestError>();
        for (Relation r : ds.getRelations()) {
            WayChecker wayChecker = new WayChecker(r, (Test)test);
            wayChecker.performRoadTypeTest();
            errors.addAll(wayChecker.getErrors());
        }
        Assert.assertEquals((long)errors.size(), (long)2L);
        for (TestError e : errors) {
            Assert.assertEquals((long)e.getCode(), (long)3721L);
            Way way = (Way)e.getHighlighted().iterator().next();
            Assert.assertTrue((way.getId() == 8169083L || way.getId() == 8034569L ? 1 : 0) != 0);
        }
    }
}

