/*
 * Decompiled with CFR 0.152.
 */
package ptl;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.SystemOfMeasurement;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.dialogs.relation.sort.WayConnectionType;
import org.openstreetmap.josm.gui.dialogs.relation.sort.WayConnectionTypeCalculator;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.JosmTextArea;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class DistanceBetweenStops
extends JosmAction {
    public DistanceBetweenStops() {
        super(I18n.tr((String)"Distance between stops", (Object[])new Object[0]), null, null, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String calculateDistanceBetweenStops(Relation route) {
        CheckParameterUtil.ensureThat((boolean)DistanceBetweenStops.isRouteSupported(route), (String)"A valid public_transport:version=2 route is required");
        ArrayList<Node> stopNodes = new ArrayList<Node>();
        ArrayList<RelationMember> routeSegments = new ArrayList<RelationMember>();
        ArrayList routeNodes = new ArrayList();
        for (RelationMember member : route.getMembers()) {
            if (member.hasRole(new String[]{"stop", "stop_exit_only", "stop_entry_only"}) && OsmPrimitiveType.NODE.equals((Object)member.getType())) {
                stopNodes.add(member.getNode());
                continue;
            }
            if (!member.hasRole(new String[]{""}) || !OsmPrimitiveType.WAY.equals((Object)member.getType())) continue;
            routeSegments.add(member);
        }
        WayConnectionTypeCalculator connectionTypeCalculator = new WayConnectionTypeCalculator();
        List links = connectionTypeCalculator.updateLinks(routeSegments);
        block8: for (int i = 0; i < links.size(); ++i) {
            WayConnectionType link = (WayConnectionType)links.get(i);
            List nodes = ((RelationMember)routeSegments.get(i)).getWay().getNodes();
            switch (link.direction) {
                case BACKWARD: {
                    Collections.reverse(nodes);
                }
                case FORWARD: {
                    routeNodes.addAll(link.linkPrev ? nodes.subList(1, nodes.size()) : nodes);
                    continue block8;
                }
            }
        }
        StringBuilder sb = new StringBuilder();
        Node lastN = null;
        List remainingRouteNodes = routeNodes;
        double totalLength = 0.0;
        int lengthN = 0;
        boolean onlyLowerUnit = Main.pref.getBoolean("system_of_measurement.use_only_lower_unit", false);
        Main.pref.put("system_of_measurement.use_only_lower_unit", true);
        try {
            for (Node n : stopNodes) {
                double length;
                if (lastN != null) {
                    if (remainingRouteNodes.indexOf(lastN) > 0) {
                        remainingRouteNodes = remainingRouteNodes.subList(remainingRouteNodes.indexOf(lastN), remainingRouteNodes.size());
                    }
                    if (remainingRouteNodes.indexOf(n) > 0) {
                        List<Node> segmentBetweenStops = remainingRouteNodes.subList(0, remainingRouteNodes.indexOf(n) + 1);
                        length = DistanceBetweenStops.getLength(segmentBetweenStops);
                        totalLength += length;
                        ++lengthN;
                    } else {
                        length = Double.NaN;
                    }
                } else {
                    length = 0.0;
                }
                sb.append(SystemOfMeasurement.getSystemOfMeasurement().getDistText(length, (NumberFormat)new DecimalFormat("0"), -1.0));
                sb.append("\t");
                sb.append(n.getDisplayName((NameFormatter)DefaultNameFormatter.getInstance()));
                sb.append("\n");
                lastN = n;
            }
            sb.insert(0, "\n");
            sb.insert(0, route.getDisplayName((NameFormatter)DefaultNameFormatter.getInstance()));
            sb.insert(0, "\t");
            sb.insert(0, SystemOfMeasurement.getSystemOfMeasurement().getDistText(totalLength / (double)lengthN, (NumberFormat)new DecimalFormat("0"), -1.0));
        }
        finally {
            Main.pref.put("system_of_measurement.use_only_lower_unit", onlyLowerUnit);
        }
        return sb.toString();
    }

    private static boolean isRouteSupported(Relation route) {
        return !route.hasIncompleteMembers() && route.hasTag("type", "route") && route.hasKey("route") && route.hasTag("public_transport:version", "2");
    }

    private static double getLength(Iterable<Node> nodes) {
        double length = 0.0;
        Node lastN = null;
        for (Node n : nodes) {
            if (lastN != null) {
                LatLon lastNcoor = lastN.getCoor();
                LatLon coor = n.getCoor();
                if (lastNcoor != null && coor != null) {
                    length += coor.greatCircleDistance(lastNcoor);
                }
            }
            lastN = n;
        }
        return length;
    }

    public void actionPerformed(ActionEvent e) {
        if (this.getLayerManager().getEditDataSet() == null) {
            return;
        }
        final StringBuilder sb = new StringBuilder();
        for (Relation relation : this.getLayerManager().getEditDataSet().getSelectedRelations()) {
            if (!DistanceBetweenStops.isRouteSupported(relation)) {
                JOptionPane.showMessageDialog(Main.parent, "<html>" + I18n.tr((String)"A valid public_transport:version=2 route is required", (Object[])new Object[0]) + Utils.joinAsHtmlUnorderedList(Collections.singleton(relation.getDisplayName((NameFormatter)DefaultNameFormatter.getInstance()))), I18n.tr((String)"Invalid selection", (Object[])new Object[0]), 2);
                continue;
            }
            sb.append("\n");
            sb.append(DistanceBetweenStops.calculateDistanceBetweenStops(relation)).append("\n");
        }
        new ExtendedDialog(Main.parent, this.getValue("Name").toString(), new String[]{I18n.tr((String)"Close", (Object[])new Object[0])}){
            {
                super(x0, x1, x2);
                this.setButtonIcons(new String[]{"ok.png"});
                JosmTextArea jte = new JosmTextArea();
                jte.setFont(GuiHelper.getMonospacedFont((JComponent)jte));
                jte.setEditable(false);
                jte.append(sb.toString());
                jte.setSelectionStart(0);
                jte.setSelectionEnd(0);
                this.setContent((Component)jte);
            }
        }.showDialog();
    }
}

