/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.junit.Assert;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.Projections;
import org.openstreetmap.josm.gui.preferences.ToolbarPreferences;
import org.openstreetmap.josm.tools.I18n;

public final class TestUtil {
    private static boolean isInitialized;

    private TestUtil() {
    }

    public static synchronized void initPlugin() {
        if (!isInitialized) {
            System.setProperty("josm.home", "test/data/preferences");
            Main.pref.enableSaveOnPut(false);
            I18n.init();
            Main.determinePlatformHook();
            Main.platform.preStartupHook();
            Main.pref.init(false);
            I18n.set((String)Main.pref.get("language", "en"));
            Main.setProjection((Projection)Projections.getProjectionByCode((String)"EPSG:3857"));
            isInitialized = true;
            if (Main.toolbar == null) {
                Main.toolbar = new ToolbarPreferences();
            }
        }
    }

    public static void testUtilityClass(Class<?> c) {
        try {
            Assert.assertTrue((boolean)Modifier.isFinal(c.getModifiers()));
            Assert.assertEquals((long)1L, (long)c.getDeclaredConstructors().length);
            Constructor<?> constructor = c.getDeclaredConstructors()[0];
            Assert.assertTrue((!constructor.isAccessible() && Modifier.isPrivate(constructor.getModifiers()) ? 1 : 0) != 0);
            constructor.setAccessible(true);
            constructor.newInstance(new Object[0]);
            Method[] methodArray = c.getMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method m = methodArray[n2];
                Assert.assertTrue((m.getDeclaringClass() != c || Modifier.isStatic(m.getModifiers()) ? 1 : 0) != 0);
                ++n2;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            Assert.fail((String)e.getLocalizedMessage());
        }
    }
}

