/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.tofix.controller;

import java.io.Reader;
import java.io.StringReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonValue;
import org.openstreetmap.josm.plugins.tofix.bean.AccessToTask;
import org.openstreetmap.josm.plugins.tofix.bean.ResponseBean;
import org.openstreetmap.josm.plugins.tofix.bean.TaskCompleteBean;
import org.openstreetmap.josm.plugins.tofix.bean.items.AbstractItemOsmlint;
import org.openstreetmap.josm.plugins.tofix.bean.items.Item;
import org.openstreetmap.josm.plugins.tofix.bean.items.ItemOsmlintLinestring;
import org.openstreetmap.josm.plugins.tofix.bean.items.ItemOsmlintMultilinestring;
import org.openstreetmap.josm.plugins.tofix.bean.items.ItemOsmlintMultipoint;
import org.openstreetmap.josm.plugins.tofix.bean.items.ItemOsmlintMultipolygon;
import org.openstreetmap.josm.plugins.tofix.bean.items.ItemOsmlintPoint;
import org.openstreetmap.josm.plugins.tofix.bean.items.ItemOsmlintPolygon;
import org.openstreetmap.josm.plugins.tofix.util.Request;
import org.openstreetmap.josm.plugins.tofix.util.Util;

public class ItemController {
    Item item = new Item();
    ResponseBean responseBean = new ResponseBean();
    JsonArray relation;
    AccessToTask accessToTask;

    public AccessToTask getAccessToTask() {
        return this.accessToTask;
    }

    public void setAccessToTask(AccessToTask accessToTask) {
        this.accessToTask = accessToTask;
    }

    public JsonArray getRelation() {
        return this.relation;
    }

    public void setRelation(JsonArray relation) {
        this.relation = relation;
    }

    public Item getItem() {
        try {
            this.responseBean = Request.sendPOST(this.accessToTask.getTask_url());
            this.item.setStatus(this.responseBean.getStatus());
            Util.print(this.responseBean.getValue());
            JsonReader reader = Json.createReader((Reader)new StringReader(this.responseBean.getValue()));
            JsonObject object = reader.readObject();
            switch (this.responseBean.getStatus()) {
                case 200: {
                    AbstractItemOsmlint iop;
                    JsonObject geometry = (JsonObject)object.get((Object)"geometry");
                    JsonObject properties = (JsonObject)object.get((Object)"properties");
                    this.item.setType(geometry.getString("type"));
                    if (properties.containsKey((Object)"relations")) {
                        JsonArray relation2 = properties.getJsonArray("relations");
                        this.setRelation(relation2);
                    }
                    if (geometry.getString("type").equals("Point")) {
                        iop = new ItemOsmlintPoint();
                        iop.setKey(properties.getString("_key"));
                        if (properties.containsKey((Object)"_osmId") && geometry.containsKey((Object)"type")) {
                            iop.setWay(Long.parseLong(properties.getJsonNumber("_osmId").toString()));
                            iop.setGeometry(geometry.getJsonString("type").toString());
                            iop.setCoordinates(((JsonValue)geometry.get((Object)"coordinates")).toString());
                            this.item.setItemOsmlintPoint((ItemOsmlintPoint)iop);
                        } else {
                            this.item.setStatus(520);
                        }
                    }
                    if (geometry.getString("type").equals("MultiPoint")) {
                        ItemOsmlintMultipoint iom = new ItemOsmlintMultipoint();
                        iom.setKey(properties.getString("_key"));
                        if (properties.containsKey((Object)"_osmId") && geometry.containsKey((Object)"type")) {
                            iom.setWay(Long.parseLong(properties.getJsonNumber("_osmId").toString()));
                            iom.setGeometry(geometry.getJsonString("type").toString());
                            iom.setCoordinates(((JsonValue)geometry.get((Object)"coordinates")).toString());
                            this.item.setItemOsmlintMultipoint(iom);
                        } else {
                            this.item.setStatus(520);
                        }
                    }
                    if (geometry.getString("type").equals("LineString")) {
                        ItemOsmlintLinestring iol = new ItemOsmlintLinestring();
                        iol.setKey(properties.getString("_key"));
                        iol.setWay(Long.parseLong(properties.getString("_osmId")));
                        if (object.containsKey((Object)"geometry")) {
                            iol.setGeometry(geometry.getJsonString("type").toString());
                            iol.setCoordinates(((JsonValue)geometry.get((Object)"coordinates")).toString());
                            this.item.setItemOsmlintLinestring(iol);
                        } else {
                            this.item.setStatus(520);
                        }
                    }
                    if (geometry.getString("type").equals("MultiLineString")) {
                        ItemOsmlintMultilinestring ioml = new ItemOsmlintMultilinestring();
                        ioml.setKey(properties.getString("_key"));
                        ioml.setWay(Long.parseLong(properties.getString("_osmId")));
                        if (object.containsKey((Object)"geometry")) {
                            ioml.setGeometry(geometry.getJsonString("type").toString());
                            ioml.setCoordinates(((JsonValue)geometry.get((Object)"coordinates")).toString());
                            this.item.setItemOsmlintMultilinestring(ioml);
                        } else {
                            this.item.setStatus(520);
                        }
                    }
                    if (geometry.getString("type").equals("Polygon")) {
                        iop = new ItemOsmlintPolygon();
                        iop.setKey(properties.getString("_key"));
                        if (((JsonValue)properties.get((Object)"_osmId")).getValueType().compareTo((Enum)JsonValue.ValueType.STRING) == 0) {
                            iop.setWay(Long.parseLong(properties.getString("_osmId")));
                        } else {
                            iop.setWay(Long.parseLong(properties.getJsonNumber("_osmId").toString()));
                        }
                        if (object.containsKey((Object)"geometry")) {
                            iop.setGeometry(geometry.getJsonString("type").toString());
                            iop.setCoordinates(((JsonValue)geometry.get((Object)"coordinates")).toString());
                            this.item.setItemOsmlintPolygon((ItemOsmlintPolygon)iop);
                        } else {
                            this.item.setStatus(520);
                        }
                    }
                    if (!geometry.getString("type").equals("MultiPolygon")) break;
                    ItemOsmlintMultipolygon iomp = new ItemOsmlintMultipolygon();
                    iomp.setKey(properties.getString("_key"));
                    iomp.setWay(Long.parseLong(properties.getString("_osmId")));
                    if (object.containsKey((Object)"geometry")) {
                        iomp.setGeometry(geometry.getJsonString("type").toString());
                        iomp.setCoordinates(((JsonValue)geometry.get((Object)"coordinates")).toString());
                        this.item.setItemOsmlintMultipolygon(iomp);
                        break;
                    }
                    this.item.setStatus(520);
                    break;
                }
                case 410: {
                    TaskCompleteBean taskCompleteBean = new TaskCompleteBean();
                    taskCompleteBean.setTotal(0);
                    this.item.setTaskCompleteBean(taskCompleteBean);
                    break;
                }
            }
            reader.close();
        }
        catch (Exception ex) {
            Util.alert(ex);
            Logger.getLogger(ItemController.class.getName()).log(Level.SEVERE, null, ex);
        }
        return this.item;
    }
}

