/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.tofix;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.osm.visitor.paint.MapRendererFactory;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class TofixLayer
extends Layer
implements ActionListener {
    LatLon latLon;
    List<Node> list_nodes;
    List<List<Node>> list_list_nodes;
    List<List<List<Node>>> list_list_list_nodes;
    List<List<List<List<Node>>>> list_list_list_list_nodes;
    List<String> type = new ArrayList<String>();
    float width;
    final Collection<OsmPrimitive> points = Main.main.getInProgressSelection();

    public TofixLayer(String name) {
        super(name);
    }

    public Icon getIcon() {
        return ImageProvider.get((String)"icontofix_layer");
    }

    public String getToolTipText() {
        return I18n.tr((String)"Layer to draw OSM error", (Object[])new Object[0]);
    }

    public boolean isMergable(Layer other) {
        return false;
    }

    public void add_Node(LatLon latLon) {
        this.type.add("draw_node");
        this.latLon = latLon;
        Main.map.mapView.repaint();
    }

    public void add_Nodes(List<Node> list_nodes) {
        this.type.add("draw_nodes");
        this.list_nodes = list_nodes;
        Main.map.mapView.repaint();
    }

    public void add_Line(List<List<Node>> list_nodes) {
        this.type.add("draw_line");
        this.list_list_nodes = list_nodes;
        Main.map.mapView.repaint();
    }

    public void add_lines(List<List<List<Node>>> list_nodes) {
        this.type.add("draw_lines");
        this.list_list_list_nodes = list_nodes;
        Main.map.mapView.repaint();
    }

    public void add_Lines(List<List<List<List<Node>>>> list_nodes) {
        this.type.add("draw_Lines");
        this.list_list_list_list_nodes = list_nodes;
        Main.map.mapView.repaint();
    }

    public void paint(Graphics2D g, MapView mv, Bounds bounds) {
        Stroke ss = g.getStroke();
        this.width = MapRendererFactory.getInstance().isWireframeMapRendererActive() ? 1.0f : 5.0f;
        g.setColor(new Color(254, 30, 123));
        g.setStroke(new BasicStroke(this.width));
        for (String typeList : this.type) {
            if ("draw_node".equals(typeList)) {
                Point pnt = mv.getPoint(this.latLon);
                g.drawOval(pnt.x - 25, pnt.y - 25, 50, 50);
                continue;
            }
            if ("draw_line".equals(typeList)) {
                for (List<Node> list : this.list_list_nodes) {
                    for (int i = 0; i < list.size() - 1; ++i) {
                        Point point = mv.getPoint(list.get(i).getCoor());
                        Point pnt2 = mv.getPoint(list.get(i + 1).getCoor());
                        g.drawLine(point.x, point.y, pnt2.x, pnt2.y);
                    }
                }
                continue;
            }
            if ("draw_nodes".equals(typeList)) {
                for (Node node : this.list_nodes) {
                    Point pnt = mv.getPoint(node.getCoor());
                    g.drawOval(pnt.x - 10, pnt.y - 10, 20, 20);
                }
                continue;
            }
            if ("draw_lines".equals(typeList)) {
                for (List<Object> list : this.list_list_list_nodes) {
                    for (List list2 : list) {
                        for (int i = 0; i < list2.size() - 1; ++i) {
                            Point pnt1 = mv.getPoint(((Node)list2.get(i)).getCoor());
                            Point pnt2 = mv.getPoint(((Node)list2.get(i + 1)).getCoor());
                            g.drawLine(pnt1.x, pnt1.y, pnt2.x, pnt2.y);
                        }
                    }
                }
                continue;
            }
            if (!"draw_Lines".equals(typeList)) continue;
            for (List<Object> list : this.list_list_list_list_nodes) {
                for (List list3 : list) {
                    for (List l_nodes : list3) {
                        for (int i = 0; i < l_nodes.size() - 1; ++i) {
                            Point pnt1 = mv.getPoint(((Node)l_nodes.get(i)).getCoor());
                            Point pnt2 = mv.getPoint(((Node)l_nodes.get(i + 1)).getCoor());
                            g.drawLine(pnt1.x, pnt1.y, pnt2.x, pnt2.y);
                        }
                    }
                }
            }
        }
        g.setStroke(ss);
    }

    public void visitBoundingBox(BoundingXYVisitor v) {
    }

    public Object getInfoComponent() {
        return this.getToolTipText();
    }

    public Action[] getMenuEntries() {
        return new Action[]{LayerListDialog.getInstance().createShowHideLayerAction(), Layer.SeparatorLayerAction.INSTANCE, Layer.SeparatorLayerAction.INSTANCE, new LayerListPopup.InfoAction((Layer)this)};
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JOptionPane.showConfirmDialog(null, e.getSource());
    }

    public void mergeFrom(Layer layer) {
    }
}

