/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.gui;

import java.util.ArrayList;
import java.util.Collection;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.plugins.pt_assistant.PTAssistantPlugin;
import org.openstreetmap.josm.plugins.pt_assistant.gui.PTAssistantLayer;
import org.openstreetmap.josm.plugins.pt_assistant.utils.RouteUtils;

public class PTAssistantLayerManager
implements SelectionChangedListener {
    public static PTAssistantLayerManager PTLM = new PTAssistantLayerManager();
    private PTAssistantLayer layer;

    public PTAssistantLayer getLayer() {
        if (this.layer == null) {
            this.layer = new PTAssistantLayer();
        }
        return this.layer;
    }

    public void resetLayer() {
        this.layer = null;
    }

    public void selectionChanged(Collection<? extends OsmPrimitive> newSelection) {
        ArrayList<OsmPrimitive> routes = new ArrayList<OsmPrimitive>();
        for (OsmPrimitive osmPrimitive : newSelection) {
            if (!osmPrimitive.getType().equals((Object)OsmPrimitiveType.RELATION) || !RouteUtils.isTwoDirectionRoute((Relation)osmPrimitive)) continue;
            routes.add(osmPrimitive);
        }
        if (!routes.isEmpty()) {
            this.getLayer().setPrimitives(routes);
            PTAssistantPlugin.clearHighlightedRelations();
            for (OsmPrimitive osmPrimitive : routes) {
                PTAssistantPlugin.addHighlightedRelation((Relation)osmPrimitive);
            }
        }
    }
}

