/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.actions;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.plugins.pt_assistant.utils.RouteUtils;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class EdgeSelectionAction
extends MapMode
implements MouseListener,
MouseMotionListener {
    private Set<Way> highlighted = new HashSet<Way>();
    private Cursor selectionCursor = ImageProvider.getCursor((String)"normal", (String)"selection");
    private Cursor waySelectCursor = ImageProvider.getCursor((String)"normal", (String)"select_way");
    private static final long serialVersionUID = 2414977774504904238L;

    public EdgeSelectionAction() {
        super(I18n.tr((String)"Edge Selection", (Object[])new Object[0]), "edgeSelection", I18n.tr((String)"Edge Selection", (Object[])new Object[0]), Shortcut.registerShortcut((String)"mapmode:edge_selection", (String)I18n.tr((String)"Mode: {0}", (Object[])new Object[]{I18n.tr((String)"Edge Selection", (Object[])new Object[0])}), (int)75, (int)5006), ImageProvider.getCursor((String)"normal", (String)"selection"));
    }

    private List<Way> getEdgeFromWay(Way initial, String modeOfTravel) {
        List options;
        ArrayList<Way> edge = new ArrayList<Way>();
        if (!this.isWaySuitableForMode(initial, modeOfTravel).booleanValue()) {
            return edge;
        }
        Way curr = initial;
        while (true) {
            options = curr.firstNode(true).getParentWays();
            options.remove(curr);
            curr = this.chooseBestWay(options, modeOfTravel);
            if (curr == null || edge.contains(curr)) break;
            edge.add(curr);
        }
        curr = initial;
        while (true) {
            options = curr.lastNode(true).getParentWays();
            options.remove(curr);
            curr = this.chooseBestWay(options, modeOfTravel);
            if (curr == null || edge.contains(curr)) break;
            edge.add(curr);
        }
        edge.add(initial);
        return edge;
    }

    private Boolean isWaySuitableForMode(Way toCheck, String modeOfTravel) {
        if ("bus".equals(modeOfTravel)) {
            return RouteUtils.isWaySuitableForBuses(toCheck);
        }
        return RouteUtils.isWaySuitableForPublicTransport(toCheck);
    }

    private Way chooseBestWay(List<Way> ways, String modeOfTravel) {
        ways.removeIf(w -> this.isWaySuitableForMode((Way)w, modeOfTravel) == false);
        if (ways.isEmpty()) {
            return null;
        }
        if (ways.size() == 1) {
            return ways.get(0);
        }
        Way theChoosenOne = null;
        "bus".equals(modeOfTravel);
        "tram".equals(modeOfTravel);
        return theChoosenOne;
    }

    private String getModeOfTravel() {
        return "bus";
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        DataSet ds = Main.getLayerManager().getEditLayer().data;
        Way initial = Main.map.mapView.getNearestWay(e.getPoint(), AbstractPrimitive::isUsable);
        if (initial != null) {
            ds.setSelected(this.getEdgeFromWay(initial, this.getModeOfTravel()));
        } else {
            ds.clearSelection();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        super.mouseMoved(e);
        for (Way way : this.highlighted) {
            way.setHighlighted(false);
        }
        this.highlighted.clear();
        Way initial = Main.map.mapView.getNearestWay(e.getPoint(), AbstractPrimitive::isUsable);
        if (initial == null) {
            Main.map.mapView.setCursor(this.selectionCursor);
        } else {
            Main.map.mapView.setCursor(this.waySelectCursor);
            this.highlighted.addAll(this.getEdgeFromWay(initial, this.getModeOfTravel()));
        }
        for (Way way : this.highlighted) {
            way.setHighlighted(true);
        }
    }

    public void enterMode() {
        super.enterMode();
        Main.map.mapView.addMouseListener((MouseListener)this);
        Main.map.mapView.addMouseMotionListener((MouseMotionListener)this);
    }

    public void exitMode() {
        super.exitMode();
        Main.map.mapView.removeMouseListener((MouseListener)this);
        Main.map.mapView.removeMouseMotionListener((MouseMotionListener)this);
    }
}

