/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.media.callback.seekable;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.caprica.vlcj.player.media.callback.seekable.SeekableCallbackMedia;

public class RandomAccessFileMedia
extends SeekableCallbackMedia {
    private final Logger logger = LoggerFactory.getLogger(RandomAccessFileMedia.class);
    private final File file;
    private RandomAccessFile randomAccessFile;

    public RandomAccessFileMedia(File file, String ... mediaOptions) {
        super(mediaOptions);
        this.file = file;
    }

    public RandomAccessFileMedia(File file, int ioBufferSize, String ... mediaOptions) {
        super(ioBufferSize, mediaOptions);
        this.file = file;
    }

    @Override
    protected long onGetSize() {
        return this.file.length();
    }

    @Override
    protected boolean onOpen() {
        try {
            this.randomAccessFile = new RandomAccessFile(this.file, "r");
            return true;
        }
        catch (FileNotFoundException e) {
            this.logger.error("File not found");
            return false;
        }
    }

    @Override
    protected int onRead(byte[] buffer, int bufferSize) throws IOException {
        return this.randomAccessFile.read(buffer, 0, bufferSize);
    }

    @Override
    protected boolean onSeek(long offset) {
        try {
            this.randomAccessFile.seek(offset);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    protected void onClose() {
        try {
            this.randomAccessFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

