/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.events;

public enum MediaPlayerEventType {
    NONE(0L),
    MEDIA_CHANGED(1L),
    OPENING(2L),
    BUFFERING(4L),
    PLAYING(8L),
    PAUSED(16L),
    STOPPED(32L),
    FORWARD(64L),
    BACKWARD(128L),
    FINISHED(256L),
    TIME_CHANGED(512L),
    POSITION_CHANGED(1024L),
    SEEKABLE_CHANGED(2048L),
    PAUSABLE_CHANGED(4096L),
    TITLE_CHANGED(8192L),
    SNAPSHOT_TAKEN(16384L),
    LENGTH_CHANGED(32768L),
    VIDEO_OUTPUT(65536L),
    SCRAMBLED_CHANGED(131072L),
    ES_ADDED(262144L),
    ES_DELETED(524288L),
    ES_SELECTED(0x100000L),
    ERROR(0x200000L),
    MEDIA_META_CHANGED(0x400000L),
    MEDIA_SUB_ITEM_ADDED(0x800000L),
    MEDIA_DURATION_CHANGED(0x1000000L),
    MEDIA_PARSED_CHANGED(0x2000000L),
    MEDIA_FREED(0x4000000L),
    MEDIA_STATE_CHANGED(0x8000000L),
    MEDIA_SUB_ITEM_TREE_ADDED(0x10000000L),
    MEDIA_PLAYER_CORKED(0x20000000L),
    MEDIA_PLAYER_MUTED(0x40000000L),
    MEDIA_PLAYER_AUDIO_VOLUME(0x80000000L),
    MEDIA_PLAYER_AUDIO_DEVICE(0x100000000L),
    MEDIA_PLAYER_CHAPTER_CHANGED(0x200000000L),
    NEW_MEDIA(0x400000000L),
    SUB_ITEM_PLAYED(0x800000000L),
    SUB_ITEM_FINISHED(0x1000000000L),
    END_OF_SUB_ITEMS(0x2000000000L),
    ALL(-1L);

    private long value;

    private MediaPlayerEventType(long value) {
        this.value = value;
    }

    public final long value() {
        return this.value;
    }

    public static long events(MediaPlayerEventType ... types) {
        long eventMask = 0L;
        for (MediaPlayerEventType type : types) {
            eventMask |= type.value();
        }
        return eventMask;
    }

    public static long notEvents(MediaPlayerEventType ... types) {
        long eventMask = MediaPlayerEventType.ALL.value;
        for (MediaPlayerEventType type : types) {
            eventMask &= type.value() ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return eventMask;
    }

    public static boolean set(long value, MediaPlayerEventType type) {
        return (value & type.value()) != 0L;
    }

    public static boolean notSet(long value, MediaPlayerEventType type) {
        return (value & type.value()) == 0L;
    }
}

