/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.caprica.vlcj.player.MediaPlayer;
import uk.co.caprica.vlcj.player.MediaPlayerEventAdapter;

public class MediaPlayerLatch {
    private final Logger logger = LoggerFactory.getLogger(MediaPlayerLatch.class);
    private final MediaPlayer mediaPlayer;

    public MediaPlayerLatch(MediaPlayer mediaPlayer) {
        this.mediaPlayer = mediaPlayer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean play() {
        this.logger.debug("play()");
        if (!this.mediaPlayer.isPlaying()) {
            CountDownLatch latch = new CountDownLatch(1);
            LatchListener listener = new LatchListener(latch);
            this.mediaPlayer.addMediaPlayerEventListener(listener);
            this.mediaPlayer.play();
            try {
                this.logger.debug("Waiting for media playing or error...");
                latch.await();
                this.logger.debug("Finished waiting.");
                boolean started = listener.playing.get();
                this.logger.debug("started={}", (Object)started);
                boolean bl = started;
                return bl;
            }
            catch (InterruptedException e) {
                this.logger.debug("Interrupted while waiting for media player", (Throwable)e);
                boolean bl = false;
                return bl;
            }
            finally {
                this.mediaPlayer.removeMediaPlayerEventListener(listener);
            }
        }
        return true;
    }

    private static final class LatchListener
    extends MediaPlayerEventAdapter {
        private final CountDownLatch latch;
        private final AtomicBoolean playing = new AtomicBoolean();

        private LatchListener(CountDownLatch latch) {
            this.latch = latch;
        }

        @Override
        public void playing(MediaPlayer mediaPlayer) {
            this.playing.set(true);
            this.latch.countDown();
        }

        @Override
        public void error(MediaPlayer mediaPlayer) {
            this.playing.set(false);
            this.latch.countDown();
        }
    }
}

