/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.media.callback.nonseekable;

import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.caprica.vlcj.player.media.callback.nonseekable.NonSeekableCallbackMedia;

public abstract class NonSeekableInputStreamMedia
extends NonSeekableCallbackMedia {
    private final Logger logger = LoggerFactory.getLogger(NonSeekableInputStreamMedia.class);
    private InputStream inputStream;

    public NonSeekableInputStreamMedia(String ... mediaOptions) {
        super(mediaOptions);
    }

    public NonSeekableInputStreamMedia(int ioBufferSize, String ... mediaOptions) {
        super(ioBufferSize, mediaOptions);
    }

    @Override
    protected final boolean onOpen() {
        try {
            this.inputStream = this.onOpenStream();
            return true;
        }
        catch (IOException e) {
            this.logger.error("Failed to open stream", (Throwable)e);
            return false;
        }
    }

    @Override
    protected final int onRead(byte[] buffer, int bufferSize) throws IOException {
        return this.inputStream.read(buffer, 0, bufferSize);
    }

    @Override
    protected final void onClose() {
        try {
            this.onCloseStream(this.inputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected abstract InputStream onOpenStream() throws IOException;

    protected abstract void onCloseStream(InputStream var1) throws IOException;
}

