/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.list.events;

public enum MediaListPlayerEventType {
    NONE(0L),
    NEXT_ITEM_SET(1L),
    ALL(-1L);

    private long value;

    private MediaListPlayerEventType(long value) {
        this.value = value;
    }

    public final long value() {
        return this.value;
    }

    public static long events(MediaListPlayerEventType ... types) {
        long eventMask = 0L;
        for (MediaListPlayerEventType type : types) {
            eventMask |= type.value();
        }
        return eventMask;
    }

    public static long notEvents(MediaListPlayerEventType ... types) {
        long eventMask = MediaListPlayerEventType.ALL.value;
        for (MediaListPlayerEventType type : types) {
            eventMask &= type.value() ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return eventMask;
    }

    public static boolean set(long value, MediaListPlayerEventType type) {
        return (value & type.value()) != 0L;
    }

    public static boolean notSet(long value, MediaListPlayerEventType type) {
        return (value & type.value()) == 0L;
    }
}

