/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.embedded;

import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Window;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.caprica.vlcj.player.embedded.FullScreenStrategy;

public class DefaultFullScreenStrategy
implements FullScreenStrategy {
    private final Logger logger = LoggerFactory.getLogger(DefaultFullScreenStrategy.class);
    private final Window window;

    public DefaultFullScreenStrategy(Window window) {
        this.logger.debug("DefaultFullScreenStrategy(window={})", (Object)window);
        if (window == null) {
            throw new IllegalArgumentException("Window must not be null");
        }
        this.window = window;
    }

    @Override
    public void enterFullScreenMode() {
        this.logger.debug("enterFullScreenMode()");
        GraphicsDevice graphicsDevice = this.getScreenDevice();
        this.logger.debug("graphicsDevice={}", (Object)graphicsDevice);
        boolean fullScreenSupported = graphicsDevice.isFullScreenSupported();
        this.logger.debug("fullScreenSupported={}", (Object)fullScreenSupported);
        this.onBeforeEnterFullScreenMode();
        graphicsDevice.setFullScreenWindow(this.window);
        DisplayMode displayMode = this.getDisplayMode(graphicsDevice.getDisplayModes());
        this.logger.debug("displayMode={}", (Object)displayMode);
        if (displayMode != null) {
            this.logger.debug("Setting new display mode");
            graphicsDevice.setDisplayMode(displayMode);
        } else {
            this.logger.debug("Using default display mode");
        }
    }

    @Override
    public void exitFullScreenMode() {
        this.logger.debug("exitFullScreenMode()");
        this.getScreenDevice().setFullScreenWindow(null);
        this.onAfterExitFullScreenMode();
    }

    @Override
    public boolean isFullScreenMode() {
        this.logger.debug("isFullScreenMode()");
        return this.getScreenDevice().getFullScreenWindow() != null;
    }

    protected GraphicsDevice getScreenDevice() {
        this.logger.debug("getScreenDevice()");
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
    }

    protected DisplayMode getDisplayMode(DisplayMode[] displayModes) {
        this.logger.debug("getDisplayMode()", (Object)Arrays.toString(displayModes));
        return null;
    }

    protected void onBeforeEnterFullScreenMode() {
    }

    protected void onAfterExitFullScreenMode() {
    }
}

