/*
 *    GeoTools - The Open Source Java GIS Toolkit
 *    http://geotools.org
 *
 *    (C) 2011, Open Source Geospatial Foundation (OSGeo)
 *    (C) 2003-2005, Open Geospatial Consortium Inc.
 *    
 *    All Rights Reserved. http://www.opengis.org/legal/
 */
package org.opengis.geometry.aggregate;

import java.util.Set;
import org.opengis.geometry.primitive.Point;
import org.opengis.annotation.UML;

import static org.opengis.annotation.Obligation.*;
import static org.opengis.annotation.Specification.*;


/**
 * An aggregate class containing only instances of {@link Point}.
 * The association role {@link #getElements element} shall be the set of
 * {@linkplain Point points} contained in this {@code MultiPoint}.
 *
 *
 *
 * @source $URL$
 * @version <A HREF="http://www.opengeospatial.org/standards/as">ISO 19107</A>
 * @since GeoAPI 1.0
 */
public interface MultiPoint extends MultiPrimitive {
    /**
     * Returns the set containing the elements that compose this {@code MultiPoint}.
     * The set may be modified if this geometry {@linkplain #isMutable is mutable}.
     *
     * @since GeoAPI 2.1
     */
    @UML(identifier="element", obligation=MANDATORY, specification=ISO_19107)
    Set<Point> getElements();

//    public java.util.Vector /*DirectPosition*/ position;
//    public void setPosition(java.util.Vector /*DirectPosition*/ position) {  }
//    public java.util.Vector /*DirectPosition*/ getPosition() { return null; }
}
