/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.factory;

import java.awt.RenderingHints;
import java.lang.ref.Reference;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.imageio.spi.ServiceRegistry;
import org.geotools.factory.AbstractFactory;
import org.geotools.factory.Factory;
import org.geotools.factory.FactoryIteratorProvider;
import org.geotools.factory.FactoryIteratorProviders;
import org.geotools.factory.FactoryNotFoundException;
import org.geotools.factory.FactoryRegistryException;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.factory.OptionalFactory;
import org.geotools.factory.RecursionCheckingHelper;
import org.geotools.factory.RecursiveSearchException;
import org.geotools.resources.Classes;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.i18n.Loggings;
import org.geotools.util.PartiallyOrderedSet;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;

public class FactoryRegistry {
    protected static final Logger LOGGER = Logging.getLogger("org.geotools.factory");
    private static final Level DEBUG_LEVEL = Level.FINEST;
    private final FactoryIteratorProviders globalConfiguration = new FactoryIteratorProviders();
    private Set<Class<?>> needScanForPlugins;
    private final RecursionCheckingHelper scanningCategories = new RecursionCheckingHelper();
    private final RecursionCheckingHelper testingAvailability = new RecursionCheckingHelper();
    private final RecursionCheckingHelper testingHints = new RecursionCheckingHelper();
    private final Map<Class<?>, SubRegistry> categoryMap = new HashMap();

    public FactoryRegistry(Class<?> category) {
        this(Collections.singleton(category));
    }

    public FactoryRegistry(Class<?>[] categories) {
        this(Arrays.asList(categories));
    }

    public FactoryRegistry(Collection<Class<?>> categories) {
        this(categories.iterator());
        Iterator<Class<?>> it = this.getCategories();
        while (it.hasNext()) {
            if (this.needScanForPlugins == null) {
                this.needScanForPlugins = new HashSet();
            }
            this.needScanForPlugins.add(it.next());
        }
    }

    private FactoryRegistry(Iterator<Class<?>> categories) {
        if (categories == null) {
            throw new IllegalArgumentException("categories == null!");
        }
        while (categories.hasNext()) {
            Class<?> category = categories.next();
            this.categoryMap.put(category, new SubRegistry(this, category));
        }
    }

    public synchronized <T> Iterator<T> getServiceProviders(final Class<T> category, final ServiceRegistry.Filter filter, final Hints hints) {
        if (this.scanningCategories.contains(category)) {
            throw new RecursiveSearchException(category);
        }
        ServiceRegistry.Filter hintsFilter = new ServiceRegistry.Filter(){

            @Override
            public boolean filter(Object provider) {
                return FactoryRegistry.this.isAcceptable(category.cast(provider), category, hints, filter);
            }
        };
        this.synchronizeIteratorProviders();
        this.scanForPluginsIfNeeded(category);
        return this.getServiceProviders(category, hintsFilter, true);
    }

    public <T> Iterator<T> getServiceProviders(Class<T> category, ServiceRegistry.Filter filter, boolean order) {
        SubRegistry reg = this.categoryMap.get(category);
        if (reg == null) {
            throw new IllegalArgumentException("category unknown!");
        }
        try {
            Constructor<?> cc = Class.forName("javax.imageio.spi.FilterIterator").getDeclaredConstructor(Iterator.class, ServiceRegistry.Filter.class);
            AccessController.doPrivileged(() -> {
                cc.setAccessible(true);
                return null;
            });
            return (Iterator)cc.newInstance(this.getServiceProviders(category, order), filter);
        }
        catch (IllegalArgumentException | ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> Iterator<T> getServiceProviders(Class<T> category, boolean order) {
        SubRegistry reg = this.categoryMap.get(category);
        if (reg == null) {
            throw new IllegalArgumentException("category unknown!");
        }
        return reg.getServiceProviders(order);
    }

    public <T> T getServiceProviderByClass(Class<T> providerClass) {
        if (providerClass == null) {
            throw new IllegalArgumentException("providerClass == null!");
        }
        for (Class<T> clazz : this.categoryMap.keySet()) {
            T provider;
            if (!clazz.isAssignableFrom(providerClass) || (provider = this.categoryMap.get(clazz).getServiceProviderByClass(providerClass)) == null) continue;
            return provider;
        }
        return null;
    }

    final <T> Iterator<T> getUnfilteredProviders(Class<T> category) {
        if (this.scanningCategories.contains(category)) {
            throw new RecursiveSearchException(category);
        }
        this.scanForPluginsIfNeeded(category);
        return this.getServiceProviders(category, true);
    }

    public <T> T getServiceProvider(Class<T> category, ServiceRegistry.Filter filter, Hints hints, Hints.Key key) throws FactoryRegistryException {
        T candidate;
        this.synchronizeIteratorProviders();
        boolean debug = LOGGER.isLoggable(DEBUG_LEVEL);
        if (debug) {
            FactoryRegistry.debug("ENTRY", category, key, null, null);
        }
        Class implementation = null;
        if (key != null) {
            Object hint;
            Class<?> valueClass = key.getValueClass();
            if (!category.isAssignableFrom(valueClass)) {
                if (debug) {
                    FactoryRegistry.debug("THROW", category, key, "unexpected type:", valueClass);
                }
                throw new IllegalArgumentException(Errors.format(69, key));
            }
            if (hints != null && (hint = hints.get(key)) != null) {
                if (debug) {
                    FactoryRegistry.debug("CHECK", category, key, "user provided a", hint.getClass());
                }
                if (category.isInstance(hint)) {
                    if (debug) {
                        FactoryRegistry.debug("RETURN", category, key, "return hint as provided.", null);
                    }
                    return category.cast(hint);
                }
                if ((hints = new Hints(hints)).remove(key) != hint) {
                    throw new AssertionError(key);
                }
                if (hint instanceof Class[]) {
                    Class[] types = (Class[])hint;
                    int length = types.length;
                    for (int i = 0; i < length - 1; ++i) {
                        T candidate2;
                        Class type = types[i];
                        if (debug) {
                            FactoryRegistry.debug("CHECK", category, key, "consider hint[" + i + ']', type);
                        }
                        if ((candidate2 = this.getServiceImplementation(category, type, filter, hints)) == null) continue;
                        if (debug) {
                            FactoryRegistry.debug("RETURN", category, key, "found implementation", candidate2.getClass());
                        }
                        return candidate2;
                    }
                    if (length != 0) {
                        implementation = types[length - 1];
                    }
                } else {
                    implementation = (Class)hint;
                }
            }
        }
        if (debug && implementation != null) {
            FactoryRegistry.debug("CHECK", category, key, "consider hint[last]", implementation);
        }
        if ((candidate = this.getServiceImplementation(category, implementation, filter, hints)) != null) {
            if (debug) {
                FactoryRegistry.debug("RETURN", category, key, "found implementation", candidate.getClass());
            }
            return candidate;
        }
        if (debug) {
            FactoryRegistry.debug("THROW", category, key, "could not find implementation.", null);
        }
        throw new FactoryNotFoundException(Errors.format(49, implementation != null ? implementation : category));
    }

    private static void debug(String status, Class<?> category, Hints.Key key, String message, Class type) {
        StringBuilder buffer = new StringBuilder(status);
        buffer.append(Utilities.spaces(Math.max(1, 7 - status.length()))).append('(').append(Classes.getShortName(category));
        if (key != null) {
            buffer.append(", ").append(key);
        }
        buffer.append(')');
        if (message != null) {
            buffer.append(": ").append(message);
        }
        if (type != null) {
            buffer.append(' ').append(Classes.getShortName(type)).append('.');
        }
        LogRecord record = new LogRecord(DEBUG_LEVEL, buffer.toString());
        record.setSourceClassName(FactoryRegistry.class.getName());
        record.setSourceMethodName("getServiceProvider");
        record.setLoggerName(LOGGER.getName());
        LOGGER.log(record);
    }

    private <T> T getServiceImplementation(Class<T> category, Class<?> implementation, ServiceRegistry.Filter filter, Hints hints) {
        Iterator<T> it = this.getUnfilteredProviders(category);
        while (it.hasNext()) {
            T candidate = it.next();
            if (implementation != null && !implementation.isInstance(candidate) || !this.isAcceptable(candidate, category, hints, filter)) continue;
            return candidate;
        }
        List<Reference<T>> cached = this.getCachedProviders(category);
        if (cached != null) {
            Iterator<Reference<T>> it2 = cached.iterator();
            while (it2.hasNext()) {
                T candidate = it2.next().get();
                if (candidate == null) {
                    it2.remove();
                    continue;
                }
                if (implementation != null && !implementation.isInstance(candidate) || !this.isAcceptable(candidate, category, hints, filter)) continue;
                return candidate;
            }
        }
        return null;
    }

    <T> List<Reference<T>> getCachedProviders(Class<T> category) {
        return null;
    }

    final <T> boolean isAcceptable(T candidate, Class<T> category, Hints hints, ServiceRegistry.Filter filter) {
        if (filter != null && !filter.filter(candidate)) {
            return false;
        }
        if (!this.isAvailable(candidate)) {
            return false;
        }
        if (hints != null && candidate instanceof Factory && !this.usesAcceptableHints((Factory)candidate, category, hints, null)) {
            return false;
        }
        return this.isAcceptable(candidate, category, hints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean usesAcceptableHints(Factory factory, Class<?> category, Hints hints, Set<Factory> alreadyDone) {
        Map<RenderingHints.Key, Object> implementationHints;
        if (!this.testingHints.addAndCheck(factory)) {
            return false;
        }
        try {
            implementationHints = Hints.stripNonKeys(factory.getImplementationHints());
        }
        finally {
            this.testingHints.removeAndCheck(factory);
        }
        if (implementationHints == null) {
            return true;
        }
        Hints remaining = null;
        for (Map.Entry<RenderingHints.Key, Object> entry : implementationHints.entrySet()) {
            Class type;
            RenderingHints.Key key = entry.getKey();
            Object value = entry.getValue();
            Object expected = hints.get(key);
            if (expected != null) {
                if (expected instanceof Class) {
                    if (!((Class)expected).isInstance(value)) {
                        return false;
                    }
                } else if (expected instanceof Class[]) {
                    Class[] types = (Class[])expected;
                    int i = 0;
                    do {
                        if (i < types.length) continue;
                        return false;
                    } while (!types[i++].isInstance(value));
                } else if (!expected.equals(value)) {
                    return false;
                }
            }
            if (!(value instanceof Factory)) continue;
            Factory dependency = (Factory)value;
            if (alreadyDone == null) {
                alreadyDone = new HashSet<Factory>();
            }
            if (alreadyDone.contains(dependency)) continue;
            alreadyDone.add(factory);
            if (remaining == null) {
                remaining = new Hints(hints);
                remaining.keySet().removeAll(implementationHints.keySet());
            }
            if (this.usesAcceptableHints(dependency, type = key instanceof Hints.Key ? ((Hints.Key)key).getValueClass() : Factory.class, remaining, alreadyDone)) continue;
            return false;
        }
        return true;
    }

    protected <T> boolean isAcceptable(T provider, Class<T> category, Hints hints) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isAvailable(Object provider) {
        if (!(provider instanceof OptionalFactory)) {
            return true;
        }
        OptionalFactory factory = (OptionalFactory)provider;
        Class<?> type = factory.getClass();
        if (!this.testingAvailability.addAndCheck(type)) {
            throw new RecursiveSearchException(type);
        }
        try {
            boolean bl = factory.isAvailable();
            return bl;
        }
        finally {
            this.testingAvailability.removeAndCheck(type);
        }
    }

    public final Set<ClassLoader> getClassLoaders() {
        HashSet<ClassLoader> loaders = new HashSet<ClassLoader>();
        for (int i = 0; i < 4; ++i) {
            ClassLoader loader;
            try {
                switch (i) {
                    case 0: {
                        loader = this.getClass().getClassLoader();
                        break;
                    }
                    case 1: {
                        loader = FactoryRegistry.class.getClassLoader();
                        break;
                    }
                    case 2: {
                        loader = Thread.currentThread().getContextClassLoader();
                        break;
                    }
                    case 3: {
                        loader = ClassLoader.getSystemClassLoader();
                        break;
                    }
                    default: {
                        throw new AssertionError(i);
                    }
                }
            }
            catch (SecurityException exception) {
                continue;
            }
            loaders.add(loader);
        }
        loaders.remove(null);
        loaders.addAll(GeoTools.getClassLoaders());
        ClassLoader[] asArray = loaders.toArray(new ClassLoader[loaders.size()]);
        for (int i = 0; i < asArray.length; ++i) {
            ClassLoader loader = asArray[i];
            try {
                while ((loader = loader.getParent()) != null) {
                    loaders.remove(loader);
                }
                continue;
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (loaders.isEmpty()) {
            LOGGER.warning("No class loaders available.");
        }
        return loaders;
    }

    public void scanForPlugins() {
        Set<ClassLoader> loaders = this.getClassLoaders();
        Iterator<Class<?>> categories = this.getCategories();
        while (categories.hasNext()) {
            Class<?> category = categories.next();
            this.scanForPlugins(loaders, category);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void scanForPlugins(Collection<ClassLoader> loaders, Class<T> category) {
        if (!this.scanningCategories.addAndCheck(category)) {
            throw new RecursiveSearchException(category);
        }
        try {
            StringBuilder message = FactoryRegistry.getLogHeader(category);
            boolean newServices = false;
            for (ClassLoader loader : loaders) {
                newServices |= this.register(ServiceLoader.load(category, loader).iterator(), category, message);
                newServices |= this.registerFromSystemProperty(loader, category, message);
            }
            FactoryIteratorProvider[] fip = FactoryIteratorProviders.getIteratorProviders();
            for (int i = 0; i < fip.length; ++i) {
                Iterator<T> it = fip[i].iterator(category);
                if (it == null) continue;
                newServices |= this.register(it, category, message);
            }
            if (newServices) {
                FactoryRegistry.log("scanForPlugins", message);
            }
        }
        finally {
            this.scanningCategories.removeAndCheck(category);
        }
    }

    private <T> void scanForPluginsIfNeeded(Class<?> category) {
        if (this.needScanForPlugins != null && this.needScanForPlugins.remove(category)) {
            if (this.needScanForPlugins.isEmpty()) {
                this.needScanForPlugins = null;
            }
            this.scanForPlugins(this.getClassLoaders(), category);
        }
    }

    private <T> boolean register(Iterator<T> factories, Class<T> category, StringBuilder message) {
        boolean newServices = false;
        String lineSeparator = System.getProperty("line.separator", "\n");
        while (factories.hasNext()) {
            T factory;
            try {
                factory = factories.next();
            }
            catch (OutOfMemoryError error) {
                throw error;
            }
            catch (NoClassDefFoundError error) {
                FactoryRegistry.loadingFailure(category, error, false);
                continue;
            }
            catch (ExceptionInInitializerError error) {
                Throwable cause = error.getCause();
                if (cause != null) {
                    FactoryRegistry.loadingFailure(category, cause, true);
                }
                throw error;
            }
            catch (Error error) {
                if (!Classes.getShortClassName(error).equals("ServiceConfigurationError")) {
                    throw error;
                }
                FactoryRegistry.loadingFailure(category, error, true);
                continue;
            }
            if (!category.isAssignableFrom(factory.getClass())) continue;
            Class<T> factoryClass = factory.getClass().asSubclass(category);
            T replacement = this.getServiceProviderByClass(factoryClass);
            if (replacement != null) {
                factory = replacement;
            }
            if (!this.registerServiceProvider(factory, category)) continue;
            message.append(lineSeparator);
            message.append("  ");
            message.append(factoryClass.getName());
            newServices = true;
        }
        return newServices;
    }

    public <T> boolean registerServiceProvider(T provider, Class<T> category) {
        if (provider == null) {
            throw new IllegalArgumentException("provider == null!");
        }
        SubRegistry reg = this.categoryMap.get(category);
        if (reg == null) {
            throw new IllegalArgumentException("category unknown!");
        }
        if (!category.isAssignableFrom(provider.getClass())) {
            throw new ClassCastException();
        }
        return reg.registerServiceProvider(provider);
    }

    public void registerServiceProvider(Object provider) {
        if (provider == null) {
            throw new IllegalArgumentException("provider == null!");
        }
        Iterator<SubRegistry> regs = this.getSubRegistries(provider);
        while (regs.hasNext()) {
            regs.next().registerServiceProvider(provider);
        }
    }

    public void deregisterServiceProvider(Object provider) {
        if (provider == null) {
            throw new IllegalArgumentException("provider == null!");
        }
        Iterator<SubRegistry> regs = this.getSubRegistries(provider);
        while (regs.hasNext()) {
            regs.next().deregisterServiceProvider(provider);
        }
    }

    private <T> boolean registerFromSystemProperty(ClassLoader loader, Class<T> category, StringBuilder message) {
        boolean newServices;
        block10: {
            newServices = false;
            try {
                String classname = System.getProperty(category.getName());
                if (classname == null) break block10;
                try {
                    Class<?> candidate = loader.loadClass(classname);
                    if (!category.isAssignableFrom(candidate)) break block10;
                    Class<T> factoryClass = candidate.asSubclass(category);
                    T factory = this.getServiceProviderByClass(factoryClass);
                    if (factory == null) {
                        try {
                            factory = factoryClass.newInstance();
                            if (this.registerServiceProvider(factory, category)) {
                                message.append(System.getProperty("line.separator", "\n"));
                                message.append("  ");
                                message.append(factoryClass.getName());
                                newServices = true;
                            }
                        }
                        catch (IllegalAccessException exception) {
                            throw new FactoryRegistryException(Errors.format(23, classname), exception);
                        }
                        catch (InstantiationException exception) {
                            throw new FactoryRegistryException(Errors.format(23, classname), exception);
                        }
                    }
                    Iterator<T> it = this.getServiceProviders(category, false);
                    while (it.hasNext()) {
                        T other = it.next();
                        if (other == factory) continue;
                        this.setOrdering(category, factory, other);
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return newServices;
    }

    private static void loadingFailure(Class<?> category, Throwable error, boolean showStackTrace) {
        String name = Classes.getShortName(category);
        StringBuilder cause = new StringBuilder(Classes.getShortClassName(error));
        String message = error.getLocalizedMessage();
        if (message != null) {
            cause.append(": ");
            cause.append(message);
        }
        LogRecord record = Loggings.format(Level.WARNING, 8, name, cause.toString());
        if (showStackTrace) {
            record.setThrown(error);
        }
        record.setSourceClassName(FactoryRegistry.class.getName());
        record.setSourceMethodName("scanForPlugins");
        record.setLoggerName(LOGGER.getName());
        LOGGER.log(record);
    }

    private static StringBuilder getLogHeader(Class<?> category) {
        return new StringBuilder(Loggings.getResources(null).getString(21, category));
    }

    private static void log(String method, StringBuilder message) {
        LogRecord record = new LogRecord(Level.CONFIG, message.toString());
        record.setSourceClassName(FactoryRegistry.class.getName());
        record.setSourceMethodName(method);
        record.setLoggerName(LOGGER.getName());
        LOGGER.log(record);
    }

    private void synchronizeIteratorProviders() {
        FactoryIteratorProvider[] newProviders = this.globalConfiguration.synchronizeIteratorProviders();
        if (newProviders == null) {
            return;
        }
        Iterator<Class<?>> categories = this.getCategories();
        while (categories.hasNext()) {
            Class<?> category = categories.next();
            if (this.needScanForPlugins != null && this.needScanForPlugins.contains(category)) continue;
            for (int i = 0; i < newProviders.length; ++i) {
                this.register(newProviders[i], category);
            }
        }
    }

    private <T> void register(FactoryIteratorProvider provider, Class<T> category) {
        StringBuilder message;
        Iterator<T> it = provider.iterator(category);
        if (it != null && this.register(it, category, message = FactoryRegistry.getLogHeader(category))) {
            FactoryRegistry.log("synchronizeIteratorProviders", message);
        }
    }

    public <T> boolean setOrdering(Class<T> category, Comparator<T> comparator) {
        boolean set = false;
        ArrayList<T> previous = new ArrayList<T>();
        Iterator<T> it = this.getServiceProviders(category, false);
        while (it.hasNext()) {
            T f1 = it.next();
            int i = previous.size();
            while (--i >= 0) {
                int c;
                Object f2 = previous.get(i);
                try {
                    c = comparator.compare(f1, f2);
                }
                catch (ClassCastException exception) {
                    continue;
                }
                if (c > 0) {
                    set |= this.setOrdering(category, f1, f2);
                    continue;
                }
                if (c >= 0) continue;
                set |= this.setOrdering(category, f2, f1);
            }
            previous.add(f1);
        }
        return set;
    }

    public <T> boolean setOrdering(Class<T> base, boolean set, ServiceRegistry.Filter service1, ServiceRegistry.Filter service2) {
        boolean done = false;
        Iterator<Class<?>> categories = this.getCategories();
        while (categories.hasNext()) {
            Class<?> candidate = categories.next();
            if (!base.isAssignableFrom(candidate)) continue;
            Class<T> category = candidate.asSubclass(base);
            done |= this.setOrUnsetOrdering(category, set, service1, service2);
        }
        return done;
    }

    public <T> boolean setOrdering(Class<T> category, T firstProvider, T secondProvider) {
        if (firstProvider == null || secondProvider == null) {
            throw new IllegalArgumentException("provider is null!");
        }
        if (firstProvider == secondProvider) {
            throw new IllegalArgumentException("providers are the same!");
        }
        SubRegistry reg = this.categoryMap.get(category);
        if (reg == null) {
            throw new IllegalArgumentException("category unknown!");
        }
        if (reg.contains(firstProvider) && reg.contains(secondProvider)) {
            return reg.setOrdering(firstProvider, secondProvider);
        }
        return false;
    }

    public <T> boolean unsetOrdering(Class<T> category, T firstProvider, T secondProvider) {
        if (firstProvider == null || secondProvider == null) {
            throw new IllegalArgumentException("provider is null!");
        }
        if (firstProvider == secondProvider) {
            throw new IllegalArgumentException("providers are the same!");
        }
        SubRegistry reg = this.categoryMap.get(category);
        if (reg == null) {
            throw new IllegalArgumentException("category unknown!");
        }
        if (reg.contains(firstProvider) && reg.contains(secondProvider)) {
            return reg.unsetOrdering(firstProvider, secondProvider);
        }
        return false;
    }

    private <T> boolean setOrUnsetOrdering(Class<T> category, boolean set, ServiceRegistry.Filter service1, ServiceRegistry.Filter service2) {
        boolean done = false;
        T impl1 = null;
        T impl2 = null;
        Iterator<T> it = this.getServiceProviders(category, false);
        while (it.hasNext()) {
            T factory = it.next();
            if (service1.filter(factory)) {
                impl1 = factory;
            }
            if (service2.filter(factory)) {
                impl2 = factory;
            }
            if (impl1 == null || impl2 == null || impl1 == impl2) continue;
            if (set) {
                done |= this.setOrdering(category, impl1, impl2);
                continue;
            }
            done |= this.unsetOrdering(category, impl1, impl2);
        }
        return done;
    }

    public Iterator<Class<?>> getCategories() {
        return this.categoryMap.keySet().iterator();
    }

    private Iterator<SubRegistry> getSubRegistries(Object provider) {
        ArrayList<SubRegistry> l = new ArrayList<SubRegistry>();
        for (Class<?> c : this.categoryMap.keySet()) {
            if (!c.isAssignableFrom(provider.getClass())) continue;
            l.add(this.categoryMap.get(c));
        }
        return l.iterator();
    }

    public void deregisterAll() {
        Iterator<SubRegistry> iter = this.categoryMap.values().iterator();
        while (iter.hasNext()) {
            iter.next().clear();
        }
    }

    private static class SubRegistry {
        private final FactoryRegistry registry;
        private final Class<?> category;
        private final PartiallyOrderedSet<Object> poset;
        private final Map<Class<?>, Object> map = new HashMap();

        public SubRegistry(FactoryRegistry registry, Class<?> category) {
            this.registry = registry;
            this.category = category;
            this.poset = new PartiallyOrderedSet();
        }

        public boolean registerServiceProvider(Object provider) {
            boolean present;
            Object oprovider = this.map.get(provider.getClass());
            boolean bl = present = oprovider != null;
            if (present) {
                this.deregisterServiceProvider(oprovider);
            }
            this.map.put(provider.getClass(), provider);
            this.poset.add(provider);
            if (provider instanceof AbstractFactory) {
                ((AbstractFactory)provider).onRegistration(this.registry, this.category);
            }
            return !present;
        }

        public boolean deregisterServiceProvider(Object provider) {
            Object oprovider = this.map.get(provider.getClass());
            if (provider == oprovider) {
                this.map.remove(provider.getClass());
                this.poset.remove(provider);
                if (provider instanceof AbstractFactory) {
                    ((AbstractFactory)provider).onDeregistration(this.registry, this.category);
                }
                return true;
            }
            return false;
        }

        public boolean contains(Object provider) {
            return this.map.get(provider.getClass()) == provider;
        }

        public boolean setOrdering(Object firstProvider, Object secondProvider) {
            return this.poset.setOrder(firstProvider, secondProvider);
        }

        public boolean unsetOrdering(Object firstProvider, Object secondProvider) {
            return this.poset.clearOrder(firstProvider, secondProvider);
        }

        public Iterator getServiceProviders(boolean useOrdering) {
            if (useOrdering) {
                return this.poset.iterator();
            }
            return this.map.values().iterator();
        }

        public <T> T getServiceProviderByClass(Class<T> providerClass) {
            return (T)this.map.get(providerClass);
        }

        public void clear() {
            Iterator<Object> iter = this.map.values().iterator();
            while (iter.hasNext()) {
                Object provider = iter.next();
                iter.remove();
                if (!(provider instanceof AbstractFactory)) continue;
                ((AbstractFactory)provider).onDeregistration(this.registry, this.category);
            }
            this.poset.clear();
        }

        public void finalize() {
            this.clear();
        }
    }
}

