/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml;

import javax.xml.namespace.QName;
import org.xml.sax.helpers.NamespaceSupport;

public class XMLUtils {
    public static String removeXMLInvalidChars(String in) {
        if (in == null || "".equals(in)) {
            return in;
        }
        int lenght = in.length();
        int invalid = 0;
        for (int i = 0; i < lenght; ++i) {
            char current = in.charAt(i);
            if (XMLUtils.isXMLValidChar(current)) continue;
            ++invalid;
        }
        if (invalid > 0) {
            StringBuilder out = new StringBuilder(in.length() - invalid);
            for (int i = 0; i < lenght; ++i) {
                char current = in.charAt(i);
                if (!XMLUtils.isXMLValidChar(current)) continue;
                out.append(current);
            }
            in = out.toString();
        }
        return in;
    }

    public static QName qName(String name, NamespaceSupport namespaces) {
        int dot = name.indexOf(58);
        if (dot > -1) {
            String[] split = name.split(":");
            String prefix = split[0];
            String local = split[1];
            return new QName(namespaces.getURI(prefix), local, prefix);
        }
        return new QName(name);
    }

    private static boolean isXMLValidChar(char c) {
        return c == '\t' || c == '\n' || c == '\r' || c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd' || c >= '\u10000' && c <= '\u10ffff';
    }
}

