/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.EventListenerList;
import org.geotools.data.FeatureEvent;
import org.geotools.data.FeatureListener;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureStore;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.logging.Logging;
import org.opengis.feature.Feature;
import org.opengis.feature.type.FeatureType;

public class FeatureListenerManager {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data");
    Map<FeatureSource<? extends FeatureType, ? extends Feature>, EventListenerList> listenerMap = new WeakHashMap<FeatureSource<? extends FeatureType, ? extends Feature>, EventListenerList>();

    public void addFeatureListener(FeatureSource<? extends FeatureType, ? extends Feature> featureSource, FeatureListener featureListener) {
        this.eventListenerList(featureSource).add(FeatureListener.class, featureListener);
    }

    void removeFeatureListener(WeakFeatureListener listener) {
        for (EventListenerList list : this.listenerMap.values()) {
            list.remove(FeatureListener.class, listener);
        }
    }

    public void removeFeatureListener(FeatureSource<? extends FeatureType, ? extends Feature> featureSource, FeatureListener featureListener) {
        EventListenerList list = this.eventListenerList(featureSource);
        list.remove(FeatureListener.class, featureListener);
        if (list.getListenerCount() == 0) {
            this.cleanListenerList(featureSource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EventListenerList eventListenerList(FeatureSource<? extends FeatureType, ? extends Feature> featureSource) {
        Map<FeatureSource<? extends FeatureType, ? extends Feature>, EventListenerList> map = this.listenerMap;
        synchronized (map) {
            if (this.listenerMap.containsKey(featureSource)) {
                return this.listenerMap.get(featureSource);
            }
            EventListenerList listenerList = new EventListenerList();
            this.listenerMap.put(featureSource, listenerList);
            return listenerList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanListenerList(FeatureSource<? extends FeatureType, ? extends Feature> featureSource) {
        Map<FeatureSource<? extends FeatureType, ? extends Feature>, EventListenerList> map = this.listenerMap;
        synchronized (map) {
            this.listenerMap.remove(featureSource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<SimpleFeatureSource, FeatureListener[]> getListeners(String typeName, Transaction transaction) {
        HashMap<SimpleFeatureSource, FeatureListener[]> map = new HashMap<SimpleFeatureSource, FeatureListener[]>();
        Map<FeatureSource<? extends FeatureType, ? extends Feature>, EventListenerList> map2 = this.listenerMap;
        synchronized (map2) {
            for (Map.Entry<FeatureSource<? extends FeatureType, ? extends Feature>, EventListenerList> entry : this.listenerMap.entrySet()) {
                EventListenerList listenerList;
                FeatureListener[] listeners;
                SimpleFeatureSource featureSource = (SimpleFeatureSource)entry.getKey();
                if (!featureSource.getName().getLocalPart().equals(typeName) || transaction != Transaction.AUTO_COMMIT && FeatureListenerManager.hasTransaction(featureSource) && transaction != FeatureListenerManager.getTransaction(featureSource) || (listeners = (FeatureListener[])(listenerList = entry.getValue()).getListeners(FeatureListener.class)).length == 0) continue;
                map.put(featureSource, listeners);
            }
        }
        return map;
    }

    private static boolean hasTransaction(FeatureSource<? extends FeatureType, ? extends Feature> featureSource) {
        return featureSource instanceof FeatureStore && ((FeatureStore)featureSource).getTransaction() != null;
    }

    private static Transaction getTransaction(FeatureSource<? extends FeatureType, ? extends Feature> featureSource) {
        if (FeatureListenerManager.hasTransaction(featureSource)) {
            return ((FeatureStore)featureSource).getTransaction();
        }
        return Transaction.AUTO_COMMIT;
    }

    public void fireFeaturesAdded(String typeName, Transaction transaction, ReferencedEnvelope bounds, boolean commit) {
        if (commit) {
            this.fireCommit(typeName, transaction, 1, bounds);
        } else {
            this.fireEvent(typeName, transaction, 1, bounds);
        }
    }

    public void fireEvent(String typeName, Transaction transaction, FeatureEvent event) {
        if (event.getType() == FeatureEvent.Type.COMMIT || event.getType() == FeatureEvent.Type.ROLLBACK) {
            Map<SimpleFeatureSource, FeatureListener[]> map = this.getListeners(typeName, Transaction.AUTO_COMMIT);
            for (Map.Entry<SimpleFeatureSource, FeatureListener[]> entry : map.entrySet()) {
                FeatureSource featureSource = entry.getKey();
                FeatureListener[] listeners = entry.getValue();
                event.setFeatureSource(featureSource);
                for (FeatureListener listener : listeners) {
                    try {
                        listener.changed(event);
                    }
                    catch (Throwable t) {
                        LOGGER.log(Level.FINE, "Could not deliver " + event + " to " + listener + ":" + t.getMessage(), t);
                    }
                }
            }
        } else {
            Map<SimpleFeatureSource, FeatureListener[]> map = this.getListeners(typeName, transaction);
            for (Map.Entry<SimpleFeatureSource, FeatureListener[]> entry : map.entrySet()) {
                FeatureSource featureSource = entry.getKey();
                FeatureListener[] listeners = entry.getValue();
                event.setFeatureSource(featureSource);
                for (FeatureListener listener : listeners) {
                    try {
                        listener.changed(event);
                    }
                    catch (Throwable t) {
                        LOGGER.log(Level.FINE, "Could not deliver " + event + " to " + listener + ":" + t.getMessage(), t);
                    }
                }
            }
        }
    }

    public void fireFeaturesChanged(String typeName, Transaction transaction, ReferencedEnvelope bounds, boolean commit) {
        if (commit) {
            this.fireCommit(typeName, transaction, 0, bounds);
        } else {
            this.fireEvent(typeName, transaction, 0, bounds);
        }
    }

    public void fireChanged(String typeName, Transaction transaction, boolean commit) {
        if (commit) {
            this.fireCommit(typeName, transaction, 0, null);
        } else {
            this.fireEvent(typeName, transaction, 0, null);
        }
    }

    private void fireCommit(String typeName, Transaction transaction, int type, ReferencedEnvelope bounds) {
        Map<SimpleFeatureSource, FeatureListener[]> map = this.getListeners(typeName, Transaction.AUTO_COMMIT);
        for (Map.Entry<SimpleFeatureSource, FeatureListener[]> entry : map.entrySet()) {
            FeatureSource featureSource = entry.getKey();
            FeatureListener[] listeners = entry.getValue();
            if (FeatureListenerManager.hasTransaction(featureSource) && FeatureListenerManager.getTransaction(featureSource) == transaction) continue;
            FeatureEvent event = new FeatureEvent(featureSource, type, bounds);
            for (int l = 0; l < listeners.length; ++l) {
                listeners[l].changed(event);
            }
        }
    }

    private void fireEvent(String typeName, Transaction transaction, int type, ReferencedEnvelope bounds) {
        Map<SimpleFeatureSource, FeatureListener[]> map = this.getListeners(typeName, transaction);
        for (Map.Entry<SimpleFeatureSource, FeatureListener[]> entry : map.entrySet()) {
            FeatureSource featureSource = entry.getKey();
            FeatureListener[] listeners = entry.getValue();
            FeatureEvent event = new FeatureEvent(featureSource, type, bounds);
            for (int l = 0; l < listeners.length; ++l) {
                listeners[l].changed(event);
            }
        }
    }

    public void fireFeaturesRemoved(String typeName, Transaction transaction, ReferencedEnvelope bounds, boolean commit) {
        if (commit) {
            this.fireCommit(typeName, transaction, -1, bounds);
        } else {
            this.fireEvent(typeName, transaction, -1, bounds);
        }
    }

    class WeakFeatureListener
    implements FeatureListener {
        WeakReference<FeatureListener> reference;

        public WeakFeatureListener(FeatureListener listener) {
            this.reference = new WeakReference<FeatureListener>(listener);
        }

        @Override
        public void changed(FeatureEvent featureEvent) {
            FeatureListener listener = (FeatureListener)this.reference.get();
            if (listener == null) {
                FeatureListenerManager.this.removeFeatureListener(this);
            } else {
                listener.changed(featureEvent);
            }
        }
    }
}

