/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image;

import com.sun.media.jai.util.PropertyGeneratorImpl;
import it.geosolutions.jaiext.utilities.ImageLayout2;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import javax.media.jai.GeometricOpImage;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.OperationRegistry;
import javax.media.jai.PlanarImage;
import javax.media.jai.PropertyGenerator;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.RenderedOp;
import javax.media.jai.Warp;
import javax.media.jai.operator.ConstantDescriptor;
import org.geotools.factory.Hints;

public class GTWarpPropertyGenerator
extends PropertyGeneratorImpl {
    private static final long serialVersionUID = 6622489670499745306L;
    static boolean registered = false;

    public GTWarpPropertyGenerator() {
        super(new String[]{"ROI"}, new Class[]{ROI.class}, new Class[]{RenderedOp.class});
    }

    public static synchronized void register(boolean force) {
        if (!registered || force) {
            OperationRegistry registry = JAI.getDefaultInstance().getOperationRegistry();
            registry.addPropertyGenerator("rendered", "Warp", (PropertyGenerator)new GTWarpPropertyGenerator());
            registered = true;
        }
    }

    public Object getProperty(String name, Object opNode) {
        this.validate(name, opNode);
        if (opNode instanceof RenderedOp && name.equalsIgnoreCase("roi")) {
            RenderedOp op = (RenderedOp)opNode;
            ParameterBlock pb = op.getParameterBlock();
            RenderedImage src = pb.getRenderedSource(0);
            Object property = src.getProperty("ROI");
            if (property == null || property.equals(Image.UndefinedProperty) || !(property instanceof ROI)) {
                return Image.UndefinedProperty;
            }
            ROI srcROI = (ROI)property;
            if (srcROI.getBounds().isEmpty()) {
                return Image.UndefinedProperty;
            }
            Interpolation interp = (Interpolation)pb.getObjectParameter(1);
            Rectangle srcBounds = null;
            PlanarImage dst = op.getRendering();
            srcBounds = dst instanceof GeometricOpImage && ((GeometricOpImage)dst).getBorderExtender() == null ? new Rectangle(src.getMinX() + interp.getLeftPadding(), src.getMinY() + interp.getTopPadding(), src.getWidth() - interp.getWidth() + 1, src.getHeight() - interp.getHeight() + 1) : new Rectangle(src.getMinX(), src.getMinY(), src.getWidth(), src.getHeight());
            if (!srcBounds.contains(srcROI.getBounds())) {
                srcROI = srcROI.intersect((ROI)new ROIShape((Shape)srcBounds));
            }
            Warp warp = (Warp)pb.getObjectParameter(0);
            Rectangle dstBounds = op.getBounds();
            ImageLayout2 layout = new ImageLayout2();
            int minx = (int)srcBounds.getMinX();
            int miny = (int)srcBounds.getMinY();
            int w = (int)srcBounds.getWidth();
            int h = (int)srcBounds.getHeight();
            layout.setMinX(minx);
            layout.setMinY(miny);
            layout.setWidth(w);
            layout.setHeight(h);
            layout.setTileWidth(op.getTileWidth());
            layout.setTileHeight(op.getTileHeight());
            RenderingHints hints = op.getRenderingHints();
            hints.add(new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout));
            RenderedOp constantImage = ConstantDescriptor.create((Float)new Float(w), (Float)new Float(h), (Number[])new Byte[]{(byte)-1}, (RenderingHints)hints);
            RenderedOp roiImage = null;
            RenderingHints warpingHints = op.getRenderingHints();
            warpingHints.remove(JAI.KEY_IMAGE_LAYOUT);
            ParameterBlock paramBlk = new ParameterBlock();
            paramBlk.addSource(constantImage);
            paramBlk.add(warp);
            paramBlk.add(interp);
            paramBlk.add(null);
            paramBlk.add(srcROI);
            Hints localHints = new Hints(op.getRenderingHints());
            localHints.remove((Object)JAI.KEY_IMAGE_LAYOUT);
            ImageLayout il = new ImageLayout();
            il.setMinX(dstBounds.x);
            il.setMinY(dstBounds.y);
            il.setWidth(dstBounds.width);
            il.setHeight(dstBounds.height);
            il.setTileWidth(op.getTileWidth());
            il.setTileHeight(op.getTileHeight());
            localHints.put((Object)JAI.KEY_IMAGE_LAYOUT, (Object)il);
            roiImage = JAI.create((String)"Warp", (ParameterBlock)paramBlk, (RenderingHints)localHints);
            ROI dstROI = new ROI((RenderedImage)roiImage, 1);
            if (!dstBounds.contains(dstROI.getBounds())) {
                dstROI = dstROI.intersect((ROI)new ROIShape((Shape)dstBounds));
            }
            return dstROI;
        }
        return Image.UndefinedProperty;
    }
}

