/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.grid;

import java.awt.geom.AffineTransform;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.coverage.grid.GeneralGridEnvelope;
import org.geotools.coverage.grid.InvalidGridGeometryException;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.metadata.iso.spatial.PixelTranslation;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.builder.GridToEnvelopeMapper;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.resources.Classes;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.coverage.grid.GridGeometry;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.Cloneable;

public class GeneralGridGeometry
implements GridGeometry,
Serializable {
    static final Logger LOGGER = Logging.getLogger(GeneralGridGeometry.class);
    private static final long serialVersionUID = 124700383873732132L;
    private static boolean assertsEnabled = false;
    public static final int CRS_BITMASK = 1;
    public static final int ENVELOPE_BITMASK = 2;
    public static final int GRID_RANGE_BITMASK = 4;
    public static final int GRID_TO_CRS_BITMASK = 8;
    protected final GridEnvelope gridRange;
    GeneralEnvelope envelope;
    protected MathTransform gridToCRS;
    private MathTransform cornerToCRS;

    GeneralGridGeometry(GeneralGridGeometry gm, CoordinateReferenceSystem crs) {
        this.gridRange = gm.gridRange;
        this.gridToCRS = gm.gridToCRS;
        this.cornerToCRS = gm.cornerToCRS;
        this.envelope = new GeneralEnvelope(gm.envelope);
        this.envelope.setCoordinateReferenceSystem(crs);
    }

    public GeneralGridGeometry(GridGeometry other) {
        if (other instanceof GeneralGridGeometry) {
            GeneralGridGeometry general = (GeneralGridGeometry)other;
            this.gridRange = general.gridRange;
            this.gridToCRS = general.gridToCRS;
            this.cornerToCRS = general.cornerToCRS;
            this.envelope = general.envelope;
        } else {
            this.gridRange = other.getGridRange();
            this.gridToCRS = other.getGridToCRS();
            this.envelope = this.gridRange != null && this.gridToCRS != null ? new GeneralEnvelope(this.gridRange, PixelInCell.CELL_CENTER, this.gridToCRS, null) : null;
        }
    }

    public GeneralGridGeometry(GridEnvelope gridRange, MathTransform gridToCRS, CoordinateReferenceSystem crs) throws MismatchedDimensionException, IllegalArgumentException {
        this(gridRange, PixelInCell.CELL_CENTER, gridToCRS, crs);
    }

    public GeneralGridGeometry(GridEnvelope gridRange, PixelInCell anchor, MathTransform gridToCRS, CoordinateReferenceSystem crs) throws MismatchedDimensionException, IllegalArgumentException {
        this.gridRange = GeneralGridGeometry.clone(gridRange);
        this.gridToCRS = PixelTranslation.translate(gridToCRS, anchor, PixelInCell.CELL_CENTER);
        if (PixelInCell.CELL_CORNER.equals((Object)anchor)) {
            this.cornerToCRS = gridToCRS;
        }
        if (gridRange != null && gridToCRS != null) {
            this.envelope = new GeneralEnvelope(gridRange, anchor, gridToCRS, crs);
        } else if (crs != null) {
            this.envelope = new GeneralEnvelope(crs);
            this.envelope.setToNull();
        } else {
            this.envelope = null;
        }
    }

    private static Envelope toEnvelope(GridEnvelope gridRange) {
        int dimension = gridRange.getDimension();
        double[] lower = new double[dimension];
        double[] upper = new double[dimension];
        for (int i = 0; i < dimension; ++i) {
            lower[i] = gridRange.getLow(i);
            upper[i] = gridRange.getHigh(i) + 1;
        }
        return new GeneralEnvelope(lower, upper);
    }

    public GeneralGridGeometry(PixelInCell anchor, MathTransform gridToCRS, Envelope envelope, boolean gridMaxInclusive, boolean preserveGridToCRS) throws MismatchedDimensionException, IllegalArgumentException {
        GeneralEnvelope transformed;
        this.gridToCRS = PixelTranslation.translate(gridToCRS, anchor, PixelInCell.CELL_CENTER);
        this.cornerToCRS = PixelInCell.CELL_CORNER.equals((Object)anchor) ? gridToCRS : PixelTranslation.translate(gridToCRS, anchor, PixelInCell.CELL_CORNER);
        if (envelope == null) {
            this.envelope = null;
            this.gridRange = null;
            return;
        }
        this.envelope = new GeneralEnvelope(envelope);
        if (gridToCRS == null) {
            this.gridRange = null;
            return;
        }
        try {
            transformed = CRS.transform(this.cornerToCRS.inverse(), envelope);
        }
        catch (TransformException exception) {
            throw new IllegalArgumentException(Errors.format((int)15, (Object)Classes.getClass((Object)gridToCRS)), exception);
        }
        this.gridRange = new GeneralGridEnvelope(transformed, PixelInCell.CELL_CORNER, gridMaxInclusive);
        if (preserveGridToCRS) {
            GeneralEnvelope tempEnvelope;
            try {
                tempEnvelope = CRS.transform(this.getGridToCRS(), GeneralGridGeometry.toEnvelope(this.gridRange));
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
            tempEnvelope.setCoordinateReferenceSystem(envelope.getCoordinateReferenceSystem());
            this.envelope = tempEnvelope;
        } else if (gridToCRS != null) {
            double xScale = transformed.getSpan(0) / (double)this.gridRange.getSpan(0);
            double yScale = transformed.getSpan(1) / (double)this.gridRange.getSpan(1);
            double xTrans = transformed.getMinimum(0) - xScale * (double)this.gridRange.getLow(0);
            double yTrans = transformed.getMinimum(1) - yScale * (double)this.gridRange.getLow(1);
            AffineTransform newTr = new AffineTransform(xScale, 0.0, 0.0, yScale, xTrans, yTrans);
            newTr.preConcatenate((AffineTransform)this.cornerToCRS);
            this.cornerToCRS = ProjectiveTransform.create(newTr);
            this.gridToCRS = PixelTranslation.translate(this.cornerToCRS, PixelInCell.CELL_CORNER, PixelInCell.CELL_CENTER);
            if (assertsEnabled) {
                try {
                    MathTransform tr = this.cornerToCRS;
                    if (!(tr instanceof AffineTransform)) {
                        return;
                    }
                    AffineTransform transform = (AffineTransform)tr;
                    double scale = Math.min(XAffineTransform.getScaleX0(transform), XAffineTransform.getScaleY0(transform));
                    GeneralEnvelope tempEnvelope = CRS.transform(tr, GeneralGridGeometry.toEnvelope(this.gridRange));
                    tempEnvelope.setCoordinateReferenceSystem(envelope.getCoordinateReferenceSystem());
                    if (LOGGER.isLoggable(Level.FINE) && !tempEnvelope.equals(envelope, scale * 0.001, true)) {
                        LOGGER.log(Level.FINE, "Unable to preserve the envelope for this GridGeometry, expected " + envelope + ", actual " + tempEnvelope);
                    }
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public GeneralGridGeometry(PixelInCell anchor, MathTransform gridToCRS, Envelope envelope) throws MismatchedDimensionException, IllegalArgumentException {
        this(anchor, gridToCRS, envelope, false, false);
    }

    public GeneralGridGeometry(GridEnvelope gridRange, Envelope userRange) throws MismatchedDimensionException {
        this(gridRange, userRange, null, false, true);
    }

    GeneralGridGeometry(GridEnvelope gridRange, Envelope userRange, boolean[] reverse, boolean swapXY, boolean automatic) throws MismatchedDimensionException {
        this.gridRange = GeneralGridGeometry.clone(gridRange);
        this.envelope = new GeneralEnvelope(userRange);
        GridToEnvelopeMapper mapper = new GridToEnvelopeMapper(gridRange, userRange);
        if (!automatic) {
            mapper.setReverseAxis(reverse);
            mapper.setSwapXY(swapXY);
        }
        this.gridToCRS = mapper.createTransform();
    }

    private static GridEnvelope clone(GridEnvelope gridRange) {
        if (gridRange instanceof Cloneable) {
            gridRange = (GridEnvelope)((Cloneable)gridRange).clone();
        }
        return gridRange;
    }

    public int getDimension() {
        if (this.gridToCRS != null) {
            return this.gridToCRS.getSourceDimensions();
        }
        return this.gridRange.getDimension();
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() throws InvalidGridGeometryException {
        CoordinateReferenceSystem crs;
        if (this.envelope != null && (crs = this.envelope.getCoordinateReferenceSystem()) != null) {
            assert (this.isDefined(1));
            return crs;
        }
        assert (!this.isDefined(1));
        throw new InvalidGridGeometryException(193);
    }

    public Envelope getEnvelope() throws InvalidGridGeometryException {
        if (this.envelope != null && !this.envelope.isNull()) {
            assert (this.isDefined(2));
            return this.envelope.clone();
        }
        assert (!this.isDefined(2));
        throw new InvalidGridGeometryException(this.gridToCRS == null ? 195 : 194);
    }

    public GridEnvelope getGridRange() throws InvalidGridGeometryException {
        if (this.gridRange != null) {
            assert (this.isDefined(4));
            return GeneralGridGeometry.clone(this.gridRange);
        }
        assert (!this.isDefined(4));
        throw new InvalidGridGeometryException(194);
    }

    public MathTransform getGridToCRS() throws InvalidGridGeometryException {
        if (this.gridToCRS != null) {
            assert (this.isDefined(8));
            return this.gridToCRS;
        }
        assert (!this.isDefined(8));
        throw new InvalidGridGeometryException(195);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MathTransform getGridToCRS(PixelInCell anchor) throws InvalidGridGeometryException {
        if (this.gridToCRS == null) {
            throw new InvalidGridGeometryException(195);
        }
        if (PixelInCell.CELL_CENTER.equals((Object)anchor)) {
            return this.gridToCRS;
        }
        if (PixelInCell.CELL_CORNER.equals((Object)anchor)) {
            GeneralGridGeometry generalGridGeometry = this;
            synchronized (generalGridGeometry) {
                if (this.cornerToCRS == null) {
                    this.cornerToCRS = PixelTranslation.translate(this.gridToCRS, PixelInCell.CELL_CENTER, anchor);
                }
            }
            assert (!this.cornerToCRS.equals(this.gridToCRS)) : this.cornerToCRS;
            return this.cornerToCRS;
        }
        return PixelTranslation.translate(this.gridToCRS, PixelInCell.CELL_CENTER, anchor);
    }

    public boolean isDefined(int bitmask) throws IllegalArgumentException {
        if ((bitmask & 0xFFFFFFF0) != 0) {
            throw new IllegalArgumentException(Errors.format((int)58, (Object)"bitmask", (Object)bitmask));
        }
        return !((bitmask & 1) != 0 && (this.envelope == null || this.envelope.getCoordinateReferenceSystem() == null) || (bitmask & 2) != 0 && (this.envelope == null || this.envelope.isNull()) || (bitmask & 4) != 0 && this.gridRange == null || (bitmask & 8) != 0 && this.gridToCRS == null);
    }

    public int hashCode() {
        int code = -1541009884;
        if (this.gridToCRS != null) {
            code += this.gridToCRS.hashCode();
        }
        if (this.gridRange != null) {
            code += this.gridRange.hashCode();
        }
        return code;
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass().equals(this.getClass())) {
            GeneralGridGeometry that = (GeneralGridGeometry)object;
            return Utilities.equals((Object)this.gridRange, (Object)that.gridRange) && Utilities.equals((Object)this.gridToCRS, (Object)that.gridToCRS) && Utilities.equals((Object)this.envelope, (Object)that.envelope);
        }
        return false;
    }

    public String toString() {
        return Classes.getShortClassName((Object)this) + '[' + this.gridRange + ", " + this.gridToCRS + ']';
    }

    static void ensureNonNull(String name, Object object) throws IllegalArgumentException {
        if (object == null) {
            throw new IllegalArgumentException(Errors.format((int)143, (Object)name));
        }
    }

    static {
        if (!$assertionsDisabled) {
            assertsEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
    }
}

