/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.visitor;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.util.logging.Logger;
import org.geotools.filter.visitor.NullFilterVisitor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.logging.Logging;
import org.opengis.filter.And;
import org.opengis.filter.ExcludeFilter;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.Id;
import org.opengis.filter.IncludeFilter;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsGreaterThanOrEqualTo;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.PropertyIsNil;
import org.opengis.filter.PropertyIsNotEqualTo;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.expression.Add;
import org.opengis.filter.expression.Divide;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.Multiply;
import org.opengis.filter.expression.NilExpression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.expression.Subtract;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;
import org.opengis.filter.temporal.After;
import org.opengis.filter.temporal.AnyInteracts;
import org.opengis.filter.temporal.Before;
import org.opengis.filter.temporal.Begins;
import org.opengis.filter.temporal.BegunBy;
import org.opengis.filter.temporal.During;
import org.opengis.filter.temporal.EndedBy;
import org.opengis.filter.temporal.Ends;
import org.opengis.filter.temporal.Meets;
import org.opengis.filter.temporal.MetBy;
import org.opengis.filter.temporal.OverlappedBy;
import org.opengis.filter.temporal.TContains;
import org.opengis.filter.temporal.TEquals;
import org.opengis.filter.temporal.TOverlaps;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ExtractBoundsFilterVisitor
extends NullFilterVisitor {
    public static NullFilterVisitor BOUNDS_VISITOR = new ExtractBoundsFilterVisitor();
    private static Logger LOGGER = Logging.getLogger((String)"org.geotools.index.rtree");

    protected ExtractBoundsFilterVisitor() {
    }

    private ReferencedEnvelope bbox(Object data) {
        if (data == null) {
            return null;
        }
        if (data instanceof ReferencedEnvelope) {
            return (ReferencedEnvelope)((Object)data);
        }
        if (data instanceof Envelope) {
            return new ReferencedEnvelope((Envelope)data, null);
        }
        if (data instanceof CoordinateReferenceSystem) {
            return new ReferencedEnvelope((CoordinateReferenceSystem)data);
        }
        throw new ClassCastException("Could not cast data to ReferencedEnvelope");
    }

    @Override
    public Object visit(ExcludeFilter filter, Object data) {
        return new Envelope();
    }

    @Override
    public Object visit(IncludeFilter filter, Object data) {
        return this.infinity();
    }

    Envelope infinity() {
        return new Envelope(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    @Override
    public Object visit(BBOX filter, Object data) {
        ReferencedEnvelope bbox = this.bbox(data);
        Envelope bounds = new Envelope(filter.getMinX(), filter.getMaxX(), filter.getMinY(), filter.getMaxY());
        if (bbox != null) {
            bbox.expandToInclude(bounds);
            return bbox;
        }
        return this.bbox(bounds);
    }

    @Override
    public Object visit(Literal expression, Object data) {
        ReferencedEnvelope bbox = this.bbox(data);
        Object value = expression.getValue();
        if (value instanceof Geometry) {
            Geometry geometry = (Geometry)value;
            Envelope bounds = geometry.getEnvelopeInternal();
            if (bbox != null) {
                bbox.expandToInclude(bounds);
                return bbox;
            }
            return this.bbox(bounds);
        }
        LOGGER.finer("LiteralExpression ignored!");
        return bbox;
    }

    @Override
    public Object visit(And filter, Object data) {
        Envelope mixed = this.infinity();
        for (Filter f : filter.getChildren()) {
            Envelope env = (Envelope)f.accept((FilterVisitor)this, data);
            mixed = mixed.intersection(env);
        }
        return mixed;
    }

    @Override
    public Object visit(Not filter, Object data) {
        return this.infinity();
    }

    @Override
    public Object visit(Or filter, Object data) {
        Envelope mixed = new Envelope();
        for (Filter f : filter.getChildren()) {
            Envelope env = (Envelope)f.accept((FilterVisitor)this, data);
            mixed.expandToInclude(env);
        }
        return mixed;
    }

    @Override
    public Object visit(Beyond filter, Object data) {
        return this.infinity();
    }

    @Override
    public Object visit(Contains filter, Object data) {
        data = filter.getExpression1().accept((ExpressionVisitor)this, data);
        data = filter.getExpression2().accept((ExpressionVisitor)this, data);
        return data;
    }

    @Override
    public Object visit(Crosses filter, Object data) {
        data = filter.getExpression1().accept((ExpressionVisitor)this, data);
        data = filter.getExpression2().accept((ExpressionVisitor)this, data);
        return data;
    }

    @Override
    public Object visit(Disjoint filter, Object data) {
        return this.infinity();
    }

    @Override
    public Object visit(DWithin filter, Object data) {
        ReferencedEnvelope bbox = this.bbox(data);
        Literal geometry = null;
        if (filter.getExpression1() instanceof PropertyName && filter.getExpression2() instanceof Literal) {
            geometry = (Literal)filter.getExpression2();
        }
        if (filter.getExpression2() instanceof PropertyName && filter.getExpression1() instanceof Literal) {
            geometry = (Literal)filter.getExpression2();
        }
        if (geometry == null) {
            return this.infinity();
        }
        Geometry geom = (Geometry)geometry.evaluate(null, Geometry.class);
        if (geom == null) {
            return this.infinity();
        }
        Envelope env = geom.getEnvelopeInternal();
        env.expandBy(filter.getDistance());
        if (bbox != null) {
            bbox.expandToInclude(env);
            return bbox;
        }
        return this.bbox(env);
    }

    @Override
    public Object visit(Equals filter, Object data) {
        data = filter.getExpression1().accept((ExpressionVisitor)this, data);
        data = filter.getExpression2().accept((ExpressionVisitor)this, data);
        return data;
    }

    @Override
    public Object visit(Intersects filter, Object data) {
        data = filter.getExpression1().accept((ExpressionVisitor)this, data);
        data = filter.getExpression2().accept((ExpressionVisitor)this, data);
        return data;
    }

    @Override
    public Object visit(Overlaps filter, Object data) {
        data = filter.getExpression1().accept((ExpressionVisitor)this, data);
        data = filter.getExpression2().accept((ExpressionVisitor)this, data);
        return data;
    }

    @Override
    public Object visit(Touches filter, Object data) {
        data = filter.getExpression1().accept((ExpressionVisitor)this, data);
        data = filter.getExpression2().accept((ExpressionVisitor)this, data);
        return data;
    }

    @Override
    public Object visit(Within filter, Object data) {
        data = filter.getExpression1().accept((ExpressionVisitor)this, data);
        data = filter.getExpression2().accept((ExpressionVisitor)this, data);
        return data;
    }

    @Override
    public Object visit(Add expression, Object data) {
        return this.infinity();
    }

    @Override
    public Object visit(Divide expression, Object data) {
        return this.infinity();
    }

    @Override
    public Object visit(Function expression, Object data) {
        return this.infinity();
    }

    @Override
    public Object visit(Id filter, Object data) {
        return this.infinity();
    }

    @Override
    public Object visit(Multiply expression, Object data) {
        return this.infinity();
    }

    @Override
    public Object visit(NilExpression expression, Object data) {
        return this.infinity();
    }

    @Override
    public Object visit(PropertyIsBetween filter, Object data) {
        return this.infinity();
    }

    @Override
    public Object visit(PropertyIsEqualTo filter, Object data) {
        return this.infinity();
    }

    @Override
    public Object visit(PropertyIsGreaterThan filter, Object data) {
        return this.infinity();
    }

    @Override
    public Object visit(PropertyIsGreaterThanOrEqualTo filter, Object data) {
        return this.infinity();
    }

    @Override
    public Object visit(PropertyIsLessThan filter, Object data) {
        return this.infinity();
    }

    @Override
    public Object visit(PropertyIsLessThanOrEqualTo filter, Object data) {
        return this.infinity();
    }

    @Override
    public Object visit(PropertyIsLike filter, Object data) {
        return this.infinity();
    }

    @Override
    public Object visit(PropertyIsNotEqualTo filter, Object data) {
        return this.infinity();
    }

    @Override
    public Object visit(PropertyIsNull filter, Object data) {
        return this.infinity();
    }

    @Override
    public Object visit(PropertyName expression, Object data) {
        return null;
    }

    @Override
    public Object visit(Subtract expression, Object data) {
        return this.infinity();
    }

    @Override
    public Object visitNullFilter(Object data) {
        return this.infinity();
    }

    @Override
    public Object visit(After after, Object data) {
        return this.infinity();
    }

    @Override
    public Object visit(AnyInteracts anyInteracts, Object data) {
        return this.infinity();
    }

    @Override
    public Object visit(Before before, Object data) {
        return this.infinity();
    }

    @Override
    public Object visit(Begins begins, Object data) {
        return this.infinity();
    }

    @Override
    public Object visit(BegunBy begunBy, Object data) {
        return this.infinity();
    }

    @Override
    public Object visit(During filter, Object data) {
        return this.infinity();
    }

    @Override
    public Object visit(EndedBy endedBy, Object data) {
        return this.infinity();
    }

    @Override
    public Object visit(Ends ends, Object data) {
        return this.infinity();
    }

    @Override
    public Object visit(Meets meets, Object data) {
        return this.infinity();
    }

    @Override
    public Object visit(MetBy metBy, Object data) {
        return this.infinity();
    }

    @Override
    public Object visit(OverlappedBy overlappedBy, Object data) {
        return this.infinity();
    }

    @Override
    public Object visit(TContains contains, Object data) {
        return this.infinity();
    }

    @Override
    public Object visit(TEquals equals, Object data) {
        return this.infinity();
    }

    @Override
    public Object visit(TOverlaps contains, Object data) {
        return this.infinity();
    }

    @Override
    public Object visit(PropertyIsNil filter, Object data) {
        return this.infinity();
    }
}

