/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import java.util.Collection;
import java.util.Iterator;
import org.geotools.feature.ComplexAttributeImpl;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.Feature;
import org.opengis.feature.GeometryAttribute;
import org.opengis.feature.Property;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.GeometryType;
import org.opengis.filter.identity.FeatureId;
import org.opengis.filter.identity.Identifier;
import org.opengis.geometry.BoundingBox;

public class FeatureImpl
extends ComplexAttributeImpl
implements Feature {
    GeometryAttribute defaultGeometry;

    public FeatureImpl(Collection<Property> properties, AttributeDescriptor desc, FeatureId id) {
        super(properties, desc, (Identifier)id);
    }

    public FeatureImpl(Collection<Property> properties, FeatureType type, FeatureId id) {
        super(properties, type, (Identifier)id);
    }

    @Override
    public FeatureType getType() {
        return (FeatureType)super.getType();
    }

    @Override
    public FeatureId getIdentifier() {
        return (FeatureId)this.id;
    }

    @Override
    public BoundingBox getBounds() {
        ReferencedEnvelope bounds = new ReferencedEnvelope(this.getType().getCoordinateReferenceSystem());
        Iterator itr = this.getValue().iterator();
        while (itr.hasNext()) {
            Property property = (Property)itr.next();
            if (!(property instanceof GeometryAttribute)) continue;
            bounds.include(((GeometryAttribute)property).getBounds());
        }
        return bounds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GeometryAttribute getDefaultGeometryProperty() {
        if (this.defaultGeometry != null) {
            return this.defaultGeometry;
        }
        FeatureImpl featureImpl = this;
        synchronized (featureImpl) {
            if (this.defaultGeometry == null) {
                if (this.getType().getGeometryDescriptor() == null) {
                    return null;
                }
                GeometryType geometryType = this.getType().getGeometryDescriptor().getType();
                if (geometryType != null) {
                    Iterator itr = this.getValue().iterator();
                    while (itr.hasNext()) {
                        Property property = (Property)itr.next();
                        if (!(property instanceof GeometryAttribute) || !property.getType().equals(geometryType)) continue;
                        this.defaultGeometry = (GeometryAttribute)property;
                        break;
                    }
                }
            }
        }
        return this.defaultGeometry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDefaultGeometryProperty(GeometryAttribute defaultGeometry) {
        if (!this.getValue().contains(defaultGeometry)) {
            throw new IllegalArgumentException("specified attribute is not one of: " + this.getValue());
        }
        FeatureImpl featureImpl = this;
        synchronized (featureImpl) {
            this.defaultGeometry = defaultGeometry;
        }
    }
}

