/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageioimpl.plugins.tiff;

import it.geosolutions.imageioimpl.plugins.tiff.TiffDatasetLayoutImpl;
import java.io.File;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TIFFStreamMetadata
extends IIOMetadata {
    static final String nativeMetadataFormatName = "com_sun_media_imageio_plugins_tiff_stream_1.0";
    static final String nativeMetadataFormatClassName = "it.geosolutions.imageioimpl.plugins.tiff.TIFFStreamMetadataFormat";
    public static final String EXTERNAL_MASK_FILE = "externalMaskFile";
    public static final String EXTERNAL_MASK_OVERVIEW_FILE = "externalMaskOverviewMaskFile";
    public static final String EXTERNAL_OVERVIEW_FILE = "externalOverviewFile";
    public static final String NUM_INTERNAL_OVERVIEWS = "numInternalOverviews";
    public static final String NUM_EXTERNAL_OVERVIEWS = "numExternalOverviews";
    public static final String NUM_EXTERNAL_MASK_OVERVIEWS = "numExternalMaskOverviews";
    public static final String NUM_EXTERNAL_MASKS = "numExternalMasks";
    public static final String NUM_INTERNAL_MASKS = "numInternalMasks";
    public static final String BYTE_ORDER = "ByteOrder";
    private static List<String> names = new ArrayList<String>();
    private static final String bigEndianString;
    private static final String littleEndianString;
    public ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
    public TiffDatasetLayoutImpl dtLayout = new TiffDatasetLayoutImpl();

    public TIFFStreamMetadata() {
        super(false, nativeMetadataFormatName, nativeMetadataFormatClassName, null, null);
    }

    public boolean isReadOnly() {
        return false;
    }

    private static void fatal(Node node, String reason) throws IIOInvalidTreeException {
        throw new IIOInvalidTreeException(reason, node);
    }

    public Node getAsTree(String formatName) {
        IIOMetadataNode root = new IIOMetadataNode(nativeMetadataFormatName);
        IIOMetadataNode byteOrderNode = new IIOMetadataNode(BYTE_ORDER);
        byteOrderNode.setAttribute("value", this.byteOrder.toString());
        root.appendChild(byteOrderNode);
        IIOMetadataNode numInternalMasksNode = new IIOMetadataNode(NUM_INTERNAL_MASKS);
        numInternalMasksNode.setAttribute("value", Integer.valueOf(this.dtLayout.getNumInternalMasks()).toString());
        IIOMetadataNode numExternalMasksNode = new IIOMetadataNode(NUM_EXTERNAL_MASKS);
        numExternalMasksNode.setAttribute("value", Integer.valueOf(this.dtLayout.getNumExternalMasks()).toString());
        IIOMetadataNode numInternalOverviewsNode = new IIOMetadataNode(NUM_INTERNAL_OVERVIEWS);
        numInternalOverviewsNode.setAttribute("value", Integer.valueOf(this.dtLayout.getNumInternalOverviews()).toString());
        IIOMetadataNode numExternalOverviewsNode = new IIOMetadataNode(NUM_EXTERNAL_OVERVIEWS);
        numExternalOverviewsNode.setAttribute("value", Integer.valueOf(this.dtLayout.getNumExternalOverviews()).toString());
        IIOMetadataNode numExternalMaskOverviewsNode = new IIOMetadataNode(NUM_EXTERNAL_MASK_OVERVIEWS);
        numExternalMaskOverviewsNode.setAttribute("value", Integer.valueOf(this.dtLayout.getNumExternalMaskOverviews()).toString());
        IIOMetadataNode externalMaskFileNode = new IIOMetadataNode(EXTERNAL_MASK_FILE);
        File file = this.dtLayout.getExternalMasks();
        externalMaskFileNode.setAttribute("value", file != null ? file.getAbsolutePath() : "");
        IIOMetadataNode externalOverviewFileNode = new IIOMetadataNode(EXTERNAL_OVERVIEW_FILE);
        file = this.dtLayout.getExternalOverviews();
        externalOverviewFileNode.setAttribute("value", file != null ? file.getAbsolutePath() : "");
        IIOMetadataNode externalMaskOverviewFileNode = new IIOMetadataNode(EXTERNAL_MASK_OVERVIEW_FILE);
        file = this.dtLayout.getExternalMaskOverviews();
        externalMaskOverviewFileNode.setAttribute("value", file != null ? file.getAbsolutePath() : "");
        root.appendChild(numInternalMasksNode);
        root.appendChild(numExternalMasksNode);
        root.appendChild(numInternalOverviewsNode);
        root.appendChild(numExternalOverviewsNode);
        root.appendChild(numExternalMaskOverviewsNode);
        root.appendChild(externalMaskFileNode);
        root.appendChild(externalOverviewFileNode);
        root.appendChild(externalMaskOverviewFileNode);
        return root;
    }

    private void mergeNativeTree(Node root) throws IIOInvalidTreeException {
        Node node = root;
        if (!node.getNodeName().equals(nativeMetadataFormatName)) {
            TIFFStreamMetadata.fatal(node, "Root must be com_sun_media_imageio_plugins_tiff_stream_1.0");
        }
        if (node.hasChildNodes()) {
            NodeList childNodes = root.getChildNodes();
            int size = names.size();
            for (int i = 0; i < size; ++i) {
                Node child = childNodes.item(i);
                String message = this.checkChild(child);
                if (message != null && !message.isEmpty()) {
                    TIFFStreamMetadata.fatal(child, message);
                    continue;
                }
                String nodeName = child.getNodeName();
                NamedNodeMap attrs = child.getAttributes();
                String value = attrs.getNamedItem("value").getNodeValue();
                MetadataNode metadataNode = MetadataNode.getFromName(nodeName);
                if (metadataNode == null) {
                    TIFFStreamMetadata.fatal(child, "Undefined Node");
                    continue;
                }
                String exception = metadataNode.handleMetadata(this, value);
                if (exception == null || exception.isEmpty()) continue;
                TIFFStreamMetadata.fatal(child, exception);
            }
        } else {
            TIFFStreamMetadata.fatal(node, "Root must have childs");
        }
    }

    private String checkChild(Node child) {
        if (child == null) {
            return "Root cannot have null child";
        }
        String nodeName = child.getNodeName();
        if (names.contains(nodeName)) {
            NamedNodeMap attrs = child.getAttributes();
            String value = attrs.getNamedItem("value").getNodeValue();
            if (value == null) {
                return nodeName + " node must have a \"value\" attribute";
            }
        } else {
            return "Root cannot have \"" + nodeName + "\" child";
        }
        return null;
    }

    public void mergeTree(String formatName, Node root) throws IIOInvalidTreeException {
        if (formatName.equals(nativeMetadataFormatName)) {
            if (root == null) {
                throw new IllegalArgumentException("root == null!");
            }
        } else {
            throw new IllegalArgumentException("Not a recognized format!");
        }
        this.mergeNativeTree(root);
    }

    public void reset() {
        this.byteOrder = ByteOrder.BIG_ENDIAN;
        this.dtLayout = new TiffDatasetLayoutImpl();
    }

    static {
        names.add(BYTE_ORDER);
        names.add(NUM_INTERNAL_MASKS);
        names.add(NUM_EXTERNAL_MASKS);
        names.add(NUM_INTERNAL_OVERVIEWS);
        names.add(NUM_EXTERNAL_OVERVIEWS);
        names.add(NUM_EXTERNAL_MASK_OVERVIEWS);
        names.add(EXTERNAL_MASK_FILE);
        names.add(EXTERNAL_OVERVIEW_FILE);
        names.add(EXTERNAL_MASK_OVERVIEW_FILE);
        bigEndianString = ByteOrder.BIG_ENDIAN.toString();
        littleEndianString = ByteOrder.LITTLE_ENDIAN.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MetadataNode {
        B_ORDER("ByteOrder"){

            public String handleMetadata(TIFFStreamMetadata metadata, String value) {
                if (value.equals(bigEndianString)) {
                    metadata.byteOrder = ByteOrder.BIG_ENDIAN;
                } else if (value.equals(littleEndianString)) {
                    metadata.byteOrder = ByteOrder.LITTLE_ENDIAN;
                } else {
                    return "Incorrect value for ByteOrder \"value\" attribute";
                }
                return null;
            }
        }
        ,
        N_INT_MASK("numInternalMasks"){

            public String handleMetadata(TIFFStreamMetadata metadata, String value) {
                try {
                    int num = Integer.parseInt(value);
                    metadata.dtLayout.setNumInternalMasks(num);
                }
                catch (Exception e) {
                    return e.getMessage();
                }
                return null;
            }
        }
        ,
        N_EXT_MASK("numExternalMasks"){

            public String handleMetadata(TIFFStreamMetadata metadata, String value) {
                try {
                    int num = Integer.parseInt(value);
                    metadata.dtLayout.setNumExternalMasks(num);
                }
                catch (Exception e) {
                    return e.getMessage();
                }
                return null;
            }
        }
        ,
        N_INT_OVR("numInternalOverviews"){

            public String handleMetadata(TIFFStreamMetadata metadata, String value) {
                try {
                    int num = Integer.parseInt(value);
                    metadata.dtLayout.setNumInternalOverviews(num);
                }
                catch (Exception e) {
                    return e.getMessage();
                }
                return null;
            }
        }
        ,
        N_EXT_OVR("numExternalOverviews"){

            public String handleMetadata(TIFFStreamMetadata metadata, String value) {
                try {
                    int num = Integer.parseInt(value);
                    metadata.dtLayout.setNumExternalOverviews(num);
                }
                catch (Exception e) {
                    return e.getMessage();
                }
                return null;
            }
        }
        ,
        N_EXT_OVR_MASK("numExternalMaskOverviews"){

            public String handleMetadata(TIFFStreamMetadata metadata, String value) {
                try {
                    int num = Integer.parseInt(value);
                    metadata.dtLayout.setNumExternalMaskOverviews(num);
                }
                catch (Exception e) {
                    return e.getMessage();
                }
                return null;
            }
        }
        ,
        EXT_MASK_FILE("externalMaskFile"){

            public String handleMetadata(TIFFStreamMetadata metadata, String value) {
                metadata.dtLayout.setExternalMasks(value != null && !value.isEmpty() ? new File(value) : null);
                return null;
            }
        }
        ,
        EXT_OVR_FILE("externalOverviewFile"){

            public String handleMetadata(TIFFStreamMetadata metadata, String value) {
                metadata.dtLayout.setExternalMaskOverviews(value != null && !value.isEmpty() ? new File(value) : null);
                return null;
            }
        }
        ,
        EXT_OVR_MASK_FILE("externalMaskOverviewMaskFile"){

            public String handleMetadata(TIFFStreamMetadata metadata, String value) {
                metadata.dtLayout.setExternalOverviews(value != null && !value.isEmpty() ? new File(value) : null);
                return null;
            }
        };

        private String name;

        private MetadataNode(String name) {
            this.setName(name);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public abstract String handleMetadata(TIFFStreamMetadata var1, String var2);

        public static MetadataNode getFromName(String name) {
            for (MetadataNode node : MetadataNode.values()) {
                if (!node.getName().equalsIgnoreCase(name)) continue;
                return node;
            }
            return null;
        }
    }
}

