/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Transaction;
import org.geotools.data.shapefile.RemappingFeatureCollection;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.shapefile.ShapefileSizeException;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;

public class ShapefileDumper {
    static final Logger LOGGER = Logging.getLogger(ShapefileDumper.class);
    File targetDirectory;
    long maxShpSize = Integer.MAX_VALUE;
    long maxDbfSize = Integer.MAX_VALUE;
    boolean emptyShapefileAllowed = true;
    Charset charset = (Charset)ShapefileDataStoreFactory.DBFCHARSET.getDefaultValue();

    public ShapefileDumper(File targetDirectory) {
        this.targetDirectory = targetDirectory;
    }

    public long getMaxShpSize() {
        return this.maxShpSize;
    }

    public void setMaxShpSize(long maxShapeSize) {
        this.maxShpSize = maxShapeSize;
    }

    public long getMaxDbfSize() {
        return this.maxDbfSize;
    }

    public void setMaxDbfSize(long maxDbfSize) {
        this.maxDbfSize = maxDbfSize;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public boolean isEmptyShapefileAllowed() {
        return this.emptyShapefileAllowed;
    }

    public void setEmptyShapefileAllowed(boolean emptyShapefileAllowed) {
        this.emptyShapefileAllowed = emptyShapefileAllowed;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean dump(SimpleFeatureCollection fc) throws IOException {
        block33: {
            block32: {
                if (((SimpleFeatureType)fc.getSchema()).getGeometryDescriptor() == null) {
                    throw new DataSourceException("Cannot write geometryless shapefiles, yet " + fc.getSchema() + " has no geometry field");
                }
                fc = RemappingFeatureCollection.getShapefileCompatibleCollection(fc);
                schema = (SimpleFeatureType)fc.getSchema();
                writers = new HashMap<Class, StoreWriter>();
                featuresWritten = false;
                geomType = schema.getGeometryDescriptor().getType().getBinding();
                multiWriter = GeometryCollection.class.equals((Object)geomType) != false || Geometry.class.equals((Object)geomType) != false;
                try {
                    it = fc.features();
                    var8_10 = null;
                    ** try [egrp 1[TRYBLOCK] [2, 3 : 136->278)] { 
lbl13:
                    // 1 sources

                    break block32;
lbl14:
                    // 1 sources

                    catch (Throwable f) {
                        var8_10 = f;
                        throw f;
                    }
                }
                catch (ShapefileSizeException e) {
                    try {
                        throw e;
                        catch (IOException ioe) {
                            ShapefileDumper.LOGGER.log(Level.WARNING, "Error while writing featuretype '" + schema.getTypeName() + "' to shapefile.", ioe);
                            throw new IOException(ioe);
                        }
                    }
                    catch (Throwable var14_19) {
                        stored = null;
                        for (StoreWriter sw : writers.values()) {
                            try {
                                writerSchema = sw.dstore.getSchema();
                                sw.writer.close();
                                sw.dstore.dispose();
                                this.shapefileDumped(writerSchema.getTypeName(), writerSchema);
                            }
                            catch (IOException e) {
                                stored = e;
                            }
                        }
                        if (stored != null) {
                            throw new IOException(stored);
                        }
                        throw var14_19;
                    }
                }
            }
            while (it.hasNext()) {
                f = (SimpleFeature)it.next();
                if (f.getDefaultGeometry() == null) continue;
                storeWriter = this.getStoreWriter(f, writers, multiWriter);
                try {
                    this.writeToShapefile(f, storeWriter.writer);
                }
                catch (ShapefileSizeException e) {
                    storeWriter.nextWriter();
                    this.writeToShapefile(f, storeWriter.writer);
                }
                featuresWritten = true;
            }
            if (!featuresWritten && this.emptyShapefileAllowed) {
                if (multiWriter) {
                    this.getStoreWriter((SimpleFeatureType)fc.getSchema(), writers, true, Point.class, null);
                    break block33;
                } else {
                    this.getStoreWriter((SimpleFeatureType)fc.getSchema(), writers, false, geomType, null);
                }
            }
            break block33;
lbl60:
            // 1 sources

            finally {
                if (it != null) {
                    if (var8_10 != null) {
                        try {
                            it.close();
                        }
                        catch (Throwable f) {
                            var8_10.addSuppressed(f);
                        }
                    } else {
                        it.close();
                    }
                }
            }
        }
        stored = null;
        for (StoreWriter sw : writers.values()) {
            try {
                writerSchema = sw.dstore.getSchema();
                sw.writer.close();
                sw.dstore.dispose();
                this.shapefileDumped(writerSchema.getTypeName(), writerSchema);
            }
            catch (IOException e) {
                stored = e;
            }
        }
        if (stored != null) {
            throw new IOException(stored);
        }
        return featuresWritten;
    }

    private void writeToShapefile(SimpleFeature f, FeatureWriter<SimpleFeatureType, SimpleFeature> writer) throws IOException {
        SimpleFeature fw = writer.next();
        for (AttributeDescriptor d : fw.getFeatureType().getAttributeDescriptors()) {
            fw.setAttribute(d.getLocalName(), f.getAttribute(d.getLocalName()));
        }
        fw.setDefaultGeometry(f.getDefaultGeometry());
        writer.write();
    }

    protected void shapefileDumped(String fileName, SimpleFeatureType remappedSchema) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ShapefileDataStore buildStore(SimpleFeatureType schema) throws MalformedURLException, FileNotFoundException, IOException {
        File file = new File(this.targetDirectory, schema.getTypeName() + ".shp");
        ShapefileDataStore sfds = new ShapefileDataStore(DataUtilities.fileToURL(file));
        sfds.setCharset(this.charset);
        File charsetFile = new File(this.targetDirectory, schema.getTypeName() + ".cst");
        try (PrintWriter pw = null;){
            pw = new PrintWriter(charsetFile);
            pw.write(this.charset.name());
        }
        try {
            sfds.createSchema(schema);
        }
        catch (NullPointerException e) {
            LOGGER.warning("Error in shapefile schema. It is possible you don't have a geometry set in the output. \nPlease specify a <wfs:PropertyName>geom_column_name</wfs:PropertyName> in the request");
            throw new IOException("Error in shapefile schema. It is possible you don't have a geometry set in the output.");
        }
        try {
            if (schema.getCoordinateReferenceSystem() != null) {
                sfds.forceSchemaCRS(schema.getCoordinateReferenceSystem());
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not properly create the .prj file", e);
        }
        sfds.setMaxShpSize(this.maxShpSize);
        sfds.setMaxDbfSize(this.maxDbfSize);
        return sfds;
    }

    private Map<String, Object> getGeometryType(SimpleFeature f) {
        Class<Point> target;
        String geometryType = null;
        Geometry g = (Geometry)f.getDefaultGeometry();
        if (g instanceof Point) {
            target = Point.class;
            geometryType = "Point";
        } else if (g instanceof MultiPoint) {
            target = MultiPoint.class;
            geometryType = "MPoint";
        } else if (g instanceof MultiPolygon || g instanceof Polygon) {
            target = MultiPolygon.class;
            geometryType = "Polygon";
        } else if (g instanceof LineString || g instanceof MultiLineString) {
            target = MultiLineString.class;
            geometryType = "Line";
        } else {
            throw new RuntimeException("This should never happen, there's a bug in the SHAPE-ZIP output format. I got a geometry of type " + g.getClass());
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("target", target);
        map.put("geometryType", geometryType);
        return map;
    }

    private StoreWriter getStoreWriter(SimpleFeature f, Map<Class, StoreWriter> writers, boolean multiWriter) throws IOException {
        Class target = null;
        String geometryType = null;
        if (multiWriter) {
            Map<String, Object> map = this.getGeometryType(f);
            target = (Class)map.get("target");
            geometryType = (String)map.get("geometryType");
        } else {
            target = Geometry.class;
            geometryType = "Geometry";
        }
        return this.getStoreWriter(f.getFeatureType(), writers, multiWriter, target, geometryType);
    }

    private StoreWriter getStoreWriter(SimpleFeatureType original, Map<Class, StoreWriter> writers, boolean multiWriter, Class<?> target, String geometryType) throws MalformedURLException, FileNotFoundException, IOException {
        StoreWriter storeWriter = writers.get(target);
        if (storeWriter == null) {
            SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
            for (AttributeDescriptor d : original.getAttributeDescriptors()) {
                if (Geometry.class.isAssignableFrom(d.getType().getBinding()) && multiWriter) {
                    GeometryDescriptor gd = (GeometryDescriptor)d;
                    builder.add(gd.getLocalName(), target, gd.getCoordinateReferenceSystem());
                    builder.setDefaultGeometry(gd.getLocalName());
                    continue;
                }
                builder.add(d);
            }
            builder.setNamespaceURI(original.getName().getURI());
            String fileName = multiWriter ? this.getShapeName(original, geometryType) : this.getShapeName(original, null);
            builder.setName(fileName);
            SimpleFeatureType retyped = builder.buildFeatureType();
            storeWriter = new StoreWriter(retyped);
            writers.put(target, storeWriter);
        }
        return storeWriter;
    }

    protected String getShapeName(SimpleFeatureType schema, String geometryType) {
        if (geometryType == null) {
            return schema.getTypeName();
        }
        return schema.getTypeName() + geometryType;
    }

    private class StoreWriter {
        int currentFileId = 0;
        ShapefileDataStore dstore;
        FeatureWriter<SimpleFeatureType, SimpleFeature> writer;
        SimpleFeatureType schema;

        public StoreWriter(SimpleFeatureType schema) throws MalformedURLException, FileNotFoundException, IOException {
            this.schema = schema;
            this.createStoreAndWriter(schema);
        }

        private void createStoreAndWriter(SimpleFeatureType schema) throws MalformedURLException, FileNotFoundException, IOException {
            this.dstore = ShapefileDumper.this.buildStore(schema);
            this.writer = this.dstore.getFeatureWriter(schema.getTypeName(), Transaction.AUTO_COMMIT);
        }

        public void nextWriter() throws IOException {
            this.writer.close();
            this.dstore.dispose();
            ++this.currentFileId;
            SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
            tb.init(this.schema);
            tb.setName(this.schema.getTypeName() + String.valueOf(this.currentFileId));
            SimpleFeatureType ft = tb.buildFeatureType();
            this.createStoreAndWriter(ft);
        }
    }
}

