/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.gui.io.DownloadPrimitivesWithReferrersTask;
import org.openstreetmap.josm.plugins.pt_assistant.utils.RouteUtils;

public class IncompleteMembersDownloadThread
extends Thread {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            IncompleteMembersDownloadThread incompleteMembersDownloadThread = this;
            synchronized (incompleteMembersDownloadThread) {
                ArrayList<Object> list = new ArrayList<Object>();
                for (Relation currentSelectedRelation : Main.getLayerManager().getEditDataSet().getSelectedRelations()) {
                    if (!RouteUtils.isTwoDirectionRoute(currentSelectedRelation)) continue;
                    list.add(currentSelectedRelation);
                }
                if (list.isEmpty()) {
                    Collection allRelations = Main.getLayerManager().getEditDataSet().getRelations();
                    for (Relation currentRelation : allRelations) {
                        if (!RouteUtils.isTwoDirectionRoute(currentRelation)) continue;
                        list.add(currentRelation);
                    }
                }
                Collection allNodes = Main.getLayerManager().getEditDataSet().getNodes();
                for (Node currentNode : allNodes) {
                    if (!currentNode.hasTag("public_transport", "stop_position")) continue;
                    List referrers = currentNode.getReferrers();
                    boolean parentWayExists = false;
                    for (OsmPrimitive referrer : referrers) {
                        if (!referrer.getType().equals((Object)OsmPrimitiveType.WAY)) continue;
                        parentWayExists = true;
                        break;
                    }
                    if (parentWayExists) continue;
                    list.add(currentNode);
                }
                DownloadPrimitivesWithReferrersTask task = new DownloadPrimitivesWithReferrersTask(false, list, false, true, null, null);
                Thread t = new Thread((Runnable)task);
                t.start();
                t.join();
            }
        }
        catch (InterruptedException e) {
            Main.trace((Throwable)e);
        }
    }
}

