/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.validation;

import java.io.File;
import org.junit.Assert;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.plugins.pt_assistant.AbstractTest;
import org.openstreetmap.josm.plugins.pt_assistant.ImportUtils;
import org.openstreetmap.josm.plugins.pt_assistant.validation.NodeChecker;
import org.openstreetmap.josm.plugins.pt_assistant.validation.PTAssistantValidatorTest;

public class SolitaryStopPositionTest
extends AbstractTest {
    @org.junit.Test
    public void test1() {
        File file = new File("test/data/solitary-stop-position.osm");
        DataSet ds = ImportUtils.importOsmFile(file, "testLayer");
        PTAssistantValidatorTest test = new PTAssistantValidatorTest();
        Node platform = null;
        Node stopPosition = null;
        for (Node n : ds.getNodes()) {
            if (n.hasTag("public_transport", "stop_position")) {
                stopPosition = n;
            }
            if (!n.hasTag("public_transport", "platform")) continue;
            platform = n;
        }
        NodeChecker checkerPlatform = new NodeChecker(platform, (Test)test);
        checkerPlatform.performPlatformPartOfWayTest();
        Assert.assertEquals((long)checkerPlatform.getErrors().size(), (long)1L);
        Assert.assertEquals((long)checkerPlatform.getErrors().get(0).getCode(), (long)3752L);
        NodeChecker checkerStopPosition = new NodeChecker(stopPosition, (Test)test);
        checkerStopPosition.performSolitaryStopPositionTest();
        Assert.assertEquals((long)checkerStopPosition.getErrors().size(), (long)1L);
        Assert.assertEquals((long)checkerStopPosition.getErrors().get(0).getCode(), (long)3751L);
    }
}

