/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.validation;

import java.io.File;
import java.util.ArrayList;
import org.junit.Assert;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.plugins.pt_assistant.AbstractTest;
import org.openstreetmap.josm.plugins.pt_assistant.ImportUtils;
import org.openstreetmap.josm.plugins.pt_assistant.validation.PTAssistantValidatorTest;
import org.openstreetmap.josm.plugins.pt_assistant.validation.RouteChecker;

public class SortingTestTest
extends AbstractTest {
    @org.junit.Test
    public void sortingTestBeforeFile() {
        File file = new File("test/data/DL131_before.osm");
        DataSet ds = ImportUtils.importOsmFile(file, "testLayer");
        PTAssistantValidatorTest test = new PTAssistantValidatorTest();
        ArrayList<TestError> errors = new ArrayList<TestError>();
        for (Relation r : ds.getRelations()) {
            RouteChecker routeChecker = new RouteChecker(r, (Test)test);
            routeChecker.performSortingTest();
            errors.addAll(routeChecker.getErrors());
        }
        Assert.assertEquals((long)errors.size(), (long)1L);
        Assert.assertEquals((long)((TestError)errors.iterator().next()).getCode(), (long)3711L);
        Assert.assertEquals((Object)((TestError)errors.iterator().next()).getTester().getClass().getName(), (Object)PTAssistantValidatorTest.class.getName());
    }

    @org.junit.Test
    public void sortingTestAfterFile() {
        File file = new File("test/data/DL131_after.osm");
        DataSet ds = ImportUtils.importOsmFile(file, "testLayer");
        PTAssistantValidatorTest test = new PTAssistantValidatorTest();
        ArrayList<TestError> errors = new ArrayList<TestError>();
        for (Relation r : ds.getRelations()) {
            RouteChecker routeChecker = new RouteChecker(r, (Test)test);
            routeChecker.performSortingTest();
            errors.addAll(routeChecker.getErrors());
        }
        Assert.assertEquals((long)errors.size(), (long)0L);
    }

    @org.junit.Test
    public void overshootTestAfterFile() {
        File file = new File("test/data/DL286_after.osm");
        DataSet ds = ImportUtils.importOsmFile(file, "testLayer");
        PTAssistantValidatorTest test = new PTAssistantValidatorTest();
        ArrayList<TestError> errors = new ArrayList<TestError>();
        for (Relation r : ds.getRelations()) {
            RouteChecker routeChecker = new RouteChecker(r, (Test)test);
            routeChecker.performSortingTest();
            errors.addAll(routeChecker.getErrors());
        }
        Assert.assertEquals((long)errors.size(), (long)0L);
    }
}

