/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.imports;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;

public class IllegalImportCheck
extends AbstractCheck {
    public static final String MSG_KEY = "import.illegal";
    private String[] illegalPkgs;

    public IllegalImportCheck() {
        this.setIllegalPkgs("sun");
    }

    public final void setIllegalPkgs(String ... from) {
        this.illegalPkgs = (String[])from.clone();
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{30, 152};
    }

    @Override
    public int[] getRequiredTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public void visitToken(DetailAST ast) {
        FullIdent imp = ast.getType() == 30 ? FullIdent.createFullIdentBelow(ast) : FullIdent.createFullIdent(ast.getFirstChild().getNextSibling());
        if (this.isIllegalImport(imp.getText())) {
            this.log(ast.getLineNo(), ast.getColumnNo(), MSG_KEY, imp.getText());
        }
    }

    private boolean isIllegalImport(String importText) {
        boolean isIllegal = false;
        for (String element : this.illegalPkgs) {
            if (!importText.startsWith(element + ".")) continue;
            isIllegal = true;
            break;
        }
        return isIllegal;
    }
}

