/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.api;

import com.google.common.collect.ImmutableCollection;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.Configurable;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import com.puppycrawl.tools.checkstyle.api.Context;
import com.puppycrawl.tools.checkstyle.api.Contextualizable;
import com.puppycrawl.tools.checkstyle.api.Scope;
import com.puppycrawl.tools.checkstyle.api.SeverityLevel;
import com.puppycrawl.tools.checkstyle.checks.naming.AccessModifier;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.beanutils.converters.ArrayConverter;
import org.apache.commons.beanutils.converters.BooleanConverter;
import org.apache.commons.beanutils.converters.ByteConverter;
import org.apache.commons.beanutils.converters.CharacterConverter;
import org.apache.commons.beanutils.converters.DoubleConverter;
import org.apache.commons.beanutils.converters.FloatConverter;
import org.apache.commons.beanutils.converters.IntegerConverter;
import org.apache.commons.beanutils.converters.LongConverter;
import org.apache.commons.beanutils.converters.ShortConverter;

public class AutomaticBean
implements Configurable,
Contextualizable {
    private static final String COMMA_SEPARATOR = ",";
    private Configuration configuration;

    private static BeanUtilsBean createBeanUtilsBean() {
        ConvertUtilsBean cub = new ConvertUtilsBean();
        AutomaticBean.registerIntegralTypes(cub);
        AutomaticBean.registerCustomTypes(cub);
        return new BeanUtilsBean(cub, new PropertyUtilsBean());
    }

    private static void registerIntegralTypes(ConvertUtilsBean cub) {
        cub.register(new BooleanConverter(), Boolean.TYPE);
        cub.register(new BooleanConverter(), Boolean.class);
        cub.register(new ArrayConverter(boolean[].class, new BooleanConverter()), boolean[].class);
        cub.register(new ByteConverter(), Byte.TYPE);
        cub.register(new ByteConverter(), Byte.class);
        cub.register(new ArrayConverter(byte[].class, new ByteConverter()), byte[].class);
        cub.register(new CharacterConverter(), Character.TYPE);
        cub.register(new CharacterConverter(), Character.class);
        cub.register(new ArrayConverter(char[].class, new CharacterConverter()), char[].class);
        cub.register(new DoubleConverter(), Double.TYPE);
        cub.register(new DoubleConverter(), Double.class);
        cub.register(new ArrayConverter(double[].class, new DoubleConverter()), double[].class);
        cub.register(new FloatConverter(), Float.TYPE);
        cub.register(new FloatConverter(), Float.class);
        cub.register(new ArrayConverter(float[].class, new FloatConverter()), float[].class);
        cub.register(new IntegerConverter(), Integer.TYPE);
        cub.register(new IntegerConverter(), Integer.class);
        cub.register(new ArrayConverter(int[].class, new IntegerConverter()), int[].class);
        cub.register(new LongConverter(), Long.TYPE);
        cub.register(new LongConverter(), Long.class);
        cub.register(new ArrayConverter(long[].class, new LongConverter()), long[].class);
        cub.register(new ShortConverter(), Short.TYPE);
        cub.register(new ShortConverter(), Short.class);
        cub.register(new ArrayConverter(short[].class, new ShortConverter()), short[].class);
        cub.register(new RelaxedStringArrayConverter(), String[].class);
    }

    private static void registerCustomTypes(ConvertUtilsBean cub) {
        cub.register(new PatternConverter(), Pattern.class);
        cub.register(new SeverityLevelConverter(), SeverityLevel.class);
        cub.register(new ScopeConverter(), Scope.class);
        cub.register(new UriConverter(), URI.class);
        cub.register(new RelaxedAccessModifierArrayConverter(), AccessModifier[].class);
    }

    @Override
    public final void configure(Configuration config) throws CheckstyleException {
        Configuration[] childConfigs;
        String[] attributes;
        this.configuration = config;
        for (String key : attributes = config.getAttributeNames()) {
            String value = config.getAttribute(key);
            this.tryCopyProperty(config.getName(), key, value, true);
        }
        this.finishLocalSetup();
        for (Configuration childConfig : childConfigs = config.getChildren()) {
            this.setupChild(childConfig);
        }
    }

    private void tryCopyProperty(String moduleName, String key, Object value, boolean recheck) throws CheckstyleException {
        BeanUtilsBean beanUtils = AutomaticBean.createBeanUtilsBean();
        try {
            PropertyDescriptor descriptor;
            if (recheck && (descriptor = PropertyUtils.getPropertyDescriptor(this, key)) == null) {
                String message = String.format(Locale.ROOT, "Property '%s' in module %s does not exist, please check the documentation", key, moduleName);
                throw new CheckstyleException(message);
            }
            beanUtils.copyProperty(this, key, value);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            String message = String.format(Locale.ROOT, "Cannot set property '%s' to '%s' in module %s", key, value, moduleName);
            throw new CheckstyleException(message, ex);
        }
        catch (IllegalArgumentException | ConversionException ex) {
            String message = String.format(Locale.ROOT, "illegal value '%s' for property '%s' of module %s", value, key, moduleName);
            throw new CheckstyleException(message, ex);
        }
    }

    @Override
    public final void contextualize(Context context) throws CheckstyleException {
        ImmutableCollection<String> attributes = context.getAttributeNames();
        for (String key : attributes) {
            Object value = context.get(key);
            this.tryCopyProperty(this.getClass().getName(), key, value, false);
        }
    }

    protected final Configuration getConfiguration() {
        return this.configuration;
    }

    protected void finishLocalSetup() throws CheckstyleException {
    }

    protected void setupChild(Configuration childConf) throws CheckstyleException {
        if (childConf != null) {
            throw new CheckstyleException(childConf.getName() + " is not allowed as a child in " + this.getConfiguration().getName() + ". Please review 'Parent Module' section for this Check in web documentation if Check is standard.");
        }
    }

    private static class RelaxedAccessModifierArrayConverter
    implements Converter {
        private RelaxedAccessModifierArrayConverter() {
        }

        public Object convert(Class type, Object value) {
            StringTokenizer tokenizer = new StringTokenizer(value.toString().trim(), AutomaticBean.COMMA_SEPARATOR);
            ArrayList<AccessModifier> result = new ArrayList<AccessModifier>();
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                result.add(AccessModifier.getInstance(token.trim()));
            }
            return result.toArray(new AccessModifier[result.size()]);
        }
    }

    private static class RelaxedStringArrayConverter
    implements Converter {
        private RelaxedStringArrayConverter() {
        }

        public Object convert(Class type, Object value) {
            StringTokenizer tokenizer = new StringTokenizer(value.toString().trim(), AutomaticBean.COMMA_SEPARATOR);
            ArrayList<String> result = new ArrayList<String>();
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                result.add(token.trim());
            }
            return result.toArray(new String[result.size()]);
        }
    }

    private static class UriConverter
    implements Converter {
        private UriConverter() {
        }

        public Object convert(Class type, Object value) {
            String url = value.toString();
            URI result = null;
            if (!CommonUtils.isBlank(url)) {
                try {
                    result = CommonUtils.getUriByFilename(url);
                }
                catch (CheckstyleException ex) {
                    throw new IllegalArgumentException(ex);
                }
            }
            return result;
        }
    }

    private static class ScopeConverter
    implements Converter {
        private ScopeConverter() {
        }

        public Object convert(Class type, Object value) {
            return Scope.getInstance(value.toString());
        }
    }

    private static class SeverityLevelConverter
    implements Converter {
        private SeverityLevelConverter() {
        }

        public Object convert(Class type, Object value) {
            return SeverityLevel.getInstance(value.toString());
        }
    }

    private static class PatternConverter
    implements Converter {
        private PatternConverter() {
        }

        public Object convert(Class type, Object value) {
            return CommonUtils.createPattern(value.toString());
        }
    }
}

