/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.google.common.base.CaseFormat;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.DetailNode;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocNodeImpl;
import com.puppycrawl.tools.checkstyle.grammars.javadoc.JavadocLexer;
import com.puppycrawl.tools.checkstyle.grammars.javadoc.JavadocParser;
import com.puppycrawl.tools.checkstyle.utils.JavadocUtils;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.BailErrorStrategy;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;

public class JavadocDetailNodeParser {
    public static final String MSG_JAVADOC_MISSED_HTML_CLOSE = "javadoc.missed.html.close";
    public static final String MSG_JAVADOC_WRONG_SINGLETON_TAG = "javadoc.wrong.singleton.html.tag";
    public static final String MSG_JAVADOC_PARSE_RULE_ERROR = "javadoc.parse.rule.error";
    public static final String MSG_KEY_PARSE_ERROR = "javadoc.parse.error";
    public static final String MSG_KEY_UNRECOGNIZED_ANTLR_ERROR = "javadoc.unrecognized.antlr.error";
    private static final String JAVADOC_START = "/**";
    private int blockCommentLineNumber;
    private DescriptiveErrorListener errorListener;

    public ParseStatus parseJavadocAsDetailNode(DetailAST javadocCommentAst) {
        this.blockCommentLineNumber = javadocCommentAst.getLineNo();
        String javadocComment = JavadocUtils.getJavadocCommentContent(javadocCommentAst);
        this.errorListener = new DescriptiveErrorListener();
        this.errorListener.setOffset(javadocCommentAst.getLineNo() - 1);
        ParseStatus result = new ParseStatus();
        try {
            ParseTree parseTree = this.parseJavadocAsParseTree(javadocComment);
            DetailNode tree = this.convertParseTreeToDetailNode(parseTree);
            this.adjustFirstLineToJavadocIndent(tree, javadocCommentAst.getColumnNo() + JAVADOC_START.length());
            result.setTree(tree);
        }
        catch (IllegalArgumentException | ParseCancellationException ex) {
            ParseErrorMessage parseErrorMessage = this.errorListener.getErrorMessage();
            if (parseErrorMessage == null) {
                parseErrorMessage = new ParseErrorMessage(javadocCommentAst.getLineNo(), MSG_KEY_UNRECOGNIZED_ANTLR_ERROR, javadocCommentAst.getColumnNo(), ex.getMessage());
            }
            result.setParseErrorMessage(parseErrorMessage);
        }
        return result;
    }

    private ParseTree parseJavadocAsParseTree(String blockComment) {
        ANTLRInputStream input = new ANTLRInputStream(blockComment);
        JavadocLexer lexer = new JavadocLexer(input);
        lexer.removeErrorListeners();
        lexer.addErrorListener(this.errorListener);
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        JavadocParser parser = new JavadocParser(tokens);
        parser.removeErrorListeners();
        parser.addErrorListener(this.errorListener);
        parser.setErrorHandler(new BailErrorStrategy());
        return parser.javadoc();
    }

    private DetailNode convertParseTreeToDetailNode(ParseTree parseTreeNode) {
        JavadocNodeImpl rootJavadocNode;
        JavadocNodeImpl currentJavadocParent = rootJavadocNode = this.createRootJavadocNode(parseTreeNode);
        ParseTree parseTreeParent = parseTreeNode;
        while (currentJavadocParent != null) {
            if (currentJavadocParent.getType() == 10074) {
                currentJavadocParent.setChildren(JavadocNodeImpl.EMPTY_DETAIL_NODE_ARRAY);
            }
            JavadocNodeImpl[] children = (JavadocNodeImpl[])currentJavadocParent.getChildren();
            this.insertChildrenNodes(children, parseTreeParent);
            if (children.length > 0) {
                currentJavadocParent = children[0];
                parseTreeParent = parseTreeParent.getChild(0);
                continue;
            }
            JavadocNodeImpl nextJavadocSibling = (JavadocNodeImpl)JavadocUtils.getNextSibling(currentJavadocParent);
            ParseTree nextParseTreeSibling = JavadocDetailNodeParser.getNextSibling(parseTreeParent);
            if (nextJavadocSibling == null) {
                JavadocNodeImpl tempJavadocParent = (JavadocNodeImpl)currentJavadocParent.getParent();
                ParseTree tempParseTreeParent = parseTreeParent.getParent();
                while (nextJavadocSibling == null && tempJavadocParent != null) {
                    nextJavadocSibling = (JavadocNodeImpl)JavadocUtils.getNextSibling(tempJavadocParent);
                    nextParseTreeSibling = JavadocDetailNodeParser.getNextSibling(tempParseTreeParent);
                    tempJavadocParent = (JavadocNodeImpl)tempJavadocParent.getParent();
                    tempParseTreeParent = tempParseTreeParent.getParent();
                }
            }
            currentJavadocParent = nextJavadocSibling;
            parseTreeParent = nextParseTreeSibling;
        }
        return rootJavadocNode;
    }

    private void insertChildrenNodes(JavadocNodeImpl[] nodes, ParseTree parseTreeParent) {
        for (int i = 0; i < nodes.length; ++i) {
            JavadocNodeImpl currentJavadocNode = nodes[i];
            ParseTree currentParseTreeNodeChild = parseTreeParent.getChild(i);
            JavadocNodeImpl[] subChildren = this.createChildrenNodes(currentJavadocNode, currentParseTreeNodeChild);
            currentJavadocNode.setChildren(subChildren);
        }
    }

    private JavadocNodeImpl[] createChildrenNodes(JavadocNodeImpl parentJavadocNode, ParseTree parseTreeNode) {
        JavadocNodeImpl[] children = new JavadocNodeImpl[parseTreeNode.getChildCount()];
        for (int j = 0; j < children.length; ++j) {
            JavadocNodeImpl child;
            children[j] = child = this.createJavadocNode(parseTreeNode.getChild(j), parentJavadocNode, j);
        }
        return children;
    }

    private JavadocNodeImpl createRootJavadocNode(ParseTree parseTreeNode) {
        JavadocNodeImpl rootJavadocNode = this.createJavadocNode(parseTreeNode, null, -1);
        int childCount = parseTreeNode.getChildCount();
        JavadocNodeImpl[] children = new JavadocNodeImpl[childCount];
        for (int i = 0; i < childCount; ++i) {
            JavadocNodeImpl child;
            children[i] = child = this.createJavadocNode(parseTreeNode.getChild(i), rootJavadocNode, i);
        }
        rootJavadocNode.setChildren(children);
        return rootJavadocNode;
    }

    private JavadocNodeImpl createJavadocNode(ParseTree parseTree, DetailNode parent, int index) {
        JavadocNodeImpl node = new JavadocNodeImpl();
        node.setText(parseTree.getText());
        node.setColumnNumber(JavadocDetailNodeParser.getColumn(parseTree));
        node.setLineNumber(JavadocDetailNodeParser.getLine(parseTree) + this.blockCommentLineNumber);
        node.setIndex(index);
        node.setType(JavadocDetailNodeParser.getTokenType(parseTree));
        node.setParent(parent);
        node.setChildren(new JavadocNodeImpl[parseTree.getChildCount()]);
        return node;
    }

    private void adjustFirstLineToJavadocIndent(DetailNode tree, int javadocColumnNumber) {
        if (tree.getLineNumber() == this.blockCommentLineNumber) {
            DetailNode[] children;
            ((JavadocNodeImpl)tree).setColumnNumber(tree.getColumnNumber() + javadocColumnNumber);
            for (DetailNode child : children = tree.getChildren()) {
                this.adjustFirstLineToJavadocIndent(child, javadocColumnNumber);
            }
        }
    }

    private static int getLine(ParseTree tree) {
        int line;
        if (tree instanceof TerminalNode) {
            line = ((TerminalNode)tree).getSymbol().getLine() - 1;
        } else {
            ParserRuleContext rule = (ParserRuleContext)tree;
            line = rule.start.getLine() - 1;
        }
        return line;
    }

    private static int getColumn(ParseTree tree) {
        int column;
        if (tree instanceof TerminalNode) {
            column = ((TerminalNode)tree).getSymbol().getCharPositionInLine();
        } else {
            ParserRuleContext rule = (ParserRuleContext)tree;
            column = rule.start.getCharPositionInLine();
        }
        return column;
    }

    private static ParseTree getNextSibling(ParseTree node) {
        ParseTree nextSibling = null;
        if (node.getParent() != null) {
            ParseTree parent = node.getParent();
            int childCount = parent.getChildCount();
            int index = 0;
            while (true) {
                ParseTree currentNode;
                if ((currentNode = parent.getChild(index)).equals(node)) {
                    if (index == childCount - 1) break;
                    nextSibling = parent.getChild(index + 1);
                    break;
                }
                ++index;
            }
        }
        return nextSibling;
    }

    private static int getTokenType(ParseTree node) {
        int tokenType;
        if (node.getChildCount() == 0) {
            tokenType = ((TerminalNode)node).getSymbol().getType();
        } else {
            String className = JavadocDetailNodeParser.getNodeClassNameWithoutContext(node);
            String typeName = CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, className);
            tokenType = JavadocUtils.getTokenId(typeName);
        }
        return tokenType;
    }

    private static String getNodeClassNameWithoutContext(ParseTree node) {
        String className = node.getClass().getSimpleName();
        int contextLength = 7;
        return className.substring(0, className.length() - 7);
    }

    public static class ParseErrorMessage {
        private final int lineNumber;
        private final String messageKey;
        private final Object[] messageArguments;

        ParseErrorMessage(int lineNumber, String messageKey, Object ... messageArguments) {
            this.lineNumber = lineNumber;
            this.messageKey = messageKey;
            this.messageArguments = (Object[])messageArguments.clone();
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public String getMessageKey() {
            return this.messageKey;
        }

        public Object[] getMessageArguments() {
            return (Object[])this.messageArguments.clone();
        }
    }

    public static class ParseStatus {
        private DetailNode tree;
        private ParseErrorMessage parseErrorMessage;

        public DetailNode getTree() {
            return this.tree;
        }

        public void setTree(DetailNode tree) {
            this.tree = tree;
        }

        public ParseErrorMessage getParseErrorMessage() {
            return this.parseErrorMessage;
        }

        public void setParseErrorMessage(ParseErrorMessage parseErrorMessage) {
            this.parseErrorMessage = parseErrorMessage;
        }
    }

    private static class DescriptiveErrorListener
    extends BaseErrorListener {
        private int offset;
        private ParseErrorMessage errorMessage;

        private DescriptiveErrorListener() {
        }

        private ParseErrorMessage getErrorMessage() {
            return this.errorMessage;
        }

        public void setOffset(int offset) {
            this.offset = offset;
        }

        @Override
        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException ex) {
            int lineNumber = this.offset + line;
            Token token = (Token)offendingSymbol;
            if (JavadocDetailNodeParser.MSG_JAVADOC_MISSED_HTML_CLOSE.equals(msg)) {
                this.errorMessage = new ParseErrorMessage(lineNumber, JavadocDetailNodeParser.MSG_JAVADOC_MISSED_HTML_CLOSE, charPositionInLine, token.getText());
                throw new IllegalArgumentException(msg);
            }
            if (JavadocDetailNodeParser.MSG_JAVADOC_WRONG_SINGLETON_TAG.equals(msg)) {
                this.errorMessage = new ParseErrorMessage(lineNumber, JavadocDetailNodeParser.MSG_JAVADOC_WRONG_SINGLETON_TAG, charPositionInLine, token.getText());
                throw new IllegalArgumentException(msg);
            }
            int ruleIndex = ex.getCtx().getRuleIndex();
            String ruleName = recognizer.getRuleNames()[ruleIndex];
            String upperCaseRuleName = CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, ruleName);
            this.errorMessage = new ParseErrorMessage(lineNumber, JavadocDetailNodeParser.MSG_JAVADOC_PARSE_RULE_ERROR, charPositionInLine, msg, upperCaseRuleName);
        }
    }
}

