/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.auto_tools.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JoinAreasAction;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.osm.TagCollection;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.mappaint.mapcss.ExpressionFactory;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class MergeBuildingsAction
extends JosmAction {
    public MergeBuildingsAction() {
        super(ExpressionFactory.Functions.tr((String[])new String[]{"Combine LA buildings"}), null, ExpressionFactory.Functions.tr((String[])new String[]{"Combine LA import buildings"}), Shortcut.registerShortcut((String)"AutoTools:CLAbuildings", (String)ExpressionFactory.Functions.tr((String[])new String[]{"AutoTools:CLAbuildings"}), (int)77, (int)5008), true);
    }

    public void actionPerformed(ActionEvent e) {
        if (Main.getLayerManager().getEditDataSet() != null) {
            Relation rela = null;
            LinkedList ways = new LinkedList(Main.getLayerManager().getEditDataSet().getSelectedWays());
            if (ways.isEmpty() || ways.size() == 1) {
                JOptionPane.showMessageDialog(null, "Select at least two ways");
            } else {
                Hashtable<String, String> atrributes = new Hashtable<String, String>();
                ArrayList<Double> areaList = new ArrayList<Double>();
                ArrayList<String> bvList = new ArrayList<String>();
                LinkedList<OsmPrimitive> sel = new LinkedList<OsmPrimitive>();
                for (Object osm : ways) {
                    if (OsmPrimitive.getFilteredList((Collection)osm.getReferrers(), Relation.class).size() > 0) {
                        Relation relation = (Relation)OsmPrimitive.getFilteredList((Collection)osm.getReferrers(), Relation.class).get(0);
                        Set keys = relation.getKeys().keySet();
                        Iterator iterator = keys.iterator();
                        while (iterator.hasNext()) {
                            String key = (String)iterator.next();
                            if (!atrributes.containsKey(key)) {
                                atrributes.put(key, relation.get(key));
                                continue;
                            }
                            if (((String)atrributes.get(key)).equals(relation.get(key))) continue;
                            String atrr = (String)atrributes.get(key) + ";" + relation.get(key);
                            atrributes.put(key, atrr);
                        }
                        areaList.add(this.findArea((Way)osm));
                        bvList.add(relation.get("building"));
                        rela = relation;
                        sel.add((OsmPrimitive)relation);
                        continue;
                    }
                    Set set = osm.getKeys().keySet();
                    for (String key : set) {
                        if (!atrributes.containsKey(key)) {
                            atrributes.put(key, osm.get(key));
                            continue;
                        }
                        if (((String)atrributes.get(key)).equals(osm.get(key))) continue;
                        String atrr = (String)atrributes.get(key) + ";" + osm.get(key);
                        atrributes.put(key, atrr);
                    }
                    areaList.add(this.findArea((Way)osm));
                    bvList.add(osm.get("building"));
                }
                atrributes.put("building", (String)bvList.get(areaList.indexOf(Collections.max(areaList))));
                TagCollection tagCollection = new TagCollection();
                for (Map.Entry entry : atrributes.entrySet()) {
                    Tag tag;
                    if ((((String)entry.getKey()).equals("start_date") || ((String)entry.getKey()).equals("building:units")) && ((String)entry.getValue()).contains(";")) {
                        tag = new Tag((String)entry.getKey(), null);
                    } else if ((((String)entry.getKey()).equals("height") || ((String)entry.getKey()).equals("ele")) && ((String)entry.getValue()).contains(";")) {
                        String[] stringArray = ((String)entry.getValue()).split(";");
                        Double max = Double.parseDouble(stringArray[0]);
                        for (int index = 1; index < stringArray.length; ++index) {
                            Double h = Double.parseDouble(stringArray[index]);
                            if (!(h > max)) continue;
                            max = h;
                        }
                        tag = new Tag((String)entry.getKey(), max.toString());
                    } else {
                        tag = new Tag((String)entry.getKey(), (String)entry.getValue());
                    }
                    tagCollection.add(tag);
                }
                sel.addAll(ways);
                Main.main.undoRedo.add((Command)new SequenceCommand(ExpressionFactory.Functions.tr((String[])new String[]{"revert tags"}), new Command[]{this.MergeAllTags(rela, sel, tagCollection)}));
                JoinAreasAction build = new JoinAreasAction();
                build.actionPerformed(e);
            }
        }
    }

    protected Command MergeAllTags(Relation relation, List<OsmPrimitive> selection, TagCollection tc) {
        String value;
        ArrayList<OsmPrimitive> selectiontemporal = new ArrayList<OsmPrimitive>();
        Set selectionways = OsmPrimitive.getFilteredSet(selection, Way.class);
        ArrayList<ChangePropertyCommand> commands = new ArrayList<ChangePropertyCommand>();
        if (relation != null) {
            System.out.println("entra...");
            for (OsmPrimitive op : selection) {
                if (!op.getType().equals((Object)OsmPrimitiveType.RELATION)) continue;
                selectiontemporal.add(op);
                selection.clear();
                selection = selectiontemporal;
            }
            for (String key : tc.getKeys()) {
                value = null;
                commands.add(new ChangePropertyCommand((Collection)selectionways, key, value));
            }
        }
        for (String key : tc.getKeys()) {
            value = (String)tc.getValues(key).iterator().next();
            value = value.equals("") ? null : value;
            commands.add(new ChangePropertyCommand(selection, key, value));
        }
        if (!commands.isEmpty()) {
            String title1 = I18n.trn((String)"Pasting {0} tag", (String)"Pasting {0} tags", (long)tc.getKeys().size(), (Object[])new Object[]{tc.getKeys().size()});
            String title2 = I18n.trn((String)"to {0} primitive", (String)"to {0} primitives", (long)selection.size(), (Object[])new Object[]{selection.size()});
            return new SequenceCommand(title1 + " " + title2, commands);
        }
        return null;
    }

    protected Double findArea(Way w) {
        double length = 0.0;
        Node lastN = null;
        double wayArea = 0.0;
        Double firstSegLength = null;
        boolean isCircle = true;
        for (Node n : w.getNodes()) {
            if (lastN != null && lastN.getCoor() != null && n.getCoor() != null) {
                double segLength = lastN.getCoor().greatCircleDistance(n.getCoor());
                if (firstSegLength == null) {
                    firstSegLength = segLength;
                }
                if (isCircle && Math.abs(firstSegLength - segLength) > 1.0E-6) {
                    isCircle = false;
                }
                length += segLength;
                wayArea += MergeBuildingsAction.calcX(n.getCoor()) * MergeBuildingsAction.calcY(lastN.getCoor()) - MergeBuildingsAction.calcY(n.getCoor()) * MergeBuildingsAction.calcX(lastN.getCoor());
            }
            lastN = n;
        }
        wayArea = lastN != null && lastN == w.getNodes().iterator().next() ? Math.abs(wayArea / 2.0) : 0.0;
        return wayArea;
    }

    public static double calcX(LatLon p1) {
        return p1.lat() * Math.PI * 6367000.0 / 180.0;
    }

    public static double calcY(LatLon p1) {
        return p1.lon() * 111125.11347447896 * Math.cos(p1.lat() * Math.PI / 180.0);
    }
}

