/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.rasterfilters;

import java.awt.Component;
import java.awt.Container;
import java.io.File;
import java.io.IOException;
import javax.swing.Action;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.layer.ImageProcessor;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.gui.layer.MainLayerManager;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.rasterfilters.actions.ShowFiltersDialogAction;
import org.openstreetmap.josm.plugins.rasterfilters.gui.FiltersDialog;
import org.openstreetmap.josm.plugins.rasterfilters.preferences.FiltersDownloader;
import org.openstreetmap.josm.plugins.rasterfilters.preferences.RasterFiltersPreferences;

public class RasterFiltersPlugin
extends Plugin
implements LayerManager.LayerChangeListener,
MainLayerManager.ActiveLayerChangeListener {
    private SideButton filterButton;
    private ShowFiltersDialogAction action;
    private PreferenceSetting setting;

    public RasterFiltersPlugin(PluginInformation info) {
        super(info);
        Main.debug((String)"Loading RasterFiltersPlugin");
        File file = new File(this.getPluginDir());
        if (file.mkdir() && !(file = new File(file.getAbsoluteFile(), "urls.map")).exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                Main.debug((String)("Cannot create file" + file.getAbsolutePath() + "\n" + e.getMessage()));
            }
        }
        FiltersDownloader.setPluginDir(this.getPluginDir());
    }

    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        if (Main.isDisplayingMapView()) {
            Main.getLayerManager().addLayerChangeListener((LayerManager.LayerChangeListener)this);
            Main.getLayerManager().addActiveLayerChangeListener((MainLayerManager.ActiveLayerChangeListener)this);
        }
    }

    public void activeOrEditLayerChanged(MainLayerManager.ActiveLayerChangeEvent e) {
        if (!(Main.getLayerManager().getActiveLayer() instanceof ImageryLayer)) {
            this.filterButton.setEnabled(false);
        } else {
            this.filterButton.setEnabled(true);
        }
    }

    public void layerAdded(LayerManager.LayerAddEvent e) {
        FiltersDialog dialog;
        if (this.filterButton == null) {
            FiltersDownloader.downloadFiltersInfoList();
            FiltersDownloader.initFilters();
            if (this.action == null) {
                this.action = new ShowFiltersDialogAction();
            }
            if (e.getAddedLayer() instanceof ImageryLayer) {
                this.filterButton = new SideButton((Action)this.action, false);
                this.filterButton.setEnabled(true);
            } else {
                this.filterButton = new SideButton((Action)this.action, false);
                this.filterButton.setEnabled(false);
            }
            dialog = LayerListDialog.getInstance();
            JPanel buttonRowPanel = (JPanel)((JPanel)dialog.getComponent(2)).getComponent(0);
            buttonRowPanel.add((Component)this.filterButton);
        }
        if (e.getAddedLayer() instanceof ImageryLayer) {
            dialog = new FiltersDialog((ImageryLayer)e.getAddedLayer());
            this.action.addFiltersDialog(dialog);
        }
    }

    public void layerRemoving(LayerManager.LayerRemoveEvent e) {
        if (e.getRemovedLayer() instanceof ImageryLayer) {
            FiltersDialog dialog = this.action.getDialogByLayer(e.getRemovedLayer());
            ((ImageryLayer)e.getRemovedLayer()).removeImageProcessor((ImageProcessor)dialog.getFiltersManager());
            dialog.closeFrame();
            this.action.removeFiltersDialog(dialog);
        }
        if (Main.getLayerManager().getLayers().isEmpty()) {
            Container container = this.filterButton.getParent();
            if (container != null) {
                container.remove((Component)this.filterButton);
            }
            FiltersDownloader.destroyFilters();
            this.filterButton = null;
        }
        Main.getLayerManager().removeLayerChangeListener((LayerManager.LayerChangeListener)this);
        Main.getLayerManager().removeActiveLayerChangeListener((MainLayerManager.ActiveLayerChangeListener)this);
    }

    public void layerOrderChanged(LayerManager.LayerOrderChangeEvent e) {
    }

    public PreferenceSetting getPreferenceSetting() {
        if (this.setting == null) {
            this.setting = new RasterFiltersPreferences();
        }
        return this.setting;
    }
}

