/*
 * Decompiled with CFR 0.152.
 */
package com.bric.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Stack;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Pattern;

public class Reflection {
    static Pattern longPattern = Pattern.compile("\\d+L");
    static Pattern intPattern = Pattern.compile("\\d+");
    static Pattern floatPattern = Pattern.compile("[0-9]*\\.?[0-9]+");
    static Pattern fieldPattern = Pattern.compile("([a-zA-Z_$][a-zA-Z\\d_$]*\\.)*[a-zA-Z_$][a-zA-Z\\d_$]*");
    static Pattern newPattern = Pattern.compile("new\\s+([a-zA-Z_$][a-zA-Z\\d_$]*\\.)*[a-zA-Z_$][a-zA-Z\\d_$]*\\(\\s*.*\\s*\\)");
    static Pattern methodPattern = Pattern.compile("([a-zA-Z_$][a-zA-Z\\d_$]*\\.)*[a-zA-Z_$][a-zA-Z\\d_$]*\\(\\s*.*\\s*\\)");
    static Pattern stringPattern = Pattern.compile("\"[\\.|[^\"]]*\"");
    public static final Object INVOCATION_ERROR = new Object();

    public static Object getFieldValue(String className, String fieldName) {
        try {
            Class<?> c = Class.forName(className);
            Field f = c.getField(fieldName);
            return f.get(null);
        }
        catch (Throwable t) {
            return null;
        }
    }

    protected static Object[] parseCommaSeparatedList(String arguments) {
        if (arguments.trim().length() == 0) {
            return new Object[0];
        }
        ArrayList<String> listElements = new ArrayList<String>();
        Stack<Character> constructs = new Stack<Character>();
        int startingIndex = 0;
        int i = 0;
        while (i < arguments.length()) {
            char ch = arguments.charAt(i);
            if (ch == ',' && constructs.size() == 0) {
                listElements.add(arguments.substring(startingIndex, i));
                startingIndex = i + 1;
            } else if (ch == '(' && (constructs.size() == 0 || ((Character)constructs.peek()).charValue() != '\"')) {
                constructs.add(Character.valueOf('('));
            } else if (ch == ')' && constructs.size() > 0 && ((Character)constructs.peek()).charValue() == '(') {
                constructs.pop();
            } else if (ch == '\"') {
                if (constructs.size() > 0 && ((Character)constructs.peek()).charValue() == '\"') {
                    constructs.pop();
                } else {
                    constructs.add(Character.valueOf('\"'));
                }
            } else if (ch == '\\' && constructs.size() > 0 && ((Character)constructs.peek()).charValue() == '\"') {
                ++i;
            }
            ++i;
        }
        listElements.add(arguments.substring(startingIndex));
        Object[] returnValue = new Object[listElements.size()];
        int a = 0;
        while (a < returnValue.length) {
            returnValue[a] = Reflection.parse(((String)listElements.get(a)).trim());
            ++a;
        }
        return returnValue;
    }

    public static Object parse(String input) {
        String string = input.trim();
        if ("true".equalsIgnoreCase(string)) {
            return Boolean.TRUE;
        }
        if ("false".equalsIgnoreCase(string)) {
            return Boolean.FALSE;
        }
        if ("null".equalsIgnoreCase(string)) {
            return null;
        }
        if (intPattern.matcher(string).matches()) {
            return Integer.parseInt(string);
        }
        if (longPattern.matcher(string).matches()) {
            return Long.parseLong(string);
        }
        if (floatPattern.matcher(string).matches()) {
            return Float.valueOf(Float.parseFloat(string));
        }
        if (stringPattern.matcher(string).matches()) {
            return string.substring(1, string.length() - 1);
        }
        if (newPattern.matcher(string).matches()) {
            string = string.substring(3).trim();
            int i1 = string.indexOf(40);
            int i2 = string.lastIndexOf(41);
            String className = string.substring(0, i1);
            String arguments = string.substring(i1 + 1, i2);
            try {
                Class<?> t = Class.forName(className);
                return Reflection.construct(t, arguments);
            }
            catch (ClassNotFoundException | IllegalArgumentException | SecurityException e) {
                throw new RuntimeException("An error occurred parsing \"" + input + "\" as a field.", e);
            }
        }
        if (methodPattern.matcher(string).matches()) {
            int i1 = string.indexOf(40);
            int i2 = string.lastIndexOf(41);
            String lhs = string.substring(0, i1);
            String arguments = string.substring(i1 + 1, i2);
            i1 = lhs.lastIndexOf(46);
            String className = lhs.substring(0, i1);
            String methodName = lhs.substring(i1 + 1);
            Object obj = null;
            try {
                Class<?> t = null;
                ArrayList<String> fieldNames = new ArrayList<String>();
                while (t == null) {
                    try {
                        t = Class.forName(className);
                    }
                    catch (ClassNotFoundException e) {
                        int i = className.lastIndexOf(46);
                        if (i == -1) break;
                        String fieldName = className.substring(i + 1);
                        className = className.substring(0, i);
                        fieldNames.add(fieldName);
                    }
                }
                int a = 0;
                while (a < fieldNames.size()) {
                    if (obj != null) {
                        t = obj.getClass();
                    }
                    obj = t.getField((String)fieldNames.get(0)).get(obj);
                    ++a;
                }
                if (obj != null) {
                    t = obj.getClass();
                }
                Method[] m = t.getMethods();
                int a2 = 0;
                while (a2 < m.length) {
                    boolean isStatic;
                    boolean bl = isStatic = (m[a2].getModifiers() | 8) > 0;
                    if (m[a2].getName().equals(methodName) && isStatic) {
                        return m[a2].invoke(obj, Reflection.parseCommaSeparatedList(arguments));
                    }
                    ++a2;
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException | InvocationTargetException e) {
                throw new RuntimeException("An error occurred parsing \"" + input + "\" as a method.", e);
            }
            throw new RuntimeException("Unrecognized method for " + input + "\"");
        }
        if (fieldPattern.matcher(string).matches()) {
            int i = string.lastIndexOf(46);
            String className = string.substring(0, i);
            if (className.length() == 0) {
                throw new RuntimeException("Unrecognized argument \"" + input + "\". An attempt was made to parse as a field name, but no identifying class name was found.");
            }
            String fieldName = string.substring(i + 1);
            try {
                Class<?> t = Class.forName(className);
                if (fieldName.equals("class")) {
                    return t;
                }
                Field f = t.getDeclaredField(fieldName);
                if ((f.getModifiers() & 8) == 0) {
                    throw new RuntimeException("Unrecognized argument \"" + input + "\". An attempt was made to parse as a field name, the field used was not static.");
                }
                return f.get(null);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                throw new RuntimeException("An error occurred parsing \"" + input + "\" as a field.", e);
            }
        }
        throw new RuntimeException("Unrecognized argument \"" + input + "\"");
    }

    protected static <T> T construct(Class<T> t, String arguments) {
        Object[] argumentObjects = Reflection.parseCommaSeparatedList(arguments);
        Constructor<?>[] constructors = t.getDeclaredConstructors();
        class Match
        implements Comparable<Match> {
            Constructor<?> constructor;
            Object[] literalArguments;
            Object[] convertedArguments;
            double score = 0.0;

            Match(Constructor<?> constructor, Class<?>[] idealArgTypes, Object[] arguments) throws IncompatibleArgumentsException {
                this.constructor = constructor;
                this.literalArguments = arguments;
                this.convertedArguments = new Object[this.literalArguments.length];
                int a = 0;
                while (a < idealArgTypes.length) {
                    Class<?> currentClass;
                    Class<?> clazz = currentClass = arguments[a] == null ? null : arguments[a].getClass();
                    if (idealArgTypes[a].equals(currentClass)) {
                        this.score += 1.0;
                        this.convertedArguments[a] = arguments[a];
                    } else if (this.isInteger(idealArgTypes[a]) && this.isInteger(currentClass)) {
                        this.score += 1.0;
                        this.convertedArguments[a] = arguments[a];
                    } else if (this.isLong(idealArgTypes[a]) && this.isLong(currentClass)) {
                        this.score += 1.0;
                        this.convertedArguments[a] = arguments[a];
                    } else if (this.isFloat(idealArgTypes[a]) && this.isFloat(currentClass)) {
                        this.score += 1.0;
                        this.convertedArguments[a] = arguments[a];
                    } else if (this.isShort(idealArgTypes[a]) && this.isShort(currentClass)) {
                        this.score += 1.0;
                        this.convertedArguments[a] = arguments[a];
                    } else if (this.isChar(idealArgTypes[a]) && this.isChar(currentClass)) {
                        this.score += 1.0;
                        this.convertedArguments[a] = arguments[a];
                    } else if (this.isBoolean(idealArgTypes[a]) && this.isBoolean(currentClass)) {
                        this.score += 1.0;
                        this.convertedArguments[a] = arguments[a];
                    } else if (!idealArgTypes[a].isPrimitive() && currentClass == null) {
                        this.score += 0.95;
                        this.convertedArguments[a] = null;
                    } else if (idealArgTypes[a].isAssignableFrom(currentClass)) {
                        this.score += 0.5;
                        this.convertedArguments[a] = arguments[a];
                    } else if (this.isLong(idealArgTypes[a]) && this.isInteger(currentClass)) {
                        this.score += 0.25;
                        this.convertedArguments[a] = new Long(((Integer)arguments[a]).longValue());
                    } else if (this.isDouble(idealArgTypes[a]) && this.isInteger(currentClass)) {
                        this.score += 0.25;
                        this.convertedArguments[a] = new Double(((Integer)arguments[a]).doubleValue());
                    } else if (this.isFloat(idealArgTypes[a]) && this.isInteger(currentClass)) {
                        this.score += 0.25;
                        this.convertedArguments[a] = new Float(((Integer)arguments[a]).floatValue());
                    } else if (this.isShort(idealArgTypes[a]) && this.isInteger(currentClass)) {
                        this.score += 0.25;
                        this.convertedArguments[a] = new Short(((Integer)arguments[a]).shortValue());
                    } else if (this.isDouble(idealArgTypes[a]) && this.isFloat(currentClass)) {
                        this.score += 0.15;
                        this.convertedArguments[a] = new Double(((Float)arguments[a]).doubleValue());
                    } else {
                        class IncompatibleArgumentsException
                        extends Exception {
                            private static final long serialVersionUID = 1L;

                            IncompatibleArgumentsException() {
                            }
                        }
                        throw new IncompatibleArgumentsException();
                    }
                    ++a;
                }
                this.score /= (double)idealArgTypes.length;
            }

            private boolean isInteger(Class<?> c) {
                return Integer.TYPE.equals(c) || Integer.class.equals(c);
            }

            private boolean isLong(Class<?> c) {
                return Long.TYPE.equals(c) || Long.class.equals(c);
            }

            private boolean isDouble(Class<?> c) {
                return Double.TYPE.equals(c) || Double.class.equals(c);
            }

            private boolean isFloat(Class<?> c) {
                return Float.TYPE.equals(c) || Float.class.equals(c);
            }

            private boolean isShort(Class<?> c) {
                return Short.TYPE.equals(c) || Short.class.equals(c);
            }

            private boolean isChar(Class<?> c) {
                return Character.TYPE.equals(c) || Character.class.equals(c);
            }

            private boolean isBoolean(Class<?> c) {
                return Boolean.TYPE.equals(c) || Boolean.class.equals(c);
            }

            @Override
            public int compareTo(Match o) {
                if (this.score < o.score) {
                    return -1;
                }
                if (this.score > o.score) {
                    return 1;
                }
                return 0;
            }
        }
        TreeSet<Match> matches = new TreeSet<Match>();
        Constructor<?>[] constructorArray = constructors;
        int n = constructors.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor<?> constructor = constructorArray[n2];
            Class<?>[] argT = constructor.getParameterTypes();
            if (argT.length == argumentObjects.length) {
                try {
                    matches.add(new Match(constructor, argT, argumentObjects));
                }
                catch (IncompatibleArgumentsException incompatibleArgumentsException) {
                    // empty catch block
                }
            }
            ++n2;
        }
        if (matches.size() > 0) {
            try {
                Match match = (Match)matches.last();
                match.constructor.setAccessible(true);
                return (T)match.constructor.newInstance(match.convertedArguments);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                throw new RuntimeException("an error occurred invoking a constructor for " + t.getName() + " using \"" + arguments + "\"", e);
            }
        }
        throw new RuntimeException("no constructor for " + t.getName() + " was found that matched \"" + arguments + "\"");
    }

    public static Object invokeMethod(Class<?> c, Object obj, String methodName, Object[] arguments) {
        try {
            Method[] methods = c.getMethods();
            int a = 0;
            while (a < methods.length) {
                if (methods[a].getName().equals(methodName)) {
                    try {
                        return methods[a].invoke(obj, arguments);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                ++a;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return INVOCATION_ERROR;
    }

    public static String nameStaticField(Class<?> c, Object value) {
        Object obj2;
        Field[] f = c.getDeclaredFields();
        Vector<Field> v = new Vector<Field>();
        int a = 0;
        while (a < f.length) {
            if ((f[a].getModifiers() & 8) > 0) {
                try {
                    f[a].setAccessible(true);
                    obj2 = f[a].get(null);
                    if (obj2 != null && obj2.equals(value)) {
                        v.add(f[a]);
                    }
                }
                catch (IllegalAccessException obj2) {
                    // empty catch block
                }
            }
            ++a;
        }
        if (v.size() == 0) {
            return null;
        }
        if (v.size() == 1) {
            return ((Field)v.get(0)).getName();
        }
        a = 0;
        while (a < v.size()) {
            try {
                obj2 = ((Field)v.get(a)).get(null);
                if (!obj2.getClass().equals(value.getClass())) {
                    v.remove(a);
                    continue;
                }
                ++a;
            }
            catch (IllegalAccessException e) {
                return "An unexpected error occurred the second time I tried to access a field.";
            }
        }
        if (v.size() == 1) {
            return ((Field)v.get(0)).getName();
        }
        if (v.size() > 1) {
            return Reflection.describe(v);
        }
        a = 0;
        while (a < v.size()) {
            try {
                obj2 = v.get(a).get(null);
                if (obj2.getClass().isInstance(value)) {
                    return v.get(a).getName();
                }
            }
            catch (IllegalAccessException e) {
                return "An unexpected error occurred the second time I tried to access a field.";
            }
            ++a;
        }
        return Reflection.describe(v);
    }

    private static String describe(Vector<Field> v) {
        String s = "[ " + v.get(0).getName();
        int a = 1;
        while (a < v.size()) {
            s = String.valueOf(s) + ", " + v.get(a).getName();
            ++a;
        }
        s = String.valueOf(s) + " ]";
        return s;
    }
}

