/*
 * Decompiled with CFR 0.152.
 */
package imageryadjust;

import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.util.TreeSet;
import javax.swing.Timer;
import org.openstreetmap.josm.Main;

public abstract class TimedKeyReleaseListener
implements AWTEventListener {
    private final TreeSet<Integer> set = new TreeSet();
    private Timer timer = new Timer(0, ae -> {
        this.timer.stop();
        if (this.set.remove(this.releaseEvent.getKeyCode())) {
            this.doKeyReleaseEvent(this.releaseEvent);
        }
    });
    protected KeyEvent releaseEvent;

    public TimedKeyReleaseListener() {
        try {
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 8L);
        }
        catch (SecurityException ex) {
            Main.error((Throwable)ex);
        }
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        if (!(event instanceof KeyEvent)) {
            return;
        }
        KeyEvent e = (KeyEvent)event;
        if (event.getID() == 401) {
            if (this.timer.isRunning()) {
                this.timer.stop();
            } else if (this.set.add(e.getKeyCode())) {
                this.doKeyPressEvent((KeyEvent)event);
            }
        }
        if (event.getID() == 402) {
            if (this.timer.isRunning()) {
                this.timer.stop();
                if (this.set.remove(e.getKeyCode())) {
                    this.doKeyReleaseEvent(e);
                }
            } else {
                this.releaseEvent = e;
                this.timer.restart();
            }
        }
    }

    public void stop() {
        try {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        }
        catch (SecurityException ex) {
            Main.error((Throwable)ex);
        }
    }

    protected abstract void doKeyReleaseEvent(KeyEvent var1);

    protected abstract void doKeyPressEvent(KeyEvent var1);
}

