/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.licenses;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Icon;
import org.openstreetmap.josm.plugins.opendata.core.licenses.LOOL;
import org.openstreetmap.josm.plugins.opendata.core.licenses.ODbL;
import org.openstreetmap.josm.plugins.opendata.core.util.OdUtils;

public abstract class License {
    public static final ODbL ODbL = new ODbL();
    public static final LOOL LOOL = new LOOL();
    private final Map<String, URL> urls = new HashMap<String, URL>();
    private final Map<String, URL> summaryURLs = new HashMap<String, URL>();
    private Icon icon;

    private static URL getURL(Map<String, URL> map) {
        String lang = OdUtils.getJosmLanguage();
        for (String l : map.keySet()) {
            if (!lang.startsWith(l)) continue;
            return map.get(l);
        }
        URL url = map.get("en");
        if (url != null) {
            return url;
        }
        if (map.keySet().size() > 0) {
            Iterator<String> it = map.keySet().iterator();
            while (it.hasNext()) {
                url = map.get(it.next());
                if (url == null) continue;
                return url;
            }
        }
        return null;
    }

    public URL getURL() {
        return License.getURL(this.urls);
    }

    public URL getSummaryURL() {
        return License.getURL(this.summaryURLs);
    }

    public final void setURL(URL url) {
        this.setURL(url, "en");
    }

    public final void setURL(String url, String lang) throws MalformedURLException {
        this.setURL(new URL(url), lang);
    }

    public final void setURL(String url) throws MalformedURLException {
        this.setURL(new URL(url), "en");
    }

    public final void setURL(URL url, String lang) {
        if (url != null) {
            this.urls.put(lang, url);
        }
    }

    public final void setSummaryURL(URL url) {
        this.setSummaryURL(url, "en");
    }

    public final void setSummaryURL(String url, String lang) throws MalformedURLException {
        this.setSummaryURL(new URL(url), lang);
    }

    public final void setSummaryURL(String url) throws MalformedURLException {
        this.setSummaryURL(new URL(url), "en");
    }

    public final void setSummaryURL(URL url, String lang) {
        if (url != null) {
            this.summaryURLs.put(lang, url);
        }
    }

    public final Icon getIcon() {
        return this.icon;
    }

    public final void setIcon(Icon icon) {
        this.icon = icon;
    }

    public String toString() {
        return "License [" + (this.urls != null ? "urls=" + this.urls + ", " : "") + (this.summaryURLs != null ? "summaryURLs=" + this.summaryURLs : "") + "]";
    }
}

