/*
 * Decompiled with CFR 0.152.
 */
package cadastre_fr;

import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.projection.Ellipsoid;

public class SimplifyWay {
    public void simplifyWay(Way w, double threshold) {
        Way wnew = new Way(w);
        this.simplifyWayRange(wnew, 0, wnew.getNodesCount() - 1, threshold);
        w.setNodes(wnew.getNodes());
    }

    public void simplifyWayRange(Way wnew, int from, int to, double thr) {
        if (to - from >= 2) {
            ArrayList<Node> ns = new ArrayList<Node>();
            this.simplifyWayRange(wnew, from, to, ns, thr);
            List nodes = wnew.getNodes();
            for (int j = to - 1; j > from; --j) {
                nodes.remove(j);
            }
            nodes.addAll(from + 1, ns);
            wnew.setNodes(nodes);
        }
    }

    public void simplifyWayRange(Way wnew, int from, int to, ArrayList<Node> ns, double thr) {
        Node fromN = wnew.getNode(from);
        Node toN = wnew.getNode(to);
        int imax = -1;
        double xtemax = 0.0;
        for (int i = from + 1; i < to; ++i) {
            Node n = wnew.getNode(i);
            double xte = Math.abs(Ellipsoid.WGS84.a * SimplifyWay.xtd(fromN.getCoor().lat() * Math.PI / 180.0, fromN.getCoor().lon() * Math.PI / 180.0, toN.getCoor().lat() * Math.PI / 180.0, toN.getCoor().lon() * Math.PI / 180.0, n.getCoor().lat() * Math.PI / 180.0, n.getCoor().lon() * Math.PI / 180.0));
            if (!(xte > xtemax)) continue;
            xtemax = xte;
            imax = i;
        }
        if (imax != -1 && xtemax >= thr) {
            this.simplifyWayRange(wnew, from, imax, ns, thr);
            ns.add(wnew.getNode(imax));
            this.simplifyWayRange(wnew, imax, to, ns, thr);
        }
    }

    public static double dist(double lat1, double lon1, double lat2, double lon2) {
        return 2.0 * Math.asin(Math.sqrt(Math.pow(Math.sin((lat1 - lat2) / 2.0), 2.0) + Math.cos(lat1) * Math.cos(lat2) * Math.pow(Math.sin((lon1 - lon2) / 2.0), 2.0)));
    }

    public static double course(double lat1, double lon1, double lat2, double lon2) {
        return Math.atan2(Math.sin(lon1 - lon2) * Math.cos(lat2), Math.cos(lat1) * Math.sin(lat2) - Math.sin(lat1) * Math.cos(lat2) * Math.cos(lon1 - lon2)) % (Math.PI * 2);
    }

    public static double xtd(double lat1, double lon1, double lat2, double lon2, double lat3, double lon3) {
        double dist_AD = SimplifyWay.dist(lat1, lon1, lat3, lon3);
        double crs_AD = SimplifyWay.course(lat1, lon1, lat3, lon3);
        double crs_AB = SimplifyWay.course(lat1, lon1, lat2, lon2);
        return Math.asin(Math.sin(dist_AD) * Math.sin(crs_AD - crs_AB));
    }
}

