/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.hot.sds;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.lang.reflect.Method;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.openstreetmap.hot.sds.SdsLoadAction;
import org.openstreetmap.hot.sds.SdsSaveAction;
import org.openstreetmap.hot.sds.SeparateDataStorePlugin;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.gui.layer.MainLayerManager;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.preferences.PreferenceDialog;
import org.openstreetmap.josm.tools.I18n;

public class SdsMenu
extends JMenu
implements LayerManager.LayerChangeListener,
MainLayerManager.ActiveLayerChangeListener {
    private JMenuItem saveItem;
    private JMenuItem loadItem;
    private JMenuItem prefsItem;
    private JMenuItem aboutItem;
    private JMenu menu;

    public SdsMenu(SeparateDataStorePlugin thePlugin) {
        MainMenu mm = Main.main.menu;
        this.menu = mm.addMenu("SDS", I18n.tr((String)"SDS", (Object[])new Object[0]), 83, mm.getDefaultMenuPos(), null);
        this.saveItem = new JMenuItem((Action)((Object)new SdsSaveAction()));
        this.menu.add(this.saveItem);
        this.loadItem = new JMenuItem((Action)((Object)new SdsLoadAction(thePlugin)));
        this.menu.add(this.loadItem);
        this.menu.addSeparator();
        this.prefsItem = new JMenuItem((Action)((Object)new SdsPreferencesAction()));
        this.menu.add(this.prefsItem);
        this.menu.addSeparator();
        this.aboutItem = new JMenuItem((Action)((Object)new SdsAboutAction()));
        this.menu.add(this.aboutItem);
        Main.getLayerManager().addLayerChangeListener((LayerManager.LayerChangeListener)this);
        Main.getLayerManager().addActiveLayerChangeListener((MainLayerManager.ActiveLayerChangeListener)this);
        this.setEnabledState();
    }

    void setEnabledState() {
        boolean en = Main.getLayerManager().getActiveLayer() instanceof OsmDataLayer;
        this.loadItem.setEnabled(en);
        this.saveItem.setEnabled(en);
    }

    public void activeOrEditLayerChanged(MainLayerManager.ActiveLayerChangeEvent e) {
        this.setEnabledState();
    }

    public void layerOrderChanged(LayerManager.LayerOrderChangeEvent e) {
    }

    public void layerAdded(LayerManager.LayerAddEvent e) {
        this.setEnabledState();
    }

    public void layerRemoving(LayerManager.LayerRemoveEvent e) {
        this.setEnabledState();
    }

    private static final class SdsPreferencesAction
    extends JosmAction
    implements Runnable {
        private SdsPreferencesAction() {
            super(I18n.tr((String)"Preferences...", (Object[])new Object[0]), "preference", I18n.tr((String)"Open a preferences dialog for SDS.", (Object[])new Object[0]), null, true);
            this.putValue("help", HelpUtil.ht((String)"/Action/Preferences"));
        }

        public void actionPerformed(ActionEvent e) {
            this.run();
        }

        @Override
        public void run() {
            PreferenceDialog pd = new PreferenceDialog(Main.parent);
            try {
                Method sptbn = pd.getClass().getMethod("selectPreferencesTabByName", String.class);
                sptbn.invoke((Object)pd, "sds");
            }
            catch (Exception ex) {
                Main.trace((Throwable)ex);
            }
            pd.setVisible(true);
        }
    }

    private static class SdsAboutAction
    extends JosmAction {
        SdsAboutAction() {
            super(I18n.tr((String)"About", (Object[])new Object[0]), "sds", I18n.tr((String)"Information about SDS.", (Object[])new Object[0]), null, true);
        }

        public void actionPerformed(ActionEvent e) {
            JPanel about = new JPanel();
            JTextArea l = new JTextArea();
            l.setLineWrap(true);
            l.setWrapStyleWord(true);
            l.setEditable(false);
            l.setText("Separate Data Store\n\nThis plugin provides access to a \"Separate Data Store\" server. Whenever data is loaded from the OSM API, it queries the SDS for additional tags that have been stored for the objects just loaded, and adds these tags. When you upload data to JOSM, SDS tags will again be separated and, instead of sending them to OSM, they will be uploaded to SDS.\n\nThis depends on SDS tags starting with a special prefix, which can be configured in the SDS preferences.\n\nUsing the SDS server will usually require an account to be set up there, which is completely independent of your OSM account.");
            l.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            l.setOpaque(false);
            l.setPreferredSize(new Dimension(500, 300));
            JScrollPane sp = new JScrollPane(l);
            sp.setBorder(null);
            sp.setOpaque(false);
            about.add(sp);
            about.setPreferredSize(new Dimension(500, 300));
            JOptionPane.showMessageDialog(Main.parent, about, I18n.tr((String)"About SDS...", (Object[])new Object[0]), 1, null);
        }
    }
}

