/*
 * Decompiled with CFR 0.152.
 */
package s57;

import java.io.BufferedReader;
import java.util.ArrayList;
import java.util.HashMap;
import s57.S57att;
import s57.S57map;
import s57.S57obj;
import s57.S57val;

public final class S57osm {
    private static final HashMap<String, KeyVal<?>> OSMtags = new HashMap();

    private S57osm() {
    }

    public static void OSMtag(ArrayList<KeyVal<?>> osm, String key, String val) {
        KeyVal<?> kv = OSMtags.get(key + "=" + val);
        if (kv != null) {
            if (kv.conv == S57val.Conv.E) {
                ArrayList<Enum> list = new ArrayList<Enum>();
                list.add((Enum)kv.val);
                osm.add(new KeyVal(kv.obj, kv.att, kv.conv, list));
            } else {
                osm.add(kv);
            }
        }
        KeyVal<?> kvl = null;
        KeyVal<?> kvd = null;
        boolean rc = false;
        boolean rcl = false;
        for (KeyVal<?> kvx : osm) {
            if (kvx.obj == S57obj.Obj.LAKARE) {
                kvl = kvx;
            } else if (kvx.obj == S57obj.Obj.RIVERS || kvx.obj == S57obj.Obj.CANALS) {
                rc = true;
            }
            if (kvx.obj == S57obj.Obj.DEPARE) {
                kvd = kvx;
                continue;
            }
            if (kvx.obj != S57obj.Obj.RIVERS && kvx.obj != S57obj.Obj.CANALS && kvx.obj != S57obj.Obj.LAKARE) continue;
            rcl = true;
        }
        if (rc && kvl != null) {
            osm.remove(kvl);
        }
        if (rcl && kvd != null) {
            osm.remove(kvd);
        }
    }

    public static void OSMmap(BufferedReader in, S57map map, boolean bb) throws Exception {
        String ln;
        String k = "";
        String v = "";
        double lat = 0.0;
        double lon = 0.0;
        long id = 0L;
        boolean inOsm = false;
        boolean inNode = false;
        boolean inWay = false;
        boolean inRel = false;
        map.nodes.put(1L, new S57map.Snode());
        map.nodes.put(2L, new S57map.Snode());
        map.nodes.put(3L, new S57map.Snode());
        map.nodes.put(4L, new S57map.Snode());
        while ((ln = in.readLine()) != null) {
            if (inOsm) {
                if (ln.contains("<bounds") && !bb) {
                    for (String token : ln.split("[ ]+")) {
                        if (token.matches("^minlat=.+")) {
                            ((S57map.Snode)map.nodes.get((Object)Long.valueOf((long)2L))).lat = map.bounds.minlat = Math.toRadians(Double.parseDouble(token.split("[\"']")[1]));
                            ((S57map.Snode)map.nodes.get((Object)Long.valueOf((long)3L))).lat = map.bounds.minlat;
                            continue;
                        }
                        if (token.matches("^minlon=.+")) {
                            ((S57map.Snode)map.nodes.get((Object)Long.valueOf((long)1L))).lon = map.bounds.minlon = Math.toRadians(Double.parseDouble(token.split("[\"']")[1]));
                            ((S57map.Snode)map.nodes.get((Object)Long.valueOf((long)2L))).lon = map.bounds.minlon;
                            continue;
                        }
                        if (token.matches("^maxlat=.+")) {
                            ((S57map.Snode)map.nodes.get((Object)Long.valueOf((long)1L))).lat = map.bounds.maxlat = Math.toRadians(Double.parseDouble(token.split("[\"']")[1]));
                            ((S57map.Snode)map.nodes.get((Object)Long.valueOf((long)4L))).lat = map.bounds.maxlat;
                            continue;
                        }
                        if (!token.matches("^maxlon=.+")) continue;
                        ((S57map.Snode)map.nodes.get((Object)Long.valueOf((long)3L))).lon = map.bounds.maxlon = Math.toRadians(Double.parseDouble(token.split("[\"']")[1]));
                        ((S57map.Snode)map.nodes.get((Object)Long.valueOf((long)4L))).lon = map.bounds.maxlon;
                    }
                    continue;
                }
                if ((inNode || inWay || inRel) && ln.contains("<tag")) {
                    v = "";
                    k = "";
                    String[] token = ln.split("k=");
                    k = token[1].split("[\"']")[1];
                    token = token[1].split("v=");
                    v = token[1].split("[\"']")[1];
                    if (!k.isEmpty() && !v.isEmpty()) {
                        map.addTag(k, v);
                    }
                }
                if (inNode) {
                    if (!ln.contains("</node")) continue;
                    inNode = false;
                    map.tagsDone(id);
                    continue;
                }
                if (ln.contains("<node")) {
                    for (String token : ln.split("[ ]+")) {
                        if (token.matches("^id=.+")) {
                            id = Long.parseLong(token.split("[\"']")[1]);
                            continue;
                        }
                        if (token.matches("^lat=.+")) {
                            lat = Double.parseDouble(token.split("[\"']")[1]);
                            continue;
                        }
                        if (!token.matches("^lon=.+")) continue;
                        lon = Double.parseDouble(token.split("[\"']")[1]);
                    }
                    map.addNode(id, lat, lon);
                    if (ln.contains("/>")) {
                        map.tagsDone(id);
                        continue;
                    }
                    inNode = true;
                    continue;
                }
                if (inWay) {
                    if (ln.contains("<nd")) {
                        long ref = 0L;
                        for (String token : ln.split("[ ]+")) {
                            if (!token.matches("^ref=.+")) continue;
                            ref = Long.parseLong(token.split("[\"']")[1]);
                        }
                        try {
                            map.addToEdge(ref);
                        }
                        catch (Exception e) {
                            inWay = false;
                        }
                    }
                    if (!ln.contains("</way")) continue;
                    inWay = false;
                    map.tagsDone(id);
                    continue;
                }
                if (ln.contains("<way")) {
                    for (String token : ln.split("[ ]+")) {
                        if (!token.matches("^id=.+")) continue;
                        id = Long.parseLong(token.split("[\"']")[1]);
                    }
                    map.addEdge(id);
                    if (ln.contains("/>")) {
                        map.tagsDone(0L);
                        continue;
                    }
                    inWay = true;
                    continue;
                }
                if (ln.contains("</osm")) {
                    map.mapDone();
                    inOsm = false;
                    break;
                }
                if (inRel) {
                    if (ln.contains("<member")) {
                        String type = "";
                        String role = "";
                        long ref = 0L;
                        for (String token : ln.split("[ ]+")) {
                            String[] str;
                            if (token.matches("^ref=.+")) {
                                ref = Long.parseLong(token.split("[\"']")[1]);
                                continue;
                            }
                            if (token.matches("^type=.+")) {
                                type = token.split("[\"']")[1];
                                continue;
                            }
                            if (!token.matches("^role=.+") || (str = token.split("[\"']")).length <= 1) continue;
                            role = token.split("[\"']")[1];
                        }
                        if ((role.equals("outer") || role.equals("inner")) && type.equals("way")) {
                            map.addToArea(ref, role.equals("outer"));
                        }
                    }
                    if (!ln.contains("</relation")) continue;
                    inRel = false;
                    map.tagsDone(id);
                    continue;
                }
                if (!ln.contains("<relation")) continue;
                for (String token : ln.split("[ ]+")) {
                    if (!token.matches("^id=.+")) continue;
                    id = Long.parseLong(token.split("[\"']")[1]);
                }
                map.addArea(id);
                if (ln.contains("/>")) {
                    map.tagsDone(id);
                    continue;
                }
                inRel = true;
                continue;
            }
            if (!ln.contains("<osm")) continue;
            inOsm = true;
        }
    }

    public static void OSMmeta(S57map map) {
        map.addEdge(++map.xref);
        for (long ref = 0L; ref <= 4L; ++ref) {
            map.addToEdge(ref == 0L ? 4L : ref);
        }
        map.addTag("seamark:type", "coverage");
        map.addTag("seamark:coverage:category", "coverage");
        map.tagsDone(map.xref);
    }

    static {
        OSMtags.put("natural=coastline", new KeyVal<Object>(S57obj.Obj.COALNE, S57att.Att.UNKATT, null, null));
        OSMtags.put("natural=water", new KeyVal<Object>(S57obj.Obj.LAKARE, S57att.Att.UNKATT, null, null));
        OSMtags.put("water=river", new KeyVal<Object>(S57obj.Obj.RIVERS, S57att.Att.UNKATT, null, null));
        OSMtags.put("water=canal", new KeyVal<Object>(S57obj.Obj.CANALS, S57att.Att.UNKATT, null, null));
        OSMtags.put("waterway=riverbank", new KeyVal<Object>(S57obj.Obj.RIVERS, S57att.Att.UNKATT, null, null));
        OSMtags.put("waterway=dock", new KeyVal<Object>(S57obj.Obj.HRBBSN, S57att.Att.UNKATT, null, null));
        OSMtags.put("waterway=lock", new KeyVal<Object>(S57obj.Obj.HRBBSN, S57att.Att.UNKATT, null, null));
        OSMtags.put("landuse=basin", new KeyVal<Object>(S57obj.Obj.LAKARE, S57att.Att.UNKATT, null, null));
        OSMtags.put("wetland=tidalflat", new KeyVal<Double>(S57obj.Obj.DEPARE, S57att.Att.DRVAL2, S57val.Conv.F, 0.0));
        OSMtags.put("tidal=yes", new KeyVal<Double>(S57obj.Obj.DEPARE, S57att.Att.DRVAL2, S57val.Conv.F, 0.0));
        OSMtags.put("natural=mud", new KeyVal<Object>(S57obj.Obj.DEPARE, S57att.Att.UNKATT, null, null));
        OSMtags.put("natural=sand", new KeyVal<Object>(S57obj.Obj.DEPARE, S57att.Att.UNKATT, null, null));
        OSMtags.put("highway=motorway", new KeyVal<S57val.CatROD>(S57obj.Obj.ROADWY, S57att.Att.CATROD, S57val.Conv.E, S57val.CatROD.ROD_MWAY));
        OSMtags.put("highway=trunk", new KeyVal<S57val.CatROD>(S57obj.Obj.ROADWY, S57att.Att.CATROD, S57val.Conv.E, S57val.CatROD.ROD_MAJR));
        OSMtags.put("highway=primary", new KeyVal<S57val.CatROD>(S57obj.Obj.ROADWY, S57att.Att.CATROD, S57val.Conv.E, S57val.CatROD.ROD_MAJR));
        OSMtags.put("highway=secondary", new KeyVal<S57val.CatROD>(S57obj.Obj.ROADWY, S57att.Att.CATROD, S57val.Conv.E, S57val.CatROD.ROD_MINR));
        OSMtags.put("highway=tertiary", new KeyVal<S57val.CatROD>(S57obj.Obj.ROADWY, S57att.Att.CATROD, S57val.Conv.E, S57val.CatROD.ROD_MINR));
        OSMtags.put("highway=residential", new KeyVal<Object>(S57obj.Obj.ROADWY, S57att.Att.UNKATT, null, null));
        OSMtags.put("highway=unclassified", new KeyVal<Object>(S57obj.Obj.ROADWY, S57att.Att.UNKATT, null, null));
        OSMtags.put("railway=rail", new KeyVal<Object>(S57obj.Obj.RAILWY, S57att.Att.UNKATT, null, null));
        OSMtags.put("man_made=breakwater", new KeyVal<Object>(S57obj.Obj.SLCONS, S57att.Att.UNKATT, null, null));
        OSMtags.put("man_made=groyne", new KeyVal<Object>(S57obj.Obj.SLCONS, S57att.Att.UNKATT, null, null));
        OSMtags.put("man_made=pier", new KeyVal<Object>(S57obj.Obj.SLCONS, S57att.Att.UNKATT, null, null));
        OSMtags.put("man_made=jetty", new KeyVal<Object>(S57obj.Obj.SLCONS, S57att.Att.UNKATT, null, null));
        OSMtags.put("landuse=industrial", new KeyVal<Object>(S57obj.Obj.BUAARE, S57att.Att.UNKATT, null, null));
        OSMtags.put("landuse=commercial", new KeyVal<Object>(S57obj.Obj.BUAARE, S57att.Att.UNKATT, null, null));
        OSMtags.put("landuse=retail", new KeyVal<Object>(S57obj.Obj.BUAARE, S57att.Att.UNKATT, null, null));
        OSMtags.put("landuse=residential", new KeyVal<Object>(S57obj.Obj.BUAARE, S57att.Att.UNKATT, null, null));
        OSMtags.put("place=city", new KeyVal<S57val.CatBUA>(S57obj.Obj.BUAARE, S57att.Att.CATBUA, S57val.Conv.E, S57val.CatBUA.BUA_CITY));
        OSMtags.put("place=town", new KeyVal<S57val.CatBUA>(S57obj.Obj.BUAARE, S57att.Att.CATBUA, S57val.Conv.E, S57val.CatBUA.BUA_TOWN));
        OSMtags.put("place=village", new KeyVal<S57val.CatBUA>(S57obj.Obj.BUAARE, S57att.Att.CATBUA, S57val.Conv.E, S57val.CatBUA.BUA_VLLG));
    }

    static class KeyVal<V> {
        S57obj.Obj obj;
        S57att.Att att;
        S57val.Conv conv;
        V val;

        KeyVal(S57obj.Obj o, S57att.Att a, S57val.Conv c, V v) {
            this.obj = o;
            this.att = a;
            this.conv = c;
            this.val = v;
        }
    }
}

