/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.tofix.controller;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.text.Collator;
import java.util.Collections;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonValue;
import org.openstreetmap.josm.plugins.tofix.bean.ListTaskBean;
import org.openstreetmap.josm.plugins.tofix.bean.TaskBean;
import org.openstreetmap.josm.plugins.tofix.util.Request;

public class ListTaskController {
    private final ListTaskBean listTasksBean = new ListTaskBean();
    private final String url;

    public ListTaskController() {
        this.url = "https://build-to-fix-production.mapbox.com/tasks";
    }

    public ListTaskBean getListTasksBean() {
        LinkedList<TaskBean> tasks = new LinkedList<TaskBean>();
        try (JsonReader jsonReader = Json.createReader((Reader)new StringReader(Request.sendGET(this.url)));){
            JsonObject jsonObject = jsonReader.readObject();
            JsonArray jsonArray = jsonObject.getJsonArray("tasks");
            for (JsonValue value : jsonArray) {
                TaskBean taskBean = new TaskBean();
                try (JsonReader jsonReader2 = Json.createReader((Reader)new StringReader(value.toString()));){
                    JsonObject jsontask = jsonReader2.readObject();
                    JsonObject valueJsontask = (JsonObject)jsontask.get((Object)"value");
                    if (valueJsontask != null) {
                        taskBean.setIdtask(jsontask.getString("idtask"));
                        taskBean.setIsCompleted(jsontask.getBoolean("isCompleted"));
                        taskBean.setIsAllItemsLoad(jsontask.getBoolean("isAllItemsLoad"));
                        taskBean.setIduser(jsontask.getString("iduser"));
                        taskBean.setName(valueJsontask.getString("name"));
                        taskBean.setDescription(valueJsontask.getString("description"));
                        taskBean.setUpdated(valueJsontask.getJsonNumber("updated").toString());
                        taskBean.setChangesetComment(valueJsontask.getString("changesetComment"));
                        JsonObject statsJsontask = (JsonObject)valueJsontask.get((Object)"stats");
                        if (statsJsontask != null) {
                            taskBean.setDate(statsJsontask.getJsonNumber("date").toString());
                            taskBean.setEdit(Integer.parseInt(statsJsontask.getJsonNumber("edit").toString()));
                            taskBean.setFixed(Integer.parseInt(statsJsontask.getJsonNumber("fixed").toString()));
                            taskBean.setSkip(Integer.parseInt(statsJsontask.getJsonNumber("skip").toString()));
                            taskBean.setType(statsJsontask.getString("type"));
                            taskBean.setItems(Integer.parseInt(statsJsontask.getJsonNumber("items").toString()));
                            taskBean.setNoterror(Integer.parseInt(statsJsontask.getJsonNumber("noterror").toString()));
                        }
                    }
                }
                tasks.add(taskBean);
            }
        }
        catch (IOException | NullPointerException ex) {
            Logger.getLogger(ListTaskController.class.getName()).log(Level.SEVERE, null, ex);
        }
        Collections.sort(tasks, (o1, o2) -> Collator.getInstance().compare(o1.getName(), o2.getName()));
        this.listTasksBean.setTasks(tasks);
        return this.listTasksBean;
    }
}

