/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.housenumbertool;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletingComboBox;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionListItem;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionManager;
import org.openstreetmap.josm.plugins.housenumbertool.Dto;
import org.openstreetmap.josm.tools.I18n;

public class TagDialog
extends ExtendedDialog {
    private static final String APPLY_CHANGES = I18n.tr((String)"Apply Changes", (Object[])new Object[0]);
    private static final String TAG_STREET_OR_PLACE = I18n.tr((String)"Use tag ''addr:street'' or ''addr:place''", (Object[])new Object[0]);
    private static final String TAG_BUILDING = "building";
    private static final String TAG_ADDR_COUNTRY = "addr:country";
    private static final String TAG_ADDR_STATE = "addr:state";
    private static final String TAG_ADDR_CITY = "addr:city";
    private static final String TAG_ADDR_POSTCODE = "addr:postcode";
    private static final String TAG_ADDR_HOUSENUMBER = "addr:housenumber";
    private static final String TAG_ADDR_STREET = "addr:street";
    private static final String TAG_ADDR_PLACE = "addr:place";
    private static final String[] BUILDING_STRINGS = new String[]{"yes", "apartments", "chapel", "church", "commercial", "dormitory", "hotel", "house", "residential", "terrace", "industrial", "retail", "warehouse", "cathedral", "civic", "hospital", "school", "train_station", "transportation", "university", "public", "bridge", "bunker", "cabin", "construction", "farm_auxiliary", "garage", "garages", "greenhouse", "hangar", "hut", "roof", "shed", "stable"};
    private static final int FPS_MIN = -2;
    private static final int FPS_MAX = 2;
    private static final Logger LOGGER = Logger.getLogger(TagDialog.class.getName());
    private String pluginDir;
    private AutoCompletionManager acm;
    private OsmPrimitive selection;
    private static final String TEMPLATE_DATA = "/template.data";
    private AutoCompletingComboBox country;
    private AutoCompletingComboBox state;
    private AutoCompletingComboBox city;
    private AutoCompletingComboBox postcode;
    private AutoCompletingComboBox street;
    private JTextField housnumber;
    private JCheckBox buildingEnabled;
    private JCheckBox countryEnabled;
    private JCheckBox stateEnabled;
    private JCheckBox cityEnabled;
    private JCheckBox zipEnabled;
    private JCheckBox streetEnabled;
    private JCheckBox housenumberEnabled;
    private JSlider housenumberChangeSequence;
    private JComboBox<String> building;
    private JRadioButton streetRadio;
    private JRadioButton placeRadio;

    public TagDialog(String pluginDir, OsmPrimitive selection) {
        super(Main.parent, I18n.tr((String)"House Number Editor", (Object[])new Object[0]), new String[]{I18n.tr((String)"OK", (Object[])new Object[0]), I18n.tr((String)"Cancel", (Object[])new Object[0])}, true);
        this.pluginDir = pluginDir;
        this.selection = selection;
        JPanel editPanel = this.createContentPane();
        this.setContent(editPanel);
        this.setButtonIcons(new String[]{"ok.png", "cancel.png"});
        this.setDefaultButton(1);
        this.setupDialog();
        this.getRootPane().setDefaultButton(this.defaultButton);
        this.setLocationRelativeTo(null);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TagDialog.this.housnumber.requestFocus();
                TagDialog.this.housnumber.selectAll();
            }
        });
    }

    private JPanel createContentPane() {
        this.acm = this.selection.getDataSet().getAutoCompletionManager();
        Dto dto = this.loadDto();
        JPanel editPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        this.buildingEnabled = new JCheckBox(TAG_BUILDING);
        this.buildingEnabled.setFocusable(false);
        this.buildingEnabled.setSelected(dto.isSaveBuilding());
        this.buildingEnabled.setToolTipText(APPLY_CHANGES);
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.gridwidth = 3;
        editPanel.add((Component)this.buildingEnabled, c);
        Arrays.sort(BUILDING_STRINGS);
        this.building = new JComboBox<String>(BUILDING_STRINGS);
        this.building.setSelectedItem(dto.getBuilding());
        this.building.setMaximumRowCount(50);
        c.gridx = 3;
        c.gridy = 0;
        c.weightx = 1.0;
        c.gridwidth = 1;
        editPanel.add(this.building, c);
        this.countryEnabled = new JCheckBox(TAG_ADDR_COUNTRY);
        this.countryEnabled.setFocusable(false);
        this.countryEnabled.setSelected(dto.isSaveCountry());
        this.countryEnabled.setToolTipText(APPLY_CHANGES);
        c = new GridBagConstraints();
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 0.0;
        c.gridwidth = 3;
        editPanel.add((Component)this.countryEnabled, c);
        this.country = new AutoCompletingComboBox();
        this.country.setPossibleACItems((Collection)this.acm.getValues(TAG_ADDR_COUNTRY));
        this.country.setPreferredSize(new Dimension(200, 24));
        this.country.setEditable(true);
        this.country.setSelectedItem((Object)dto.getCountry());
        c.fill = 2;
        c.gridx = 3;
        c.gridy = 1;
        c.weightx = 1.0;
        c.gridwidth = 1;
        editPanel.add((Component)this.country, c);
        this.stateEnabled = new JCheckBox(TAG_ADDR_STATE);
        this.stateEnabled.setFocusable(false);
        this.stateEnabled.setSelected(dto.isSaveState());
        this.stateEnabled.setToolTipText(APPLY_CHANGES);
        c = new GridBagConstraints();
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 2;
        c.weightx = 0.0;
        c.gridwidth = 3;
        editPanel.add((Component)this.stateEnabled, c);
        this.state = new AutoCompletingComboBox();
        this.state.setPossibleACItems((Collection)this.acm.getValues(TAG_ADDR_STATE));
        this.state.setPreferredSize(new Dimension(200, 24));
        this.state.setEditable(true);
        this.state.setSelectedItem((Object)dto.getState());
        c.fill = 2;
        c.gridx = 3;
        c.gridy = 2;
        c.weightx = 1.0;
        c.gridwidth = 1;
        editPanel.add((Component)this.state, c);
        this.cityEnabled = new JCheckBox(TAG_ADDR_CITY);
        this.cityEnabled.setFocusable(false);
        this.cityEnabled.setSelected(dto.isSaveCity());
        this.cityEnabled.setToolTipText(APPLY_CHANGES);
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 3;
        c.weightx = 0.0;
        c.gridwidth = 3;
        editPanel.add((Component)this.cityEnabled, c);
        this.city = new AutoCompletingComboBox();
        this.city.setPossibleACItems((Collection)this.acm.getValues(TAG_ADDR_CITY));
        this.city.setPreferredSize(new Dimension(200, 24));
        this.city.setEditable(true);
        this.city.setSelectedItem((Object)dto.getCity());
        c.fill = 2;
        c.gridx = 3;
        c.gridy = 3;
        c.weightx = 1.0;
        c.gridwidth = 1;
        editPanel.add((Component)this.city, c);
        this.zipEnabled = new JCheckBox(TAG_ADDR_POSTCODE);
        this.zipEnabled.setFocusable(false);
        this.zipEnabled.setSelected(dto.isSavePostcode());
        this.zipEnabled.setToolTipText(APPLY_CHANGES);
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 4;
        c.weightx = 0.0;
        c.gridwidth = 3;
        editPanel.add((Component)this.zipEnabled, c);
        this.postcode = new AutoCompletingComboBox();
        this.postcode.setPossibleACItems((Collection)this.acm.getValues(TAG_ADDR_POSTCODE));
        this.postcode.setPreferredSize(new Dimension(200, 24));
        this.postcode.setEditable(true);
        this.postcode.setSelectedItem((Object)dto.getPostcode());
        c.fill = 2;
        c.gridx = 3;
        c.gridy = 4;
        c.weightx = 1.0;
        c.gridwidth = 1;
        editPanel.add((Component)this.postcode, c);
        this.streetEnabled = new JCheckBox();
        this.streetEnabled.setFocusable(false);
        this.streetEnabled.setSelected(dto.isSaveStreet());
        this.streetEnabled.setToolTipText(APPLY_CHANGES);
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 5;
        c.weightx = 0.0;
        c.gridwidth = 1;
        editPanel.add((Component)this.streetEnabled, c);
        this.streetRadio = new JRadioButton(TAG_ADDR_STREET);
        this.streetRadio.setToolTipText(TAG_STREET_OR_PLACE);
        this.streetRadio.setSelected(dto.isTagStreet());
        this.streetRadio.addItemListener(new RadioChangeListener());
        c.fill = 2;
        c.gridx = 1;
        c.gridy = 5;
        c.weightx = 0.0;
        c.gridwidth = 1;
        editPanel.add((Component)this.streetRadio, c);
        this.placeRadio = new JRadioButton(TAG_ADDR_PLACE);
        this.placeRadio.setToolTipText(TAG_STREET_OR_PLACE);
        this.placeRadio.setSelected(!dto.isTagStreet());
        this.placeRadio.addItemListener(new RadioChangeListener());
        c.fill = 2;
        c.gridx = 2;
        c.gridy = 5;
        c.weightx = 0.0;
        c.gridwidth = 1;
        editPanel.add((Component)this.placeRadio, c);
        ButtonGroup g = new ButtonGroup();
        g.add(this.streetRadio);
        g.add(this.placeRadio);
        this.street = new AutoCompletingComboBox();
        if (dto.isTagStreet()) {
            this.street.setPossibleItems(this.getPossibleStreets());
        } else {
            this.street.setPossibleACItems((Collection)this.acm.getValues(TAG_ADDR_PLACE));
        }
        this.street.setPreferredSize(new Dimension(200, 24));
        this.street.setEditable(true);
        this.street.setSelectedItem((Object)dto.getStreet());
        c.fill = 2;
        c.gridx = 3;
        c.gridy = 5;
        c.weightx = 1.0;
        c.gridwidth = 1;
        editPanel.add((Component)this.street, c);
        this.housenumberEnabled = new JCheckBox(TAG_ADDR_HOUSENUMBER);
        this.housenumberEnabled.setFocusable(false);
        this.housenumberEnabled.setSelected(dto.isSaveHousenumber());
        this.housenumberEnabled.setToolTipText(APPLY_CHANGES);
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 6;
        c.weightx = 0.0;
        c.gridwidth = 3;
        editPanel.add((Component)this.housenumberEnabled, c);
        this.housnumber = new JTextField();
        this.housnumber.setPreferredSize(new Dimension(200, 24));
        int number = 0;
        try {
            number = Integer.valueOf(dto.getHousenumber()) + dto.getHousenumberChangeValue();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (number > 0) {
            this.housnumber.setText(String.valueOf(number));
        }
        c.fill = 2;
        c.gridx = 3;
        c.gridy = 6;
        c.weightx = 1.0;
        c.gridwidth = 1;
        editPanel.add((Component)this.housnumber, c);
        JLabel seqLabel = new JLabel(I18n.tr((String)"House number increment:", (Object[])new Object[0]));
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 7;
        c.weightx = 0.0;
        c.gridwidth = 3;
        editPanel.add((Component)seqLabel, c);
        this.housenumberChangeSequence = new JSlider(0, -2, 2, dto.getHousenumberChangeValue());
        this.housenumberChangeSequence.setPaintTicks(true);
        this.housenumberChangeSequence.setMajorTickSpacing(1);
        this.housenumberChangeSequence.setMinorTickSpacing(1);
        this.housenumberChangeSequence.setPaintLabels(true);
        this.housenumberChangeSequence.setSnapToTicks(true);
        c.gridx = 3;
        c.gridy = 7;
        c.weightx = 1.0;
        c.gridwidth = 1;
        editPanel.add((Component)this.housenumberChangeSequence, c);
        return editPanel;
    }

    protected void buttonAction(int buttonIndex, ActionEvent evt) {
        if (buttonIndex == 0) {
            Dto dto = new Dto();
            dto.setSaveBuilding(this.buildingEnabled.isSelected());
            dto.setSaveCity(this.cityEnabled.isSelected());
            dto.setSaveCountry(this.countryEnabled.isSelected());
            dto.setSaveState(this.stateEnabled.isSelected());
            dto.setSaveHousenumber(this.housenumberEnabled.isSelected());
            dto.setSavePostcode(this.zipEnabled.isSelected());
            dto.setSaveStreet(this.streetEnabled.isSelected());
            dto.setTagStreet(this.streetRadio.isSelected());
            dto.setBuilding((String)this.building.getSelectedItem());
            dto.setCity(this.getAutoCompletingComboBoxValue(this.city));
            dto.setCountry(this.getAutoCompletingComboBoxValue(this.country));
            dto.setHousenumber(this.housnumber.getText());
            dto.setPostcode(this.getAutoCompletingComboBoxValue(this.postcode));
            dto.setStreet(this.getAutoCompletingComboBoxValue(this.street));
            dto.setState(this.getAutoCompletingComboBoxValue(this.state));
            dto.setHousenumberChangeValue(this.housenumberChangeSequence.getValue());
            this.updateJOSMSelection(this.selection, dto);
            this.saveDto(dto);
        }
        this.setVisible(false);
    }

    private String getAutoCompletingComboBoxValue(AutoCompletingComboBox box) {
        Object item = box.getSelectedItem();
        if (item != null) {
            if (item instanceof String) {
                return (String)item;
            }
            if (item instanceof AutoCompletionListItem) {
                return ((AutoCompletionListItem)item).getValue();
            }
            return item.toString();
        }
        return "";
    }

    protected void saveDto(Dto dto) {
        File path = new File(this.pluginDir);
        File fileName = new File(this.pluginDir + TEMPLATE_DATA);
        try {
            path.mkdirs();
            try (FileOutputStream file = new FileOutputStream(fileName);
                 ObjectOutputStream o = new ObjectOutputStream(file);){
                o.writeObject(dto);
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, ex.getMessage());
            fileName.delete();
        }
    }

    protected void updateJOSMSelection(OsmPrimitive selection, Dto dto) {
        ChangePropertyCommand command;
        String value;
        ArrayList<ChangePropertyCommand> commands = new ArrayList<ChangePropertyCommand>();
        if (dto.isSaveBuilding() && ((value = selection.get(TAG_BUILDING)) == null || value != null && !value.equals(dto.getBuilding()))) {
            command = new ChangePropertyCommand(selection, TAG_BUILDING, dto.getBuilding());
            commands.add(command);
        }
        if (dto.isSaveCity() && ((value = selection.get(TAG_ADDR_CITY)) == null || value != null && !value.equals(dto.getCity()))) {
            command = new ChangePropertyCommand(selection, TAG_ADDR_CITY, dto.getCity());
            commands.add(command);
        }
        if (dto.isSaveCountry() && ((value = selection.get(TAG_ADDR_COUNTRY)) == null || value != null && !value.equals(dto.getCountry()))) {
            command = new ChangePropertyCommand(selection, TAG_ADDR_COUNTRY, dto.getCountry());
            commands.add(command);
        }
        if (dto.isSaveHousenumber() && ((value = selection.get(TAG_ADDR_HOUSENUMBER)) == null || value != null && !value.equals(dto.getHousenumber()))) {
            command = new ChangePropertyCommand(selection, TAG_ADDR_HOUSENUMBER, dto.getHousenumber());
            commands.add(command);
        }
        if (dto.isSavePostcode() && ((value = selection.get(TAG_ADDR_POSTCODE)) == null || value != null && !value.equals(dto.getPostcode()))) {
            command = new ChangePropertyCommand(selection, TAG_ADDR_POSTCODE, dto.getPostcode());
            commands.add(command);
        }
        if (dto.isSaveStreet()) {
            if (dto.isTagStreet()) {
                value = selection.get(TAG_ADDR_STREET);
                if (value == null || value != null && !value.equals(dto.getStreet())) {
                    command = new ChangePropertyCommand(selection, TAG_ADDR_STREET, dto.getStreet());
                    commands.add(command);
                    if (selection.get(TAG_ADDR_PLACE) != null) {
                        ChangePropertyCommand command2 = new ChangePropertyCommand(selection, TAG_ADDR_PLACE, null);
                        commands.add(command2);
                    }
                }
            } else {
                value = selection.get(TAG_ADDR_PLACE);
                if (value == null || value != null && !value.equals(dto.getStreet())) {
                    command = new ChangePropertyCommand(selection, TAG_ADDR_PLACE, dto.getStreet());
                    commands.add(command);
                    if (selection.get(TAG_ADDR_STREET) != null) {
                        ChangePropertyCommand command2 = new ChangePropertyCommand(selection, TAG_ADDR_STREET, null);
                        commands.add(command2);
                    }
                }
            }
        }
        if (dto.isSaveState() && ((value = selection.get(TAG_ADDR_STATE)) == null || value != null && !value.equals(dto.getState()))) {
            command = new ChangePropertyCommand(selection, TAG_ADDR_STATE, dto.getState());
            commands.add(command);
        }
        if (!commands.isEmpty()) {
            SequenceCommand sequenceCommand = new SequenceCommand(I18n.trn((String)"Updating properties of up to {0} object", (String)"Updating properties of up to {0} objects", (long)commands.size(), (Object[])new Object[]{commands.size()}), commands);
            Main.main.undoRedo.add((Command)sequenceCommand);
        }
    }

    private Collection<String> getPossibleStreets() {
        TreeSet<String> names = new TreeSet<String>();
        for (OsmPrimitive osm : Main.getLayerManager().getEditDataSet().allNonDeletedPrimitives()) {
            if (osm.getKeys() == null || !osm.keySet().contains("highway") || !osm.keySet().contains("name")) continue;
            names.add(osm.get("name"));
        }
        return names;
    }

    private Dto loadDto() {
        Dto dto;
        block27: {
            dto = new Dto();
            File fileName = new File(this.pluginDir + TEMPLATE_DATA);
            try {
                if (fileName.exists()) {
                    try (FileInputStream file = new FileInputStream(fileName);
                         ObjectInputStream o = new ObjectInputStream(file);){
                        dto = (Dto)o.readObject();
                        break block27;
                    }
                }
                dto.setCity(this.selection.get(TAG_ADDR_CITY));
                dto.setCountry(this.selection.get(TAG_ADDR_COUNTRY));
                dto.setHousenumber(this.selection.get(TAG_ADDR_HOUSENUMBER));
                dto.setPostcode(this.selection.get(TAG_ADDR_POSTCODE));
                dto.setStreet(this.selection.get(TAG_ADDR_STREET));
                dto.setState(this.selection.get(TAG_ADDR_STATE));
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, ex.getMessage());
                fileName.delete();
            }
        }
        return dto;
    }

    class RadioChangeListener
    implements ItemListener {
        RadioChangeListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (TagDialog.this.streetRadio.isSelected()) {
                TagDialog.this.street.setPossibleItems(TagDialog.this.getPossibleStreets());
            } else {
                TagDialog.this.street.setPossibleACItems((Collection)TagDialog.this.acm.getValues(TagDialog.TAG_ADDR_PLACE));
            }
        }
    }
}

